/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;

class MarkOccurrencesConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            MarkOccurrencesConfigurationBlock.this.fStore.setValue((String)MarkOccurrencesConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private StatusInfo fStatus;

    public MarkOccurrencesConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markTypeOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markMethodOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markConstantOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markFieldOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markLocalVariableOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markExceptionOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markMethodExitPoints"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markImplementors"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markBreakContinueTargets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "stickyOccurrences"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Link link = new Link(composite, 0);
        link.setText(PreferencesMessages.MarkOccurrencesConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.MarkOccurrencesConfigurationBlock_link_tooltip);
        this.addFiller(composite);
        String label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markOccurrences;
        Button master = this.addCheckBox(composite, label, "markOccurrences", 0);
        this.addFiller(composite);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markMethodOccurrences;
        Button slave = this.addCheckBox(composite, label, "markMethodOccurrences", 0);
        this.createDependency(master, "markMethodOccurrences", (Control)slave);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markConstantOccurrences;
        slave = this.addCheckBox(composite, label, "markConstantOccurrences", 0);
        this.createDependency(master, "markConstantOccurrences", (Control)slave);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markLocalVariableOccurrences;
        slave = this.addCheckBox(composite, label, "markLocalVariableOccurrences", 0);
        this.createDependency(master, "markLocalVariableOccurrences", (Control)slave);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markMethodExitPoints;
        slave = this.addCheckBox(composite, label, "markMethodExitPoints", 0);
        this.createDependency(master, "markMethodExitPoints", (Control)slave);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_markBreakContinueTargets;
        slave = this.addCheckBox(composite, label, "markBreakContinueTargets", 0);
        this.createDependency(master, "markBreakContinueTargets", (Control)slave);
        this.addFiller(composite);
        label = PreferencesMessages.MarkOccurrencesConfigurationBlock_stickyOccurrences;
        slave = this.addCheckBox(composite, label, "stickyOccurrences", 0);
        this.createDependency(master, "stickyOccurrences", (Control)slave);
        return composite;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        MarkOccurrencesConfigurationBlock.indent(slave);
        boolean masterState = this.fStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 10;
        control.setLayoutData((Object)gridData);
    }

    public void initialize() {
        this.initializeFields();
    }

    void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        this.initializeFields();
    }

    private void restoreFromPreferences() {
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    public void dispose() {
    }
}

