/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;

public class JavaSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];
    private final JavaSearchQuery fQuery;
    private final Map fElementsToParticipants;

    public JavaSearchResult(JavaSearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap();
        this.setActiveMatchFilters(JavaMatchFilter.getLastUsedFilters());
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        super.setActiveMatchFilters(filters);
        JavaMatchFilter.setLastUsedFilters(filters);
    }

    public MatchFilter[] getAllMatchFilters() {
        return JavaMatchFilter.allFilters(this.fQuery);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IAdaptable)file);
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        IFile file;
        IJavaScriptElement javaElement = (IJavaScriptElement)adaptable.getAdapter(IJavaScriptElement.class);
        HashSet matches = new HashSet();
        if (javaElement != null) {
            this.collectMatches(matches, javaElement);
        }
        if ((file = (IFile)adaptable.getAdapter(IFile.class)) != null) {
            this.collectMatches(matches, file);
        }
        if (!matches.isEmpty()) {
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set matches, IFile element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
    }

    private void collectMatches(Set matches, IJavaScriptElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaScriptElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                // empty catch block
            }
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IJavaScriptElement) {
            IJavaScriptElement javaElement = (IJavaScriptElement)element;
            IJavaScriptUnit cu = (IJavaScriptUnit)javaElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getResource();
            }
            IClassFile cf = (IClassFile)javaElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getResource();
            }
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IJavaScriptElement) {
            return (element = ((IJavaScriptElement)element).getOpenable()) != null && element.equals(editor.getEditorInput().getAdapter(IJavaScriptElement.class));
        }
        if (element instanceof IFile) {
            return element.equals(editor.getEditorInput().getAdapter(IFile.class));
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object element) {
        return (IMatchPresentation)this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            JavaScriptPlugin.log((IStatus)new Status(2, JavaScriptPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        JavaSearchResult javaSearchResult = this;
        synchronized (javaSearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

