/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddJavaDocStubOperation;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddJavaDocStubAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public AddJavaDocStubAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddJavaDocStubAction_label);
        this.setDescription(ActionMessages.AddJavaDocStubAction_description);
        this.setToolTipText(ActionMessages.AddJavaDocStubAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_javadoc_stub_action");
    }

    public AddJavaDocStubAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        this.setEnabled(members != null && members.length > 0);
    }

    public void run(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        if (members == null || members.length == 0) {
            return;
        }
        try {
            IJavaScriptUnit cu = members[0].getJavaScriptUnit();
            if (!ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)cu)) {
                return;
            }
            IEditorPart editor = JavaScriptUI.openInEditor((IJavaScriptElement)cu);
            if (ElementValidator.check((IJavaScriptElement[])members, this.getShell(), this.getDialogTitle(), false)) {
                this.run(cu, members);
            }
            JavaModelUtil.reconcile(cu);
            EditorUtility.revealInEditor(editor, (IJavaScriptElement)members[0]);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void run(ITextSelection selection) {
        try {
            int type;
            IJavaScriptElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), element)) {
                return;
            }
            int n = type = element != null ? element.getElementType() : -1;
            if (type != 9 && type != 7 && type != 8 && (element = SelectionConverter.getTypeAtOffset(this.fEditor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddJavaDocStubsAction_not_applicable);
                return;
            }
            IMember[] members = new IMember[]{(IMember)element};
            if (ElementValidator.checkValidateEdit((IJavaScriptElement[])members, this.getShell(), this.getDialogTitle())) {
                this.run(members[0].getJavaScriptUnit(), members);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
    }

    public void run(IJavaScriptUnit cu, IMember[] members) {
        try {
            AddJavaDocStubOperation op = new AddJavaDocStubOperation(members);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IMember[] getSelectedMembers(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IMember[] res = new IMember[nElements];
            IJavaScriptUnit cu = null;
            int i = 0;
            while (i < nElements) {
                IMember member;
                Object curr = elements.get(i);
                if (curr instanceof IFunction || curr instanceof IType || curr instanceof IField) {
                    member = (IMember)curr;
                    if (!member.exists()) {
                        return null;
                    }
                    if (i == 0 ? (cu = member.getJavaScriptUnit()) == null : !cu.equals(member.getJavaScriptUnit())) {
                        return null;
                    }
                    if (member instanceof IType && member.getElementName().length() == 0) {
                        return null;
                    }
                } else {
                    return null;
                }
                res[i] = member;
                ++i;
            }
            return res;
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.AddJavaDocStubsAction_error_dialogTitle;
    }
}

