/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.osgi.framework.Bundle;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected static Hashtable extensionPoints = new Hashtable();

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (RegistryReader.isActivated(element.getDeclaringExtension().getContributor().getName())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.ui", 4, NLS.bind((String)TeamUIMessages.RegistryReader_0, (Object)element.getNamespaceIdentifier(), (Object)element.getName()), (Throwable)e));
        }
    }

    private static boolean isActivated(String bundleId) {
        return RegistryReader.isActivated(Platform.getBundle((String)bundleId));
    }

    private static boolean isActivated(Bundle bundle) {
        return bundle != null && (bundle.getState() & 0x30) != 0;
    }

    protected RegistryReader() {
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespaceIdentifier() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        TeamUIPlugin.log(4, buf.toString(), null);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        Utils.Sorter sorter = new Utils.Sorter(){

            @Override
            public boolean compare(Object extension1, Object extension2) {
                String s1 = ((IExtension)extension1).getNamespaceIdentifier();
                String s2 = ((IExtension)extension2).getNamespaceIdentifier();
                return s2.compareToIgnoreCase(s1) > 0;
            }
        };
        Object[] sorted = sorter.sort(extensions);
        IExtension[] sortedExtension = new IExtension[sorted.length];
        System.arraycopy(sorted, 0, sortedExtension, 0, sorted.length);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        String pointId = String.valueOf(pluginId) + "-" + extensionPoint;
        IExtension[] extensions = (IExtension[])extensionPoints.get(pointId);
        if (extensions == null) {
            IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
            if (point == null) {
                return;
            }
            extensions = point.getExtensions();
            extensionPoints.put(pointId, extensions);
        }
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

