/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.wizards.GlobalSynchronizeWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class GlobalRefreshAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate,
ISynchronizeParticipantListener {
    public static final String NO_DEFAULT_PARTICPANT = "none";
    private MenuManager menuManager;
    private Action synchronizeAction;
    private IWorkbenchWindow window;
    private IAction actionProxy;
    private IHandlerActivation syncAll;
    private IHandlerActivation syncLatest;

    public void dispose() {
        IHandlerService hs;
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
        if (this.window != null && (hs = (IHandlerService)this.window.getService(IHandlerService.class)) != null) {
            if (this.syncAll != null) {
                hs.deactivateHandler(this.syncAll);
            }
            if (this.syncLatest != null) {
                hs.deactivateHandler(this.syncLatest);
            }
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        Menu fMenu = null;
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            fMenu = this.menuManager.createContextMenu(parent);
            this.menuManager.removeAll();
            ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
            int i = 0;
            while (i < participants.length) {
                ISynchronizeParticipantReference description = participants[i];
                RefreshParticipantAction action = new RefreshParticipantAction(i + 1, description);
                this.menuManager.add((IAction)action);
                ++i;
            }
            if (participants.length > 0) {
                this.menuManager.add((IContributionItem)new Separator());
            }
            this.menuManager.add((IAction)this.synchronizeAction);
        } else {
            fMenu = this.menuManager.getMenu();
        }
        return fMenu;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.synchronizeAction = new Action(TeamUIMessages.GlobalRefreshAction_4){

            public void run() {
                GlobalSynchronizeWizard wizard = new GlobalSynchronizeWizard();
                WizardDialog dialog = new WizardDialog(GlobalRefreshAction.this.window.getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
        this.synchronizeAction.setImageDescriptor(TeamImages.getImageDescriptor("elcl18/synch_participants.png"));
        this.synchronizeAction.setActionDefinitionId("org.eclipse.team.ui.synchronizeAll");
        IHandlerService hs = (IHandlerService)window.getService(IHandlerService.class);
        if (hs != null) {
            AbstractHandler handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    GlobalRefreshAction.this.synchronizeAction.run();
                    return null;
                }
            };
            this.syncAll = hs.activateHandler("org.eclipse.team.ui.synchronizeAll", (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    GlobalRefreshAction.this.run();
                    return null;
                }
            };
            this.syncLatest = hs.activateHandler("org.eclipse.team.ui.synchronizeLast", (IHandler)handler);
        }
        this.setMenuCreator(this);
        TeamUI.getSynchronizeManager().addSynchronizeParticipantListener(this);
    }

    public void run() {
        String id = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant");
        String secondaryId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant_sec_id");
        ISynchronizeParticipantReference participant = TeamUI.getSynchronizeManager().get(id, secondaryId);
        if (participant != null) {
            this.run(participant);
        } else {
            this.synchronizeAction.run();
        }
    }

    public void run(IAction action) {
        this.run();
        this.actionProxy = action;
        this.updateTooltipText();
    }

    private void run(ISynchronizeParticipantReference participant) {
        try {
            ISynchronizeParticipant p = participant.getParticipant();
            p.run(null);
            this.updateTooltipText();
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    @Override
    public void participantsAdded(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GlobalRefreshAction.this.menuManager != null) {
                    GlobalRefreshAction.this.menuManager.dispose();
                    GlobalRefreshAction.this.menuManager = null;
                }
                GlobalRefreshAction.this.updateTooltipText();
            }
        });
    }

    @Override
    public void participantsRemoved(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GlobalRefreshAction.this.menuManager != null) {
                    GlobalRefreshAction.this.menuManager.dispose();
                    GlobalRefreshAction.this.menuManager = null;
                }
                GlobalRefreshAction.this.updateTooltipText();
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.actionProxy = action;
    }

    protected void updateTooltipText() {
        if (this.actionProxy != null) {
            ISynchronizeParticipantReference ref;
            String id = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant");
            String secondaryId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant_sec_id");
            if (!id.equals(NO_DEFAULT_PARTICPANT) && (ref = TeamUI.getSynchronizeManager().get(id, secondaryId)) != null) {
                this.actionProxy.setToolTipText(NLS.bind((String)TeamUIMessages.GlobalRefreshAction_5, (Object[])new String[]{ref.getDisplayName()}));
                return;
            }
            this.actionProxy.setToolTipText(TeamUIMessages.GlobalRefreshAction_4);
        }
    }

    class RefreshParticipantAction
    extends Action {
        private ISynchronizeParticipantReference participant;

        public void run() {
            TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.participant.getId());
            TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.participant.getSecondaryId());
            GlobalRefreshAction.this.run(this.participant);
        }

        public RefreshParticipantAction(int prefix, ISynchronizeParticipantReference participant) {
            super("&" + prefix + " " + Utils.shortenText(100, participant.getDisplayName()));
            this.participant = participant;
            this.setImageDescriptor(participant.getDescriptor().getImageDescriptor());
        }
    }
}

