/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;

public class DocumentRangeNode
implements IDocumentRange,
IStructureComparator,
IEditableContent,
IEncodedStreamContentAccessor,
IAdaptable,
IEditableContentExtension {
    private static final String UTF_16 = "UTF-16";
    private IDocument fBaseDocument;
    private Position fRange;
    private int fTypeCode;
    private String fID;
    private Position fAppendPosition;
    private ArrayList<DocumentRangeNode> fChildren;
    private final DocumentRangeNode fParent;

    public DocumentRangeNode(int typeCode, String id, IDocument document, int start, int length) {
        this(null, typeCode, id, document, start, length);
    }

    public DocumentRangeNode(DocumentRangeNode parent, int typeCode, String id, IDocument document, int start, int length) {
        this.fParent = parent;
        this.fTypeCode = typeCode;
        this.fID = id;
        this.fBaseDocument = document;
        this.registerPositionUpdater(start, length);
    }

    private void registerPositionUpdater(int start, int length) {
        this.fBaseDocument.addPositionCategory("DocumentRangeCategory");
        this.fRange = new Position(start, length);
        try {
            this.fBaseDocument.addPosition("DocumentRangeCategory", this.fRange);
        }
        catch (BadPositionCategoryException ex) {
            CompareUIPlugin.log(ex);
        }
        catch (BadLocationException ex) {
            CompareUIPlugin.log(ex);
        }
    }

    @Override
    public IDocument getDocument() {
        return this.fBaseDocument;
    }

    @Override
    public Position getRange() {
        return this.fRange;
    }

    public int getTypeCode() {
        return this.fTypeCode;
    }

    public String getId() {
        return this.fID;
    }

    public void setId(String id) {
        this.fID = id;
    }

    public void addChild(DocumentRangeNode node) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(node);
    }

    @Override
    public Object[] getChildren() {
        if (this.fChildren != null) {
            return this.fChildren.toArray();
        }
        return new Object[0];
    }

    public void setLength(int length) {
        this.getRange().setLength(length);
    }

    public void setAppendPosition(int pos) {
        if (this.fAppendPosition != null) {
            try {
                this.fBaseDocument.removePosition("DocumentRangeCategory", this.fAppendPosition);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        try {
            if (pos <= this.getDocument().getLength()) {
                Position p = new Position(pos);
                this.fBaseDocument.addPosition("DocumentRangeCategory", p);
                this.fAppendPosition = p;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Position getAppendPosition() {
        if (this.fAppendPosition == null) {
            try {
                Position p = new Position(this.fBaseDocument.getLength());
                this.fBaseDocument.addPosition("DocumentRangeCategory", p);
                this.fAppendPosition = p;
                return this.fAppendPosition;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return new Position(this.fBaseDocument.getLength());
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DocumentRangeNode tn = (DocumentRangeNode)other;
            return this.fTypeCode == tn.fTypeCode && this.fID.equals(tn.fID);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.fID.hashCode();
    }

    private Position findCorrespondingPosition(DocumentRangeNode otherParent, DocumentRangeNode child) {
        int ix;
        if (child != null && this.fChildren != null && (ix = otherParent.fChildren.indexOf(child)) >= 0) {
            int i2;
            DocumentRangeNode c1;
            int i = ix - 1;
            while (i >= 0) {
                c1 = otherParent.fChildren.get(i);
                i2 = this.fChildren.indexOf(c1);
                if (i2 >= 0) {
                    DocumentRangeNode c = this.fChildren.get(i2);
                    Position p = c.fRange;
                    Position po = new Position(p.getOffset() + p.getLength() + 1, 0);
                    return po;
                }
                --i;
            }
            i = ix;
            while (i < otherParent.fChildren.size()) {
                c1 = otherParent.fChildren.get(i);
                i2 = this.fChildren.indexOf(c1);
                if (i2 >= 0) {
                    DocumentRangeNode c = this.fChildren.get(i2);
                    Position p = c.fRange;
                    Position po = new Position(p.getOffset(), 0);
                    return po;
                }
                ++i;
            }
        }
        return this.getAppendPosition();
    }

    private void add(String s, DocumentRangeNode parent, DocumentRangeNode child) {
        Position p = this.findCorrespondingPosition(parent, child);
        if (p != null) {
            try {
                this.fBaseDocument.replace(p.getOffset(), p.getLength(), s);
            }
            catch (BadLocationException ex) {
                CompareUIPlugin.log(ex);
            }
        }
    }

    @Override
    public InputStream getContents() {
        String s;
        try {
            s = this.fBaseDocument.get(this.fRange.getOffset(), this.fRange.getLength());
        }
        catch (BadLocationException ex) {
            s = "";
        }
        return new ByteArrayInputStream(Utilities.getBytes(s, UTF_16));
    }

    @Override
    public boolean isEditable() {
        if (this.fParent != null) {
            return this.fParent.isEditable();
        }
        return true;
    }

    @Override
    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        if (this.fParent == null) {
            DocumentRangeNode src = null;
            String srcContents = "";
            if (other != null) {
                src = (DocumentRangeNode)((Object)child);
                if (other instanceof IStreamContentAccessor) {
                    try {
                        srcContents = Utilities.readString((IStreamContentAccessor)((Object)other));
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                    }
                }
            }
            if (child == null) {
                this.add(srcContents, null, src);
            }
        }
        this.nodeChanged(this);
        return child;
    }

    @Override
    public void setContent(byte[] content) {
        this.internalSetContents(content);
        this.nodeChanged(this);
    }

    protected void internalSetContents(byte[] content) {
    }

    @Override
    public String getCharset() {
        return UTF_16;
    }

    protected void nodeChanged(DocumentRangeNode node) {
        if (this.fParent != null) {
            this.fParent.nodeChanged(node);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISharedDocumentAdapter.class && this.fParent != null) {
            return this.fParent.getAdapter(adapter);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public boolean isReadOnly() {
        if (this.fParent != null) {
            return this.fParent.isReadOnly();
        }
        return false;
    }

    @Override
    public IStatus validateEdit(Shell shell) {
        if (this.fParent != null) {
            return this.fParent.validateEdit(shell);
        }
        return Status.OK_STATUS;
    }

    public Object getParentNode() {
        return this.fParent;
    }
}

