/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation.core.errorinfo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidationUIMessages;
import org.eclipse.wst.xml.ui.internal.validation.core.errorinfo.ReferencedFileErrorDialog;

public class ReferencedFileErrorsHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMarker[] selectedMarkers = this.getSelectedMarkers(event);
        IMarker selectedMarker = selectedMarkers[0];
        if (selectedMarker != null) {
            try {
                IResource resource = selectedMarker.getResource();
                Map map = (Map)resource.getSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME);
                if (map == null) {
                    String infoUnavailable = XMLValidationUIMessages._UI_DETAILS_INFORMATION_UNAVAILABLE;
                    String revalidateToRegenerateErrors = XMLValidationUIMessages._UI_DETAILS_INFO_REVALIDATE_TO_REGENERATE;
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)infoUnavailable, (String)revalidateToRegenerateErrors);
                } else {
                    String uri = null;
                    String groupName = (String)selectedMarker.getAttribute("groupName");
                    if (groupName.startsWith("referencedFileError")) {
                        int index1 = groupName.indexOf("(");
                        int index2 = groupName.lastIndexOf(")");
                        if (index1 != -1 && index2 > index1) {
                            uri = groupName.substring(index1 + 1, index2);
                        }
                    }
                    if (uri != null) {
                        IPath resourceLocation;
                        List list = Collections.EMPTY_LIST;
                        ValidationMessage message = (ValidationMessage)map.get(uri);
                        if (message != null) {
                            list = message.getNestedMessages();
                        }
                        if ((resourceLocation = resource.getLocation()) != null) {
                            String validatedFileURI = resourceLocation.toOSString();
                            validatedFileURI = "file:/" + validatedFileURI;
                            ReferencedFileErrorDialog dialog = new ReferencedFileErrorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), list, validatedFileURI, uri);
                            dialog.createAndOpen();
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this;
    }
}

