/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

@Deprecated
public abstract class WizardExportPage
extends WizardDataTransferPage {
    private IStructuredSelection currentResourceSelection;
    private List selectedResources;
    private List selectedTypes;
    private boolean exportCurrentSelection = false;
    private boolean exportAllResourcesPreSet = false;
    private Combo typesToExportField;
    private Button typesToExportEditButton;
    private Button exportAllTypesRadio;
    private Button exportSpecifiedTypesRadio;
    private Button resourceDetailsButton;
    private Label resourceDetailsDescription;
    private Text resourceNameField;
    private Button resourceBrowseButton;
    private boolean initialExportAllTypesValue = true;
    private String initialExportFieldValue;
    private String initialTypesFieldValue;
    private static final String CURRENT_SELECTION = "<current selection>";
    private static final String TYPE_DELIMITER = ",";
    private static final String STORE_SELECTED_TYPES_ID = "WizardFileSystemExportPage1.STORE_SELECTED_TYPES_ID.";
    private static final String STORE_EXPORT_ALL_RESOURCES_ID = "WizardFileSystemExportPage1.STORE_EXPORT_ALL_RESOURCES_ID.";

    protected WizardExportPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.currentResourceSelection = selection;
    }

    @Override
    protected boolean allowNewContainerName() {
        return false;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createBoldLabel(composite, IDEWorkbenchMessages.WizardExportPage_whatLabel);
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, IDEWorkbenchMessages.WizardExportPage_whereLabel);
        this.createDestinationGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, IDEWorkbenchMessages.WizardExportPage_options);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.currentResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    protected abstract void createDestinationGroup(Composite var1);

    protected final void createSourceGroup(Composite parent) {
        Composite sourceGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceGroup.setLayout((Layout)layout);
        sourceGroup.setLayoutData((Object)new GridData(272));
        new Label(sourceGroup, 0).setText(IDEWorkbenchMessages.WizardExportPage_folder);
        this.resourceNameField = new Text(sourceGroup, 2052);
        this.resourceNameField.addListener(1, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.resourceNameField.setLayoutData((Object)data);
        this.resourceBrowseButton = new Button(sourceGroup, 8);
        this.resourceBrowseButton.setText(IDEWorkbenchMessages.WizardExportPage_browse);
        this.resourceBrowseButton.addListener(13, (Listener)this);
        this.resourceBrowseButton.setLayoutData((Object)new GridData(768));
        this.exportAllTypesRadio = new Button(sourceGroup, 16);
        this.exportAllTypesRadio.setText(IDEWorkbenchMessages.WizardExportPage_allTypes);
        this.exportAllTypesRadio.addListener(13, (Listener)this);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.exportAllTypesRadio.setLayoutData((Object)data);
        this.exportSpecifiedTypesRadio = new Button(sourceGroup, 16);
        this.exportSpecifiedTypesRadio.setText(IDEWorkbenchMessages.WizardExportPage_specificTypes);
        this.exportSpecifiedTypesRadio.addListener(13, (Listener)this);
        this.typesToExportField = new Combo(sourceGroup, 0);
        data = new GridData(768);
        data.widthHint = 250;
        this.typesToExportField.setLayoutData((Object)data);
        this.typesToExportField.addListener(24, (Listener)this);
        this.typesToExportEditButton = new Button(sourceGroup, 8);
        this.typesToExportEditButton.setText(IDEWorkbenchMessages.WizardExportPage_edit);
        this.typesToExportEditButton.setLayoutData((Object)new GridData(776));
        this.typesToExportEditButton.addListener(13, (Listener)this);
        this.resourceDetailsButton = new Button(sourceGroup, 8);
        this.resourceDetailsButton.setText(IDEWorkbenchMessages.WizardExportPage_details);
        this.resourceDetailsButton.addListener(13, (Listener)this);
        this.resourceDetailsDescription = new Label(sourceGroup, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.resourceDetailsDescription.setLayoutData((Object)data);
        this.resetSelectedResources();
        this.exportAllTypesRadio.setSelection(this.initialExportAllTypesValue);
        this.exportSpecifiedTypesRadio.setSelection(!this.initialExportAllTypesValue);
        this.typesToExportField.setEnabled(!this.initialExportAllTypesValue);
        this.typesToExportEditButton.setEnabled(!this.initialExportAllTypesValue);
        if (this.initialExportFieldValue != null) {
            this.resourceNameField.setText(this.initialExportFieldValue);
        }
        if (this.initialTypesFieldValue != null) {
            this.typesToExportField.setText(this.initialTypesFieldValue);
        }
    }

    @Override
    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardExportPage_errorDialogTitle, (String)message, (int)0x10000000);
    }

    protected void displayResourcesSelectedCount(int selectedResourceCount) {
        if (selectedResourceCount == 1) {
            this.resourceDetailsDescription.setText(IDEWorkbenchMessages.WizardExportPage_oneResourceSelected);
        } else {
            this.resourceDetailsDescription.setText(NLS.bind((String)IDEWorkbenchMessages.WizardExportPage_resourceCountMessage, (Object)selectedResourceCount));
        }
    }

    @Deprecated
    protected boolean ensureResourcesLocal(List resources) {
        return true;
    }

    protected List extractNonLocalResources(List originalList) {
        Vector<IResource> result = new Vector<IResource>(originalList.size());
        for (IResource currentResource : originalList) {
            if (currentResource.isLocal(0)) continue;
            result.addElement(currentResource);
        }
        return result;
    }

    public boolean getExportAllTypesValue() {
        if (this.exportAllTypesRadio == null) {
            return this.initialExportAllTypesValue;
        }
        return this.exportAllTypesRadio.getSelection();
    }

    public String getResourceFieldValue() {
        if (this.resourceNameField == null) {
            return this.initialExportFieldValue;
        }
        return this.resourceNameField.getText();
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.resourceNameField);
    }

    protected List getSelectedResources() {
        IResource sourceResource;
        if (this.selectedResources == null && (sourceResource = this.getSourceResource()) != null) {
            this.selectAppropriateResources(sourceResource);
        }
        return this.selectedResources;
    }

    protected IResource getSourceResource() {
        IPath testPath;
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus result = workspace.validatePath((testPath = this.getResourcePath()).toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(testPath)) {
            return workspace.getRoot().findMember(testPath);
        }
        return null;
    }

    public String getTypesFieldValue() {
        if (this.typesToExportField == null) {
            return this.initialTypesFieldValue;
        }
        return this.typesToExportField.getText();
    }

    protected List getTypesToExport() {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.typesToExportField.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            result.add(currentExtension);
        }
        return result;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.exportAllTypesRadio || source == this.typesToExportField || source == this.resourceNameField) {
            this.resetSelectedResources();
        } else if (source == this.exportSpecifiedTypesRadio) {
            this.resetSelectedResources();
            this.typesToExportField.setFocus();
        } else if (source == this.resourceDetailsButton) {
            this.handleResourceDetailsButtonPressed();
        } else if (source == this.resourceBrowseButton) {
            this.handleResourceBrowseButtonPressed();
        } else if (source == this.typesToExportEditButton) {
            this.handleTypesEditButtonPressed();
        }
        this.setPageComplete(this.determinePageCompletion());
        this.updateWidgetEnablements();
    }

    protected void handleResourceBrowseButtonPressed() {
        String relativePath;
        IPath containerPath;
        IResource currentFolder = this.getSourceResource();
        if (currentFolder != null && currentFolder.getType() == 1) {
            currentFolder = currentFolder.getParent();
        }
        if ((containerPath = this.queryForContainer((IContainer)currentFolder, IDEWorkbenchMessages.WizardExportPage_selectResourcesToExport)) != null && !(relativePath = containerPath.makeRelative().toString()).toString().equals(this.resourceNameField.getText())) {
            this.resetSelectedResources();
            this.resourceNameField.setText(relativePath);
        }
    }

    protected void handleResourceDetailsButtonPressed() {
        Object[] newlySelectedResources;
        IResource source = this.getSourceResource();
        if (source == null) {
            source = ResourcesPlugin.getWorkspace().getRoot();
        }
        this.selectAppropriateResources(source);
        if (source instanceof IFile) {
            source = ((IFile)source).getParent();
            this.setResourceToDisplay(source);
        }
        if ((newlySelectedResources = this.queryIndividualResourcesToExport((IAdaptable)source)) != null) {
            this.selectedResources = Arrays.asList(newlySelectedResources);
            this.displayResourcesSelectedCount(this.selectedResources.size());
        }
    }

    protected void handleTypesEditButtonPressed() {
        Object[] newSelectedTypes = this.queryResourceTypesToExport();
        if (newSelectedTypes != null) {
            ArrayList<String> result = new ArrayList<String>(newSelectedTypes.length);
            Object[] objectArray = newSelectedTypes;
            int n = newSelectedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object newSelectedType = objectArray[n2];
                result.add(((IFileEditorMapping)newSelectedType).getExtension());
                ++n2;
            }
            this.setTypesToExport(result);
        }
    }

    protected boolean hasExportableExtension(String resourceName) {
        if (this.selectedTypes == null) {
            return true;
        }
        int separatorIndex = resourceName.lastIndexOf(".");
        if (separatorIndex == -1) {
            return false;
        }
        String extension = resourceName.substring(separatorIndex + 1);
        Iterator it = this.selectedTypes.iterator();
        while (it.hasNext()) {
            if (!extension.equalsIgnoreCase((String)it.next())) continue;
            return true;
        }
        return false;
    }

    protected void internalSaveWidgetValues() {
    }

    protected Object[] queryIndividualResourcesToExport(IAdaptable rootResource) {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getContainer().getShell(), rootResource, IDEWorkbenchMessages.WizardExportPage_selectResourcesTitle);
        dialog.setInitialSelections(this.selectedResources.toArray(new Object[this.selectedResources.size()]));
        dialog.open();
        return dialog.getResult();
    }

    protected Object[] queryResourceTypesToExport() {
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        int mappingsSize = editorMappings.length;
        List selectedTypes = this.getTypesToExport();
        ArrayList<IFileEditorMapping> initialSelections = new ArrayList<IFileEditorMapping>(selectedTypes.size());
        int i = 0;
        while (i < mappingsSize) {
            IFileEditorMapping currentMapping = editorMappings[i];
            if (selectedTypes.contains(currentMapping.getExtension())) {
                initialSelections.add(currentMapping);
            }
            ++i;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(this.getContainer().getShell(), editorMappings, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)FileEditorMappingLabelProvider.INSTANCE, IDEWorkbenchMessages.WizardExportPage_selectionDialogMessage){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        dialog.setTitle(IDEWorkbenchMessages.WizardExportPage_resourceTypeDialog);
        dialog.open();
        return dialog.getResult();
    }

    protected void resetSelectedResources() {
        this.resourceDetailsDescription.setText(IDEWorkbenchMessages.WizardExportPage_detailsMessage);
        this.selectedResources = null;
        if (this.exportCurrentSelection) {
            this.exportCurrentSelection = false;
            if (this.resourceNameField.getText().length() > CURRENT_SELECTION.length()) {
                this.resourceNameField.setText(this.resourceNameField.getText().substring(CURRENT_SELECTION.length()));
            } else {
                this.resourceNameField.setText("");
            }
        }
    }

    protected void restoreResourceSpecificationWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] selectedTypes;
            String pageName = this.getName();
            boolean exportAllResources = settings.getBoolean(STORE_EXPORT_ALL_RESOURCES_ID + pageName);
            if (!this.exportAllResourcesPreSet) {
                this.exportAllTypesRadio.setSelection(exportAllResources);
                this.exportSpecifiedTypesRadio.setSelection(!exportAllResources);
            }
            if (this.initialTypesFieldValue == null && (selectedTypes = settings.getArray(STORE_SELECTED_TYPES_ID + pageName)) != null) {
                if (selectedTypes.length > 0) {
                    this.typesToExportField.setText(selectedTypes[0]);
                }
                String[] stringArray = selectedTypes;
                int n = selectedTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String selectedType = stringArray[n2];
                    this.typesToExportField.add(selectedType);
                    ++n2;
                }
            }
        }
    }

    @Override
    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String pageName = this.getName();
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID + pageName);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            if (this.exportSpecifiedTypesRadio.getSelection()) {
                selectedTypesNames = this.addToHistory(selectedTypesNames, this.typesToExportField.getText());
            }
            settings.put(STORE_SELECTED_TYPES_ID + pageName, selectedTypesNames);
            settings.put(STORE_EXPORT_ALL_RESOURCES_ID + pageName, this.exportAllTypesRadio.getSelection());
        }
        this.internalSaveWidgetValues();
    }

    protected void selectAppropriateFolderContents(IContainer resource) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = resource.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile currentFile;
                IResource member = iResourceArray[n2];
                if (member.getType() == 1 && this.hasExportableExtension((currentFile = (IFile)member).getFullPath().toString())) {
                    this.selectedResources.add(currentFile);
                }
                if (member.getType() == 2) {
                    this.selectAppropriateFolderContents((IContainer)member);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void selectAppropriateResources(Object resource) {
        if (this.selectedResources == null) {
            this.selectedTypes = this.exportSpecifiedTypesRadio.getSelection() ? this.getTypesToExport() : null;
            this.selectedResources = new ArrayList();
            if (resource instanceof IWorkspaceRoot) {
                IProject[] projects;
                IProject[] iProjectArray = projects = ((IWorkspaceRoot)resource).getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    this.selectAppropriateFolderContents((IContainer)project);
                    ++n2;
                }
            } else if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (this.hasExportableExtension(file.getFullPath().toString())) {
                    this.selectedResources.add(file);
                }
            } else {
                this.selectAppropriateFolderContents((IContainer)resource);
            }
        }
    }

    public void setExportAllTypesValue(boolean value) {
        if (this.exportAllTypesRadio == null) {
            this.initialExportAllTypesValue = value;
            this.exportAllResourcesPreSet = true;
        } else {
            this.exportAllTypesRadio.setSelection(value);
            this.exportSpecifiedTypesRadio.setSelection(!value);
        }
    }

    public void setResourceFieldValue(String value) {
        if (this.resourceNameField == null) {
            this.initialExportFieldValue = value;
        } else {
            this.resourceNameField.setText(value);
        }
    }

    protected void setResourceToDisplay(IResource resource) {
        this.setResourceFieldValue(resource.getFullPath().makeRelative().toString());
    }

    public void setTypesFieldValue(String value) {
        if (this.typesToExportField == null) {
            this.initialTypesFieldValue = value;
        } else {
            this.typesToExportField.setText(value);
        }
    }

    protected void setTypesToExport(List typeStrings) {
        StringBuffer result = new StringBuffer();
        Iterator typesEnum = typeStrings.iterator();
        while (typesEnum.hasNext()) {
            result.append(typesEnum.next());
            result.append(TYPE_DELIMITER);
            result.append(" ");
        }
        this.typesToExportField.setText(result.toString());
    }

    protected void setupBasedOnInitialSelections() {
        if (this.initialExportFieldValue != null) {
            IResource specifiedSourceResource = this.getSourceResource();
            this.currentResourceSelection = specifiedSourceResource == null ? new StructuredSelection() : new StructuredSelection((Object)specifiedSourceResource);
        }
        if (this.currentResourceSelection.isEmpty()) {
            return;
        }
        ArrayList<IResource> selections = new ArrayList<IResource>();
        for (IResource currentResource : this.currentResourceSelection) {
            if (!currentResource.isAccessible()) continue;
            selections.add(currentResource);
        }
        if (selections.isEmpty()) {
            return;
        }
        int selectedResourceCount = selections.size();
        if (selectedResourceCount == 1) {
            IResource resource = (IResource)selections.get(0);
            this.setResourceToDisplay(resource);
        } else {
            this.selectedResources = selections;
            this.exportAllTypesRadio.setSelection(true);
            this.exportSpecifiedTypesRadio.setSelection(false);
            this.resourceNameField.setText(CURRENT_SELECTION);
            this.exportCurrentSelection = true;
            this.displayResourcesSelectedCount(selectedResourceCount);
        }
    }

    @Override
    protected void updateWidgetEnablements() {
        if (this.exportCurrentSelection) {
            this.resourceDetailsButton.setEnabled(true);
        } else {
            IResource resource = this.getSourceResource();
            this.resourceDetailsButton.setEnabled(resource != null && resource.isAccessible());
        }
        this.exportSpecifiedTypesRadio.setEnabled(!this.exportCurrentSelection);
        this.typesToExportField.setEnabled(this.exportSpecifiedTypesRadio.getSelection());
        this.typesToExportEditButton.setEnabled(this.exportSpecifiedTypesRadio.getSelection());
    }

    @Override
    protected final boolean validateSourceGroup() {
        if (this.exportCurrentSelection) {
            return true;
        }
        String sourceString = this.resourceNameField.getText();
        if (sourceString.equals("")) {
            this.setErrorMessage(null);
            return false;
        }
        IResource resource = this.getSourceResource();
        if (resource == null) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardExportPage_mustExistMessage);
            return false;
        }
        if (!resource.isAccessible()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardExportPage_mustBeAccessibleMessage);
            return false;
        }
        return true;
    }
}

