/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.filtermatchers.AbstractFileInfoMatcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StringMatcher;

public class FileInfoAttributesMatcher
extends AbstractFileInfoMatcher {
    public static String ID = "org.eclipse.ui.ide.multiFilter";
    public static String KEY_NAME = "name";
    public static String KEY_PROPJECT_RELATIVE_PATH = "projectRelativePath";
    public static String KEY_LOCATION = "location";
    public static String KEY_LAST_MODIFIED = "lastModified";
    public static String KEY_LENGTH = "length";
    public static String KEY_CREATED = "created";
    public static String KEY_IS_SYMLINK = "isSymLink";
    public static String KEY_IS_READONLY = "isReadOnly";
    public static String OPERATOR_NONE = "none";
    public static String OPERATOR_LARGER_THAN = "largerThan";
    public static String OPERATOR_SMALLER_THAN = "smallerThan";
    public static String OPERATOR_EQUALS = "equals";
    public static String OPERATOR_BEFORE = "before";
    public static String OPERATOR_AFTER = "after";
    public static String OPERATOR_WITHIN = "within";
    public static String OPERATOR_MATCHES = "matches";
    private static String DELIMITER = "-";
    private static String VERSION_IMPLEMENTATION = "1.0";
    MatcherCache matcher = null;
    private boolean fSupportsCreatedKey = FileInfoAttributesMatcher.supportCreatedKey();

    public static String[] getOperatorsForKey(String key) {
        if (key.equals(KEY_NAME) || key.equals(KEY_PROPJECT_RELATIVE_PATH) || key.equals(KEY_LOCATION)) {
            return new String[]{OPERATOR_MATCHES};
        }
        if (key.equals(KEY_IS_SYMLINK) || key.equals(KEY_IS_READONLY)) {
            return new String[]{OPERATOR_EQUALS};
        }
        if (key.equals(KEY_LAST_MODIFIED) || key.equals(KEY_CREATED)) {
            return new String[]{OPERATOR_EQUALS, OPERATOR_BEFORE, OPERATOR_AFTER, OPERATOR_WITHIN};
        }
        if (key.equals(KEY_LENGTH)) {
            return new String[]{OPERATOR_EQUALS, OPERATOR_LARGER_THAN, OPERATOR_SMALLER_THAN};
        }
        return new String[]{OPERATOR_NONE};
    }

    public static Class getTypeForKey(String key, String operator) {
        if (key.equals(KEY_NAME) || key.equals(KEY_PROPJECT_RELATIVE_PATH) || key.equals(KEY_LOCATION)) {
            return String.class;
        }
        if (key.equals(KEY_IS_SYMLINK) || key.equals(KEY_IS_READONLY)) {
            return Boolean.class;
        }
        if (key.equals(KEY_LAST_MODIFIED) || key.equals(KEY_CREATED)) {
            if (operator.equals(OPERATOR_WITHIN)) {
                return Integer.class;
            }
            return Date.class;
        }
        if (key.equals(KEY_LENGTH)) {
            return Integer.class;
        }
        return String.class;
    }

    public static boolean supportCreatedKey() {
        if (Platform.getOS().equals("win32") || Platform.getOS().equals("macosx")) {
            String system = System.getProperty("java.version");
            double versionNumber = 0.0;
            int index = system.indexOf(46);
            if (index != -1) {
                versionNumber = Integer.decode(system.substring(0, index)).doubleValue();
                if ((index = (system = system.substring(index + 1)).indexOf(46)) != -1) {
                    versionNumber += Double.parseDouble(system.substring(0, index)) / 10.0;
                }
            }
            return versionNumber >= 1.7;
        }
        return false;
    }

    public static String encodeArguments(Argument argument) {
        return String.valueOf(VERSION_IMPLEMENTATION) + DELIMITER + argument.key + DELIMITER + argument.operator + DELIMITER + Boolean.toString(argument.caseSensitive) + DELIMITER + Boolean.toString(argument.regularExpression) + DELIMITER + argument.pattern;
    }

    public static Argument decodeArguments(String argument) {
        Argument result = new Argument();
        if (argument == null) {
            return result;
        }
        int index = argument.indexOf(DELIMITER);
        if (index == -1) {
            return result;
        }
        String version = argument.substring(0, index);
        argument = argument.substring(index + 1);
        if (!version.equals(VERSION_IMPLEMENTATION)) {
            return result;
        }
        index = argument.indexOf(DELIMITER);
        if (index == -1) {
            return result;
        }
        result.key = argument.substring(0, index);
        if ((index = (argument = argument.substring(index + 1)).indexOf(DELIMITER)) == -1) {
            return result;
        }
        result.operator = argument.substring(0, index);
        if ((index = (argument = argument.substring(index + 1)).indexOf(DELIMITER)) == -1) {
            return result;
        }
        result.caseSensitive = Boolean.valueOf(argument.substring(0, index));
        if ((index = (argument = argument.substring(index + 1)).indexOf(DELIMITER)) == -1) {
            return result;
        }
        result.regularExpression = Boolean.valueOf(argument.substring(0, index));
        result.pattern = argument.substring(index + 1);
        return result;
    }

    private static long getFileCreationTime(String fullPath) {
        try {
            Class<?> fileSystems = Class.forName("java.nio.file.FileSystems");
            Method getDefault = fileSystems.getMethod("getDefault", new Class[0]);
            Object fs = getDefault.invoke(null, new Object[0]);
            Class<?> fileRef = Class.forName("java.nio.file.FileRef");
            Class<?> fileSystem = Class.forName("java.nio.file.FileSystem");
            Method getPath = fileSystem.getMethod("getPath", String.class);
            Object fileRefObj = getPath.invoke(fs, fullPath);
            Class<?> attributes = Class.forName("java.nio.file.attribute.Attributes");
            Class<?> linkOptions = Class.forName("java.nio.file.LinkOption");
            Object linkOptionsEmptyArray = Array.newInstance(linkOptions, 0);
            Method readBasicFileAttributes = attributes.getMethod("readBasicFileAttributes", fileRef, linkOptionsEmptyArray.getClass());
            Object attributesObj = readBasicFileAttributes.invoke(null, fileRefObj, linkOptionsEmptyArray);
            Class<?> basicAttributes = Class.forName("java.nio.file.attribute.BasicFileAttributes");
            Method creationTime = basicAttributes.getMethod("creationTime", new Class[0]);
            Object time = creationTime.invoke(attributesObj, new Object[0]);
            Class<?> fileTime = Class.forName("java.nio.file.attribute.FileTime");
            Method toMillis = fileTime.getMethod("toMillis", new Class[0]);
            Object result = toMillis.invoke(time, new Object[0]);
            if (result instanceof Long) {
                return (Long)result;
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        return 0L;
    }

    public void initialize(IProject project, Object arguments) throws CoreException {
        try {
            if (arguments instanceof String && ((String)arguments).length() > 0) {
                this.matcher = new MatcherCache((String)arguments);
            }
        }
        catch (PatternSyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui", 2, e.getMessage(), (Throwable)e));
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui", 2, e.getMessage(), (Throwable)e));
        }
    }

    public boolean matches(IContainer parent, IFileInfo fileInfo) throws CoreException {
        if (this.matcher != null) {
            return this.matcher.match(parent, fileInfo);
        }
        return false;
    }

    public static class Argument {
        public String key = KEY_NAME;
        public String pattern = "";
        public String operator = OPERATOR_EQUALS;
        public boolean caseSensitive = false;
        public boolean regularExpression = false;
    }

    class MatcherCache {
        Argument argument;
        Class type;
        StringMatcher stringMatcher = null;
        Pattern regExPattern = null;

        public MatcherCache(String arguments) {
            this.argument = FileInfoAttributesMatcher.decodeArguments(arguments);
            this.type = FileInfoAttributesMatcher.getTypeForKey(this.argument.key, this.argument.operator);
            if (this.type.equals(String.class)) {
                if (!this.argument.regularExpression) {
                    this.stringMatcher = new StringMatcher(this.argument.pattern, !this.argument.caseSensitive, false);
                } else {
                    this.regExPattern = Pattern.compile(this.argument.pattern, this.argument.caseSensitive ? 0 : 2);
                }
            }
        }

        public boolean match(IContainer parent, IFileInfo fileInfo) {
            IFileInfo info;
            if (this.type.equals(String.class)) {
                String value = "";
                if (this.argument.key.equals(KEY_NAME)) {
                    value = fileInfo.getName();
                }
                if (this.argument.key.equals(KEY_PROPJECT_RELATIVE_PATH)) {
                    value = parent.getProjectRelativePath().append(fileInfo.getName()).toPortableString();
                }
                if (this.argument.key.equals(KEY_LOCATION)) {
                    value = parent.getLocation().append(fileInfo.getName()).toOSString();
                }
                if (this.stringMatcher != null) {
                    return this.stringMatcher.match(value);
                }
                if (this.regExPattern != null) {
                    Matcher m = this.regExPattern.matcher(value);
                    return m.matches();
                }
            }
            if (this.type.equals(Integer.class)) {
                int amount;
                try {
                    amount = Integer.parseInt(this.argument.pattern);
                }
                catch (NumberFormatException e) {
                    amount = 0;
                }
                if (this.argument.key.equals(KEY_LAST_MODIFIED) || this.argument.key.equals(KEY_CREATED)) {
                    long time = 0L;
                    if (this.argument.key.equals(KEY_LAST_MODIFIED)) {
                        IFileInfo info2 = this.fetchInfo(parent, fileInfo);
                        if (!info2.exists()) {
                            return false;
                        }
                        time = info2.getLastModified();
                    }
                    if (this.argument.key.equals(KEY_CREATED)) {
                        if (!FileInfoAttributesMatcher.this.fSupportsCreatedKey) {
                            return false;
                        }
                        time = FileInfoAttributesMatcher.getFileCreationTime(parent.getLocation().append(fileInfo.getName()).toOSString());
                    }
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.add(13, -amount);
                    Date when = gc.getTime();
                    Date then = new Date(time);
                    return then.after(when);
                }
                if (this.argument.key.equals(KEY_LENGTH)) {
                    info = this.fetchInfo(parent, fileInfo);
                    if (!info.exists()) {
                        return false;
                    }
                    if (this.argument.operator.equals(OPERATOR_EQUALS)) {
                        return info.getLength() == (long)amount;
                    }
                    if (this.argument.operator.equals(OPERATOR_LARGER_THAN)) {
                        return info.getLength() > (long)amount;
                    }
                    if (this.argument.operator.equals(OPERATOR_SMALLER_THAN)) {
                        return info.getLength() < (long)amount;
                    }
                }
            }
            if (this.type.equals(Date.class)) {
                long parameter = Long.parseLong(this.argument.pattern);
                if (this.argument.key.equals(KEY_LAST_MODIFIED) || this.argument.key.equals(KEY_CREATED)) {
                    long time = 0L;
                    if (this.argument.key.equals(KEY_LAST_MODIFIED)) {
                        IFileInfo info3 = this.fetchInfo(parent, fileInfo);
                        if (!info3.exists()) {
                            return false;
                        }
                        time = info3.getLastModified();
                    }
                    if (this.argument.key.equals(KEY_CREATED)) {
                        if (!FileInfoAttributesMatcher.this.fSupportsCreatedKey) {
                            return false;
                        }
                        time = FileInfoAttributesMatcher.getFileCreationTime(parent.getLocation().append(fileInfo.getName()).toOSString());
                    }
                    Date when = new Date(parameter);
                    Date then = new Date(time);
                    if (this.argument.operator.equals(OPERATOR_EQUALS)) {
                        return this.roundToOneDay(time) == this.roundToOneDay(parameter);
                    }
                    if (this.argument.operator.equals(OPERATOR_BEFORE)) {
                        return then.before(when);
                    }
                    if (this.argument.operator.equals(OPERATOR_AFTER)) {
                        return then.after(when);
                    }
                }
            }
            if (this.type.equals(Boolean.class)) {
                boolean parameter = Boolean.valueOf(this.argument.pattern);
                if (this.argument.key.equals(KEY_IS_READONLY)) {
                    info = this.fetchInfo(parent, fileInfo);
                    if (!info.exists()) {
                        return false;
                    }
                    return info.getAttribute(2) == parameter;
                }
                if (this.argument.key.equals(KEY_IS_SYMLINK)) {
                    info = this.fetchInfo(parent, fileInfo);
                    if (!info.exists()) {
                        return false;
                    }
                    return info.getAttribute(32) == parameter;
                }
            }
            return false;
        }

        private long roundToOneDay(long parameter) {
            return parameter / 86400000L;
        }

        private IFileInfo fetchInfo(IContainer parent, IFileInfo fileInfo) {
            IFileStore fileStore;
            try {
                fileStore = EFS.getStore((URI)parent.getLocationURI());
            }
            catch (CoreException e) {
                return fileInfo;
            }
            IFileStore store = fileStore.getChild(fileInfo.getName());
            return store.fetchInfo();
        }
    }
}

