/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.views.tasklist.MarkerUtil;

class TaskSorter
extends ViewerComparator {
    private int[] priorities;
    private int[] directions;
    static final int ASCENDING = 1;
    static final int DEFAULT_DIRECTION = 0;
    static final int DESCENDING = -1;
    static final int TYPE = 0;
    static final int COMPLETION = 1;
    static final int PRIORITY = 2;
    static final int DESCRIPTION = 3;
    static final int RESOURCE = 4;
    static final int FOLDER = 5;
    static final int LOCATION = 6;
    static final int CREATION_TIME = 7;
    static final int[] DEFAULT_PRIORITIES;
    static final int[] DEFAULT_DIRECTIONS;

    static {
        int[] nArray = new int[8];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 6;
        nArray[3] = 3;
        nArray[5] = 2;
        nArray[6] = 1;
        nArray[7] = 7;
        DEFAULT_PRIORITIES = nArray;
        DEFAULT_DIRECTIONS = new int[]{-1, -1, -1, 1, 1, 1, 1, 1};
    }

    public TaskSorter() {
        this.resetState();
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IMarker m1 = (IMarker)e1;
        IMarker m2 = (IMarker)e2;
        return this.compareColumnValue(m1, m2, 0);
    }

    public void setTopPriority(int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.priorities.length) {
            if (this.priorities[i] == priority) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            this.resetState();
            return;
        }
        i = index;
        while (i > 0) {
            this.priorities[i] = this.priorities[i - 1];
            --i;
        }
        this.priorities[0] = priority;
        this.directions[priority] = DEFAULT_DIRECTIONS[priority];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    public void setTopPriorityDirection(int direction) {
        if (direction == 0) {
            this.directions[this.priorities[0]] = DEFAULT_DIRECTIONS[this.priorities[0]];
        } else if (direction == 1 || direction == -1) {
            this.directions[this.priorities[0]] = direction;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void resetState() {
        this.priorities = new int[DEFAULT_PRIORITIES.length];
        System.arraycopy(DEFAULT_PRIORITIES, 0, this.priorities, 0, this.priorities.length);
        this.directions = new int[DEFAULT_DIRECTIONS.length];
        System.arraycopy(DEFAULT_DIRECTIONS, 0, this.directions, 0, this.directions.length);
    }

    private int compareColumnValue(IMarker m1, IMarker m2, int depth) {
        if (depth >= this.priorities.length) {
            return 0;
        }
        int columnNumber = this.priorities[depth];
        int direction = this.directions[columnNumber];
        switch (columnNumber) {
            case 0: {
                int result = this.getCategoryOrder(m1) - this.getCategoryOrder(m2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 1: {
                int result = this.getCompletedOrder(m1) - this.getCompletedOrder(m2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 2: {
                int result = this.getPriorityOrder(m1) - this.getPriorityOrder(m2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 3: {
                int result = this.getComparator().compare(MarkerUtil.getMessage(m1), MarkerUtil.getMessage(m2));
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 4: {
                IResource r1 = m1.getResource();
                IResource r2 = m2.getResource();
                String n1 = r1.getName();
                String n2 = r2.getName();
                int result = this.getComparator().compare(n1, n2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 5: {
                int result;
                String c1 = MarkerUtil.getContainerName(m1);
                String c2 = MarkerUtil.getContainerName(m2);
                int n = result = c1.equals(c2) ? 0 : this.getComparator().compare(c1, c2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 6: {
                int result = this.compareLineAndLocation(m1, m2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
            case 7: {
                int result = this.compareCreationTime(m1, m2);
                if (result == 0) {
                    return this.compareColumnValue(m1, m2, depth + 1);
                }
                return result * direction;
            }
        }
        return 0;
    }

    private int compareCreationTime(IMarker m1, IMarker m2) {
        long result;
        try {
            result = m1.getCreationTime() - m2.getCreationTime();
        }
        catch (CoreException e) {
            result = 0L;
        }
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        return 0;
    }

    private int compareLineAndLocation(IMarker m1, IMarker m2) {
        int line1 = MarkerUtil.getLineNumber(m1);
        int line2 = MarkerUtil.getLineNumber(m2);
        if (line1 != -1 && line2 != -1) {
            if (line1 != line2) {
                return line1 - line2;
            }
            int start1 = MarkerUtil.getCharStart(m1);
            int start2 = MarkerUtil.getCharStart(m2);
            if (start1 != -1 && start2 != -1 && start1 != start2) {
                return start1 - start2;
            }
            String loc1 = MarkerUtil.getLocation(m1);
            String loc2 = MarkerUtil.getLocation(m2);
            return this.getComparator().compare(loc1, loc2);
        }
        if (line1 == -1 && line2 == -1) {
            String loc1 = MarkerUtil.getLocation(m1);
            String loc2 = MarkerUtil.getLocation(m2);
            return this.getComparator().compare(loc1, loc2);
        }
        String loc1 = MarkerUtil.getLineAndLocation(m1);
        String loc2 = MarkerUtil.getLineAndLocation(m2);
        return this.getComparator().compare(loc1, loc2);
    }

    private int getCategoryOrder(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtil.getSeverity(marker)) {
                case 2: {
                    return 4;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 2;
                }
            }
        } else if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return 1;
        }
        return 1000;
    }

    private int getCompletedOrder(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.isComplete(marker) ? 2 : 1;
        }
        return 0;
    }

    private int getPriorityOrder(IMarker marker) {
        if (MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.getPriority(marker);
        }
        return -1;
    }

    public void saveState(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        int i = 0;
        while (i < this.directions.length) {
            settings.put("direction" + i, this.directions[i]);
            settings.put("priority" + i, this.priorities[i]);
            ++i;
        }
    }

    public void restoreState(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        try {
            int i = 0;
            while (i < this.priorities.length) {
                this.directions[i] = settings.getInt("direction" + i);
                this.priorities[i] = settings.getInt("priority" + i);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            this.resetState();
        }
    }
}

