/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTreeViewer;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RetargetAddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneSelectionProvider;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class MemoryBlocksTreeViewPane
implements ISelectionListener,
ISelectionChangedListener,
IMemoryViewPane,
IMemoryRenderingContainer {
    public static final String PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.MemoryBlocksTreeViewPane";
    private IViewPart fParent;
    private IPresentationContext fPresentationContext;
    private MemoryViewTreeViewer fTreeViewer;
    protected IMemoryBlockRetrieval fRetrieval;
    private ViewPaneSelectionProvider fSelectionProvider;
    private AddMemoryBlockAction fAddMemoryBlockAction;
    private IAction fRemoveMemoryBlockAction;
    private IAction fRemoveAllMemoryBlocksAction;
    private String fPaneId;
    private boolean fVisible = true;
    private TreeViewPaneContextListener fDebugContextListener;
    private ViewPaneEventHandler fEvtHandler;
    private String fLabel;

    public MemoryBlocksTreeViewPane(IViewPart parent) {
        this.fParent = parent;
        this.fSelectionProvider = new ViewPaneSelectionProvider();
    }

    @Override
    public Control createViewPane(Composite parent, String paneId, String label) {
        this.fPaneId = paneId;
        int style = 268436226;
        this.fLabel = label;
        IMemoryRenderingSite site = this.getMemoryRenderingSite();
        this.fPresentationContext = new MemoryViewPresentationContext(site, this, null);
        this.fTreeViewer = new MemoryViewTreeViewer(parent, style, this.fPresentationContext);
        IAdaptable context = DebugUITools.getPartDebugContext(this.fParent.getSite());
        IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
        if (retrieval != null) {
            this.fTreeViewer.setInput(retrieval);
        }
        this.fRetrieval = retrieval;
        this.fParent.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.fParent.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.fDebugContextListener = new TreeViewPaneContextListener();
        DebugUITools.addPartDebugContextListener(this.fParent.getSite(), this.fDebugContextListener);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection treeSelected = event.getSelection();
                MemoryBlocksTreeViewPane.this.fSelectionProvider.setSelection(treeSelected);
            }
        });
        this.updateRetrieval();
        this.fEvtHandler = new ViewPaneEventHandler();
        MenuManager mgr = this.createContextMenuManager();
        Menu menu = mgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fTreeViewer.getControl().setLayoutData((Object)data);
        this.updateActionsEnablement();
        return this.fTreeViewer.getControl();
    }

    private void updateRetrieval() {
        IAdaptable context = DebugUITools.getPartDebugContext(this.fParent.getSite());
        this.fRetrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
    }

    protected MenuManager createContextMenuManager() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)MemoryBlocksTreeViewPane.this.fAddMemoryBlockAction);
                manager.add(MemoryBlocksTreeViewPane.this.fRemoveMemoryBlockAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.fParent.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)this.fSelectionProvider);
        return menuMgr;
    }

    @Override
    public void dispose() {
        this.fParent.getViewSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.fParent.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.fAddMemoryBlockAction.dispose();
        DebugUITools.removePartDebugContextListener(this.fParent.getSite(), this.fDebugContextListener);
        this.fEvtHandler.dispose();
        this.fPresentationContext.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IMemoryBlock && part == this.fParent) {
            ISelection treeSel = this.fTreeViewer.getSelection();
            if (treeSel instanceof IStructuredSelection && ((IStructuredSelection)treeSel).getFirstElement() == obj) {
                return;
            }
            this.removeSelctionListener(this);
            this.fTreeViewer.setSelection(selection);
            this.addSelectionListener(this);
        }
    }

    @Override
    public String getId() {
        return this.fPaneId;
    }

    @Override
    public IAction[] getActions() {
        if (this.fAddMemoryBlockAction == null) {
            this.fAddMemoryBlockAction = new RetargetAddMemoryBlockAction((IMemoryRenderingSite)this.fParent);
        }
        if (this.fRemoveMemoryBlockAction == null) {
            this.fRemoveMemoryBlockAction = new TreeViewerRemoveMemoryBlocksAction();
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            this.fRemoveAllMemoryBlocksAction = new TreeViewerRemoveAllMemoryBlocksAction();
        }
        this.updateActionsEnablement();
        return new IAction[]{this.fAddMemoryBlockAction, this.fRemoveMemoryBlockAction, this.fRemoveAllMemoryBlocksAction};
    }

    @Override
    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ViewPaneSelectionProvider();
        }
        this.fSelectionProvider.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelctionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            return;
        }
        this.fSelectionProvider.removeSelectionChangedListener(listener);
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    @Override
    public void restoreViewPane() {
        this.updateRetrieval();
        this.updateActionsEnablement();
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.fVisible != visible) {
            this.fVisible = visible;
            if (this.fVisible) {
                this.fTreeViewer.refresh();
                this.fTreeViewer.getControl().setFocus();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.fVisible;
    }

    private void updateActionsEnablement() {
        if (this.fRemoveMemoryBlockAction == null) {
            return;
        }
        if (this.fRemoveAllMemoryBlocksAction == null) {
            return;
        }
        if (this.fRetrieval != null) {
            IMemoryBlock[] memBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fRetrieval);
            if (memBlocks.length > 0) {
                this.fRemoveMemoryBlockAction.setEnabled(true);
                this.fRemoveAllMemoryBlocksAction.setEnabled(true);
            } else {
                this.fRemoveMemoryBlockAction.setEnabled(false);
                this.fRemoveAllMemoryBlocksAction.setEnabled(false);
            }
        } else {
            this.fRemoveMemoryBlockAction.setEnabled(false);
            this.fRemoveAllMemoryBlocksAction.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.fParent.getSite().getSelectionProvider()) {
            this.selectionChanged((IWorkbenchPart)this.fParent, event.getSelection());
        }
    }

    public StructuredViewer getViewer() {
        return this.fTreeViewer;
    }

    @Override
    public IMemoryRenderingSite getMemoryRenderingSite() {
        if (this.fParent instanceof IMemoryRenderingSite) {
            return (IMemoryRenderingSite)this.fParent;
        }
        return null;
    }

    @Override
    public void addMemoryRendering(IMemoryRendering rendering) {
    }

    @Override
    public void removeMemoryRendering(IMemoryRendering rendering) {
    }

    @Override
    public IMemoryRendering[] getRenderings() {
        return new IMemoryRendering[0];
    }

    @Override
    public IMemoryRendering getActiveRendering() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    class TreeViewPaneContextListener
    implements IDebugContextListener {
        TreeViewPaneContextListener() {
        }

        public void contextActivated(ISelection selection) {
            Object obj;
            if (selection.isEmpty() && MemoryBlocksTreeViewPane.this.fRetrieval != null) {
                MemoryBlocksTreeViewPane.this.fRetrieval = null;
                if (MemoryBlocksTreeViewPane.this.fTreeViewer != null && MemoryBlocksTreeViewPane.this.fTreeViewer.getContentProvider() != null) {
                    MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(MemoryBlocksTreeViewPane.this.fRetrieval);
                }
                MemoryBlocksTreeViewPane.this.updateActionsEnablement();
                return;
            }
            if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
                IAdaptable context = (IAdaptable)obj;
                IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
                if (retrieval != null && MemoryBlocksTreeViewPane.this.fTreeViewer != null && (retrieval != MemoryBlocksTreeViewPane.this.fRetrieval || retrieval != MemoryBlocksTreeViewPane.this.fTreeViewer.getInput()) && MemoryBlocksTreeViewPane.this.fTreeViewer.getContentProvider() != null) {
                    MemoryBlocksTreeViewPane.this.fRetrieval = retrieval;
                    MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(MemoryBlocksTreeViewPane.this.fRetrieval);
                }
                MemoryBlocksTreeViewPane.this.updateActionsEnablement();
            }
        }

        @Override
        public void debugContextChanged(DebugContextEvent event) {
            if ((event.getFlags() & 1) > 0) {
                this.contextActivated(event.getContext());
            }
        }
    }

    class TreeViewerRemoveAllMemoryBlocksAction
    extends Action {
        TreeViewerRemoveAllMemoryBlocksAction() {
            this.setText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setToolTipText(DebugUIMessages.MemoryBlocksTreeViewPane_2);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_18_REMOVE_ALL"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_18_REMOVE_ALL"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_18_REMOVE_ALL"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.RemoveAllMemoryBlocksAction_context");
        }

        public void run() {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            boolean proceed = MessageDialog.openQuestion((Shell)window.getShell(), (String)DebugUIMessages.MemoryBlocksTreeViewPane_0, (String)DebugUIMessages.MemoryBlocksTreeViewPane_1);
            if (proceed) {
                IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksTreeViewPane.this.fRetrieval);
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memoryBlocks);
            }
        }
    }

    class TreeViewerRemoveMemoryBlocksAction
    extends Action {
        TreeViewerRemoveMemoryBlocksAction() {
            this.setText(DebugUIMessages.RemoveMemoryBlockAction_title);
            this.setToolTipText(DebugUIMessages.RemoveMemoryBlockAction_tooltip);
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_18_REMOVE_MEMORY"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_18_REMOVE_MEMORY"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_18_REMOVE_MEMORY"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.RemoveMemoryBlockAction_context");
            this.setEnabled(true);
        }

        public void run() {
            ISelection selected = MemoryBlocksTreeViewPane.this.fTreeViewer.getSelection();
            if (selected != null && selected instanceof IStructuredSelection) {
                Object[] selectedMemBlks = ((IStructuredSelection)selected).toArray();
                ArrayList<Object> memoryBlocks = new ArrayList<Object>();
                int i = 0;
                while (i < selectedMemBlks.length) {
                    if (selectedMemBlks[i] instanceof IMemoryBlock) {
                        memoryBlocks.add(selectedMemBlks[i]);
                    }
                    ++i;
                }
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memoryBlocks.toArray(new IMemoryBlock[memoryBlocks.size()]));
            }
        }
    }

    class ViewPaneEventHandler
    implements IMemoryBlockListener,
    IDebugEventSetListener {
        private boolean fDisposed = false;

        public ViewPaneEventHandler() {
            DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }

        public void dispose() {
            this.fDisposed = true;
            DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            if (this.fDisposed) {
                return;
            }
            MemoryBlocksTreeViewPane.this.updateActionsEnablement();
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            if (this.fDisposed) {
                return;
            }
            MemoryBlocksTreeViewPane.this.updateActionsEnablement();
        }

        protected void doHandleDebugEvent(DebugEvent event) {
            IMemoryBlockRetrieval srcRetrieval;
            if (this.fDisposed) {
                return;
            }
            if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget && (srcRetrieval = MemoryViewUtil.getMemoryBlockRetrieval(event.getSource())) == MemoryBlocksTreeViewPane.this.fRetrieval) {
                UIJob job = new UIJob("setInput"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (MemoryBlocksTreeViewPane.this.fTreeViewer.getContentProvider() == null) {
                            return Status.OK_STATUS;
                        }
                        MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(null);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.doHandleDebugEvent(events[i]);
                ++i;
            }
        }
    }
}

