/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class TableRenderingContentInput
extends PlatformObject {
    private IMemoryRendering fRendering;
    private int fPreBuffer;
    private int fPostBuffer;
    private BigInteger fLoadAddress;
    private int fNumLines;
    private boolean fUpdateDelta;
    private BigInteger fMemoryBlockBaseAddress;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;

    public TableRenderingContentInput(IMemoryRendering rendering, int preBuffer, int postBuffer, BigInteger loadAddress, int numOfLines, boolean updateDelta, BigInteger contentBaseAddress) {
        this.fRendering = rendering;
        this.fPreBuffer = preBuffer;
        this.fPostBuffer = postBuffer;
        this.fLoadAddress = loadAddress;
        this.fNumLines = numOfLines;
        this.fUpdateDelta = updateDelta;
        if (contentBaseAddress == null) {
            try {
                this.updateContentBaseAddress();
            }
            catch (DebugException debugException) {}
        } else {
            this.fMemoryBlockBaseAddress = contentBaseAddress;
        }
    }

    public int getPostBuffer() {
        return this.fPostBuffer;
    }

    public int getPreBuffer() {
        return this.fPreBuffer;
    }

    public BigInteger getLoadAddress() {
        return this.fLoadAddress;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fRendering.getMemoryBlock();
    }

    public void setPostBuffer(int postBuffer) {
        this.fPostBuffer = postBuffer;
    }

    public void setPreBuffer(int preBuffer) {
        this.fPreBuffer = preBuffer;
    }

    public boolean isUpdateDelta() {
        return this.fUpdateDelta;
    }

    public void setUpdateDelta(boolean updateDelta) {
        this.fUpdateDelta = updateDelta;
    }

    public void setLoadAddress(BigInteger address) {
        this.fLoadAddress = address;
    }

    public BigInteger getContentBaseAddress() {
        if (this.fMemoryBlockBaseAddress == null) {
            try {
                this.updateContentBaseAddress();
            }
            catch (DebugException e) {
                this.fMemoryBlockBaseAddress = new BigInteger("0");
            }
        }
        return this.fMemoryBlockBaseAddress;
    }

    public void updateContentBaseAddress() throws DebugException {
        IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
        this.fMemoryBlockBaseAddress = memoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memoryBlock).getBigBaseAddress() : BigInteger.valueOf(memoryBlock.getStartAddress());
    }

    public BigInteger getStartAddress() {
        if (this.fStartAddress == null) {
            try {
                BigInteger startAddress;
                IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
                if (memoryBlock instanceof IMemoryBlockExtension && (startAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockStartAddress()) != null) {
                    this.fStartAddress = startAddress;
                }
            }
            catch (DebugException e) {
                this.fStartAddress = BigInteger.valueOf(0L);
            }
            if (this.fStartAddress == null) {
                this.fStartAddress = BigInteger.valueOf(0L);
            }
        }
        return this.fStartAddress;
    }

    public BigInteger getEndAddress() {
        if (this.fEndAddress == null) {
            IMemoryBlock memoryBlock = this.fRendering.getMemoryBlock();
            if (memoryBlock instanceof IMemoryBlockExtension) {
                BigInteger endAddress;
                try {
                    endAddress = ((IMemoryBlockExtension)memoryBlock).getMemoryBlockEndAddress();
                    if (endAddress != null) {
                        this.fEndAddress = endAddress;
                    }
                }
                catch (DebugException e) {
                    this.fEndAddress = null;
                }
                if (this.fEndAddress == null) {
                    int addressSize;
                    try {
                        addressSize = ((IMemoryBlockExtension)memoryBlock).getAddressSize();
                    }
                    catch (DebugException e) {
                        addressSize = 4;
                    }
                    endAddress = BigInteger.valueOf(2L);
                    endAddress = endAddress.pow(addressSize * 8);
                    this.fEndAddress = endAddress = endAddress.subtract(BigInteger.valueOf(1L));
                }
            }
            if (this.fEndAddress == null) {
                this.fEndAddress = BigInteger.valueOf(Integer.MAX_VALUE);
            }
        }
        return this.fEndAddress;
    }

    public int getNumLines() {
        return this.fNumLines;
    }

    public void setNumLines(int numLines) {
        this.fNumLines = numLines;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AbstractTableRendering.class && this.fRendering instanceof AbstractTableRendering) {
            return (T)this.fRendering;
        }
        if (adapter == AbstractAsyncTableRendering.class && this.fRendering instanceof AbstractAsyncTableRendering) {
            return (T)this.fRendering;
        }
        return (T)super.getAdapter(adapter);
    }
}

