/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalFunctionBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;

public class MethodScope
extends BlockScope {
    public ReferenceContext referenceContext;
    public boolean isStatic;
    public boolean isConstructorCall = false;
    public FieldBinding initializedField;
    public int lastVisibleFieldID = -1;
    public int analysisIndex;
    public int lastIndex = 0;
    public long[] definiteInits = new long[4];
    public long[][] extraDefiniteInits = new long[4][];
    public static final char[] ARGUMENTS_NAME = new char[]{'a', 'r', 'g', 'u', 'm', 'e', 'n', 't', 's'};
    public LocalVariableBinding argumentsBinding;
    private HashtableOfObject fUnresolvedLocalVars;
    private HashtableOfObject fUnresolvedLocalFuncs;

    public MethodScope(Scope parent, ReferenceContext context, boolean isStatic) {
        super(2, parent);
        this.locals = new LocalVariableBinding[5];
        this.referenceContext = context;
        this.isStatic = isStatic;
        this.startIndex = 0;
        this.argumentsBinding = new LocalVariableBinding(ARGUMENTS_NAME, (TypeBinding)TypeBinding.UNKNOWN, 0, true);
        this.argumentsBinding.declaringScope = this;
    }

    private void checkAndSetModifiersForConstructor(MethodBinding methodBinding) {
        int realModifiers;
        int accessorBits;
        int modifiers = methodBinding.modifiers;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        if ((methodBinding.modifiers & 0x4000000) > 0) {
            int DECLARING_FLAGS = 5;
            int VISIBILITY_FLAGS = 7;
            int flags = declaringClass.modifiers & 5;
            if (flags != 0) {
                modifiers &= 0xFFFFFFF8;
                modifiers |= flags;
            }
        }
        if (((accessorBits = (realModifiers = modifiers & 0xFFFF) & 7) & accessorBits - 1) != 0) {
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        methodBinding.modifiers = modifiers;
    }

    private void checkAndSetModifiersForMethod(MethodBinding methodBinding) {
        int modifiers = methodBinding.modifiers;
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        int realModifiers = modifiers & 0xFFFF;
        int accessorBits = realModifiers & 7;
        if ((accessorBits & accessorBits - 1) != 0) {
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        methodBinding.modifiers = modifiers;
    }

    MethodBinding createMethod(InferredMethod inferredMethod, SourceTypeBinding declaringClass) {
        boolean isConstructor = inferredMethod.isConstructor;
        if (isConstructor && declaringClass != inferredMethod.inType.binding) {
            isConstructor = false;
        }
        MethodBinding binding = this.createMethod((AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration()), inferredMethod.name, declaringClass, isConstructor, false);
        if (inferredMethod.isConstructor || declaringClass != inferredMethod.inType.binding) {
            binding.allocationType = inferredMethod.inType.binding;
        }
        return binding;
    }

    public MethodBinding createMethod(AbstractMethodDeclaration method, char[] name, SourceTypeBinding declaringClass, boolean isConstructor, boolean isLocal) {
        int argLength;
        MethodBinding methodBinding = null;
        this.referenceContext = method;
        method.setScope(this);
        int modifiers = method.modifiers | 0x2000000;
        if ((method.modifiers & 6) == 0) {
            modifiers |= 1;
        }
        if (method.inferredMethod != null && method.inferredMethod.isStatic) {
            modifiers |= 8;
        }
        if (isConstructor) {
            if (method.isDefaultConstructor() || isConstructor) {
                modifiers |= 0x4000000;
            }
            TypeBinding constructorType = null;
            if (method.inferredMethod != null && method.inferredMethod.inType != null) {
                constructorType = method.inferredMethod.inType.resolveType(this, method);
            }
            if (constructorType == null) {
                constructorType = TypeBinding.UNKNOWN;
            }
            methodBinding = new MethodBinding(modifiers, name, constructorType, null, constructorType instanceof ReferenceBinding ? (ReferenceBinding)constructorType : declaringClass);
            methodBinding.tagBits |= 0x20000000000000L;
            this.checkAndSetModifiersForConstructor(methodBinding);
        } else {
            TypeBinding returnType;
            TypeBinding typeBinding = returnType = method.inferredType != null ? method.inferredType.resolveType(this, method) : TypeBinding.UNKNOWN;
            if (method.inferredType == null && method.inferredMethod != null && method.inferredMethod.isConstructor && method.inferredMethod.inType != null) {
                returnType = method.inferredMethod.inType.resolveType(this, method);
            }
            if (returnType == null) {
                returnType = TypeBinding.UNKNOWN;
            }
            methodBinding = isLocal && method.getName() != null ? new LocalFunctionBinding(modifiers, name, returnType, null, declaringClass) : new MethodBinding(modifiers, name, returnType, null, declaringClass);
            if (method.inferredMethod != null) {
                methodBinding.tagBits |= 0x80000000000000L;
                if ((method.bits & 0x4000) != 0) {
                    methodBinding.tagBits |= 0x40000000000000L;
                }
            }
            this.checkAndSetModifiersForMethod(methodBinding);
        }
        methodBinding.createFunctionTypeBinding(this);
        this.isStatic = methodBinding.isStatic();
        Argument[] argTypes = method.arguments;
        int n = argLength = argTypes == null ? 0 : argTypes.length;
        if (argLength > 0 && this.compilerOptions().sourceLevel >= 0x310000L && argTypes[--argLength].isVarArgs()) {
            methodBinding.modifiers |= 0x80;
        }
        return methodBinding;
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        FieldBinding field = super.findField(receiverType, fieldName, invocationSite, needResolve);
        if (field == null) {
            return null;
        }
        if (!field.isValidBinding()) {
            return field;
        }
        if (field.isStatic()) {
            return field;
        }
        if (!this.isConstructorCall || receiverType != this.enclosingSourceType()) {
            return field;
        }
        if (invocationSite instanceof SingleNameReference) {
            return new ProblemFieldBinding(field, field.declaringClass, fieldName, 6);
        }
        if (invocationSite instanceof QualifiedNameReference) {
            QualifiedNameReference name = (QualifiedNameReference)invocationSite;
            if (name.binding == null) {
                return new ProblemFieldBinding(field, field.declaringClass, fieldName, 6);
            }
        }
        return field;
    }

    public boolean isInsideConstructor() {
        return this.referenceContext instanceof ConstructorDeclaration;
    }

    public boolean isInsideInitializer() {
        return this.referenceContext instanceof TypeDeclaration;
    }

    public boolean isInsideInitializerOrConstructor() {
        return this.referenceContext instanceof TypeDeclaration || this.referenceContext instanceof ConstructorDeclaration;
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == this) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public final int recordInitializationStates(FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return -1;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalInitsWithoutSideEffect();
        long[] extraInits = unconditionalFlowInfo.extra == null ? null : unconditionalFlowInfo.extra[0];
        long inits = unconditionalFlowInfo.definiteInits;
        int i = this.lastIndex;
        block0: while (--i >= 0) {
            if (this.definiteInits[i] != inits) continue;
            long[] otherInits = this.extraDefiniteInits[i];
            if (extraInits != null && otherInits != null) {
                if (extraInits.length != otherInits.length) continue;
                int j = 0;
                int max = extraInits.length;
                while (j < max) {
                    if (extraInits[j] != otherInits[j]) continue block0;
                    ++j;
                }
                return i;
            }
            if (extraInits != null || otherInits != null) continue;
            return i;
        }
        if (this.definiteInits.length == this.lastIndex) {
            this.definiteInits = new long[this.lastIndex + 20];
            System.arraycopy(this.definiteInits, 0, this.definiteInits, 0, this.lastIndex);
            long[][] lArrayArray = new long[this.lastIndex + 20][];
            this.extraDefiniteInits = lArrayArray;
            System.arraycopy(this.extraDefiniteInits, 0, lArrayArray, 0, this.lastIndex);
        }
        this.definiteInits[this.lastIndex] = inits;
        if (extraInits != null) {
            this.extraDefiniteInits[this.lastIndex] = new long[extraInits.length];
            System.arraycopy(extraInits, 0, this.extraDefiniteInits[this.lastIndex], 0, extraInits.length);
        }
        return this.lastIndex++;
    }

    public AbstractMethodDeclaration referenceMethod() {
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            return (AbstractMethodDeclaration)this.referenceContext;
        }
        return null;
    }

    public TypeDeclaration referenceType() {
        if (this.parent instanceof ClassScope) {
            return ((ClassScope)this.parent).referenceContext;
        }
        return null;
    }

    String basicToString(int tab) {
        StringBuilder sb = new StringBuilder(10);
        int i = tab;
        while (--i >= 0) {
            sb.append('\t');
        }
        sb.append("--- Method Scope ---");
        sb.append('\t');
        sb.append("locals:");
        i = 0;
        while (i < this.localIndex) {
            sb.append('\t');
            sb.append(this.locals[i]);
            ++i;
        }
        sb.append("startIndex = ");
        sb.append(this.startIndex);
        sb.append("isConstructorCall = ");
        sb.append(this.isConstructorCall);
        sb.append("initializedField = ");
        sb.append(this.initializedField);
        sb.append("lastVisibleFieldID = ");
        sb.append(this.lastVisibleFieldID);
        sb.append("referenceContext = ");
        sb.append(this.referenceContext);
        return sb.toString();
    }

    public LocalVariableBinding findVariable(char[] variableName) {
        IAbstractVariableDeclaration statement;
        LocalVariableBinding binding = super.findVariable(variableName);
        if (binding == null && CharOperation.equals(variableName, ARGUMENTS_NAME)) {
            binding = this.argumentsBinding;
        }
        if (binding == null && this.fUnresolvedLocalVars != null && (statement = (IAbstractVariableDeclaration)this.fUnresolvedLocalVars.removeKey(variableName)) != null && statement instanceof ProgramElement) {
            if (statement instanceof LocalDeclaration) {
                ((LocalDeclaration)statement).resolveLocal(this);
            } else {
                ((ProgramElement)((Object)statement)).resolve(this);
            }
            binding = super.findVariable(variableName);
        }
        return binding;
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        AbstractMethodDeclaration statement;
        MethodBinding binding = super.findMethod(receiverType, selector, argumentTypes, invocationSite);
        if (!(binding != null && binding.isValidBinding() || this.fUnresolvedLocalFuncs == null || (statement = (AbstractMethodDeclaration)this.fUnresolvedLocalFuncs.removeKey(selector)) == null)) {
            statement.resolve(this);
            binding = statement.getBinding();
        }
        return binding;
    }

    public MethodBinding findMethod(char[] methodName, TypeBinding[] argumentTypes, boolean checkVars) {
        AbstractMethodDeclaration methDecl;
        MethodBinding binding = super.findMethod(methodName, argumentTypes, checkVars);
        if (!(binding != null && binding.isValidBinding() || this.fUnresolvedLocalFuncs == null || (methDecl = (AbstractMethodDeclaration)this.fUnresolvedLocalFuncs.removeKey(methodName)) == null)) {
            binding = methDecl.getBinding();
            if (binding == null || !binding.isValidBinding()) {
                BlockScope scope = null;
                scope = methDecl.isAnonymous() ? this.compilationUnitScope() : this;
                methDecl.resolve((Scope)scope);
            }
            binding = methDecl.getBinding();
        }
        return binding;
    }

    public void addUnresolvedLocalVar(char[] name, IAbstractVariableDeclaration expr) {
        if (name != null && name.length > 0 && expr != null) {
            if (this.fUnresolvedLocalVars == null) {
                this.fUnresolvedLocalVars = new HashtableOfObject();
            }
            this.fUnresolvedLocalVars.put(name, expr);
        }
    }

    public void addUnresolvedLocalFunc(char[] name, AbstractMethodDeclaration func) {
        if (name != null && name.length > 0 && func != null) {
            if (this.fUnresolvedLocalFuncs == null) {
                this.fUnresolvedLocalFuncs = new HashtableOfObject();
            }
            this.fUnresolvedLocalFuncs.put(name, func);
        }
    }
}

