/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.MemberElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaElementDeltaBuilder {
    IJavaScriptElement javaElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    public JavaElementDelta delta = null;
    ArrayList added;
    ArrayList removed;

    public JavaElementDeltaBuilder(IJavaScriptElement javaElement) {
        this.javaElement = javaElement;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaScriptModel(), 0);
    }

    public JavaElementDeltaBuilder(IJavaScriptElement javaElement, int maxDepth) {
        this.javaElement = javaElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaScriptModel(), 0);
    }

    private void added(IJavaScriptElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.delta = new JavaElementDelta(this.javaElement);
        if (this.javaElement.getElementType() >= 5) {
            this.delta.fineGrained();
        }
        this.recordNewPositions(this.javaElement, 0);
        this.findAdditions(this.javaElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.javaElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private boolean equals(char[][][] first, char[][][] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals(first[i], second[i])) continue;
            return false;
        }
        return true;
    }

    private void findAdditions(IJavaScriptElement newElement, int depth) {
        IJavaScriptElement[] children;
        JavaElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        JavaElementInfo newInfo = null;
        try {
            newInfo = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
        }
        catch (JavaScriptModelException npe) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IJavaScriptElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)element).getElementInfo();
            }
            catch (JavaScriptModelException npe) {
                return;
            }
            IJavaScriptElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(JavaElementInfo oldInfo, JavaElementInfo newInfo, IJavaScriptElement newElement) {
        block12: {
            HashMap newTypeCategories;
            block13: {
                Set elements;
                if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
                    if (((MemberElementInfo)oldInfo).getModifiers() != ((MemberElementInfo)newInfo).getModifiers()) {
                        this.delta.changed(newElement, 2);
                    } else if (oldInfo instanceof SourceMethodElementInfo && newInfo instanceof SourceMethodElementInfo) {
                        SourceMethodElementInfo oldSourceMethodInfo = (SourceMethodElementInfo)oldInfo;
                        SourceMethodElementInfo newSourceMethodInfo = (SourceMethodElementInfo)newInfo;
                        if (!CharOperation.equals(oldSourceMethodInfo.getReturnTypeName(), newSourceMethodInfo.getReturnTypeName())) {
                            this.delta.changed(newElement, 1);
                        }
                    } else if (oldInfo instanceof SourceFieldElementInfo && newInfo instanceof SourceFieldElementInfo && !CharOperation.equals(((SourceFieldElementInfo)oldInfo).getTypeName(), ((SourceFieldElementInfo)newInfo).getTypeName())) {
                        this.delta.changed(newElement, 1);
                    }
                }
                if (!(oldInfo instanceof SourceTypeElementInfo) || !(newInfo instanceof SourceTypeElementInfo)) break block12;
                SourceTypeElementInfo oldSourceTypeInfo = (SourceTypeElementInfo)oldInfo;
                SourceTypeElementInfo newSourceTypeInfo = (SourceTypeElementInfo)newInfo;
                if (!CharOperation.equals(oldSourceTypeInfo.getSuperclassName(), newSourceTypeInfo.getSuperclassName()) || !CharOperation.equals(oldSourceTypeInfo.getInterfaceNames(), newSourceTypeInfo.getInterfaceNames())) {
                    this.delta.changed(newElement, 2048);
                }
                HashMap oldTypeCategories = oldSourceTypeInfo.categories;
                newTypeCategories = newSourceTypeInfo.categories;
                if (oldTypeCategories == null) break block13;
                if (newTypeCategories != null) {
                    elements = new HashSet(oldTypeCategories.keySet());
                    elements.addAll(newTypeCategories.keySet());
                } else {
                    elements = oldTypeCategories.keySet();
                }
                for (IJavaScriptElement element : elements) {
                    Object[] newCategories;
                    Object[] oldCategories = (String[])oldTypeCategories.get(element);
                    Object[] objectArray = newCategories = newTypeCategories == null ? null : (String[])newTypeCategories.get(element);
                    if (Util.equalArraysOrNull(oldCategories, newCategories)) continue;
                    this.delta.changed(element, 0x100000);
                }
                break block12;
            }
            if (newTypeCategories == null) break block12;
            for (IJavaScriptElement element : newTypeCategories.keySet()) {
                this.delta.changed(element, 0x100000);
            }
        }
    }

    private void findDeletions() {
        for (IJavaScriptElement element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private JavaElementInfo getElementInfo(IJavaScriptElement element) {
        return (JavaElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IJavaScriptElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IJavaScriptElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.javaElement, new ListItem(null, null));
        this.putNewPosition(this.javaElement, new ListItem(null, null));
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IJavaScriptElement[] elements, boolean isNew) {
        int length = elements.length;
        IJavaScriptElement previous = null;
        IJavaScriptElement current = null;
        IJavaScriptElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IJavaScriptElement iJavaScriptElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IJavaScriptElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IJavaScriptElement oldPrevious = oldListItem.previous;
        IJavaScriptElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IJavaScriptElement element, JavaElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IJavaScriptElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IJavaScriptElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IJavaScriptElement element, JavaModel model, int depth) {
        IJavaScriptElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        JavaElementInfo info = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(element);
        if (info == null) {
            return;
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IJavaScriptElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
            }
            catch (JavaScriptModelException npe) {
                return;
            }
            IJavaScriptElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IJavaScriptElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IJavaScriptElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta == null ? "<null>" : this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(JavaElementDelta elementDelta) {
        if (elementDelta.getKind() == 2) {
            IJavaScriptElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                elementDelta.removeAffectedChild((JavaElementDelta)children[i]);
                ++i;
            }
        } else {
            IJavaScriptElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((JavaElementDelta)children[i]);
                ++i;
            }
        }
    }

    static class ListItem {
        public IJavaScriptElement previous;
        public IJavaScriptElement next;

        public ListItem(IJavaScriptElement previous, IJavaScriptElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

