/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchDocument
extends SearchDocument {
    private IFile file;
    protected byte[] byteContents;
    protected char[] charContents;
    private String packageName;

    public JavaSearchDocument(String documentPath, SearchParticipant participant) {
        super(documentPath, participant);
    }

    public JavaSearchDocument(ZipEntry zipEntry, IPath zipFilePath, byte[] contents, SearchParticipant participant) {
        super(zipFilePath + "|" + zipEntry.getName(), participant);
        this.byteContents = contents;
    }

    public JavaSearchDocument(ZipEntry zipEntry, IPath zipFilePath, char[] contents, SearchParticipant participant) {
        super(zipFilePath + "|" + zipEntry.getName(), participant);
        this.charContents = contents;
    }

    public JavaSearchDocument(IPath filePath, char[] contents, SearchParticipant participant, String packageName) {
        super(filePath.toString(), participant);
        this.charContents = contents;
        this.packageName = packageName;
    }

    public byte[] getByteContents() {
        if (this.byteContents != null) {
            return this.byteContents;
        }
        try {
            return Util.getResourceContentsAsByteArray(this.getFile());
        }
        catch (JavaScriptModelException e) {
            if (BasicSearchEngine.VERBOSE || JobManager.VERBOSE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public char[] getCharContents() {
        if (this.charContents != null) {
            return this.charContents;
        }
        try {
            return Util.getResourceContentsAsCharArray(this.getFile());
        }
        catch (JavaScriptModelException e) {
            if (BasicSearchEngine.VERBOSE || JobManager.VERBOSE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String getEncoding() {
        IFile resource = this.getFile();
        if (resource != null) {
            try {
                return resource.getCharset();
            }
            catch (CoreException ce) {
                try {
                    return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private IFile getFile() {
        if (this.file == null) {
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getPath()));
        }
        return this.file;
    }

    public String toString() {
        return "SearchDocument for " + this.getPath();
    }

    public String getPackageName() {
        return this.packageName;
    }
}

