/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.lang.reflect.Field;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.TitleRegion;

public class HeaderText {
    private StyledText titleLabel;
    private BusyIndicator busyLabel;

    public HeaderText(Form form, String text, String sha1String) {
        try {
            FormHeading heading = (FormHeading)form.getHead();
            heading.setBusy(true);
            heading.setBusy(false);
            Field field = FormHeading.class.getDeclaredField("titleRegion");
            field.setAccessible(true);
            TitleRegion titleRegion = (TitleRegion)field.get(heading);
            Control[] controlArray = titleRegion.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof BusyIndicator) {
                    this.busyLabel = (BusyIndicator)child;
                    break;
                }
                ++n2;
            }
            if (this.busyLabel == null) {
                throw new IllegalArgumentException();
            }
            TextViewer titleViewer = new TextViewer((Composite)titleRegion, 8);
            titleViewer.setDocument((IDocument)new Document(text));
            this.titleLabel = titleViewer.getTextWidget();
            this.titleLabel.setForeground(heading.getForeground());
            this.titleLabel.setFont(heading.getFont());
            this.titleLabel.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    HeaderText.this.titleLabel.setSelection(0);
                    Event selectionEvent = new Event();
                    selectionEvent.x = 0;
                    selectionEvent.y = 0;
                    HeaderText.this.titleLabel.notifyListeners(13, selectionEvent);
                }
            });
            HeaderText.createContextMenu(this.titleLabel, sha1String);
            Point size = this.titleLabel.computeSize(-1, -1);
            Image emptyImage = new Image((Device)heading.getDisplay(), size.x, size.y);
            UIUtils.hookDisposal((Widget)this.titleLabel, (Resource)emptyImage);
            this.busyLabel.setImage(emptyImage);
            this.busyLabel.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    HeaderText.this.updateSizeAndLocations();
                }
            });
            this.titleLabel.moveAbove((Control)this.busyLabel);
            titleRegion.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    HeaderText.this.updateSizeAndLocations();
                }
            });
            this.updateSizeAndLocations();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            form.setText(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            form.setText(text);
        }
        catch (IllegalAccessException illegalAccessException) {
            form.setText(text);
        }
    }

    private void updateSizeAndLocations() {
        if (this.busyLabel == null || this.busyLabel.isDisposed()) {
            return;
        }
        if (this.titleLabel == null || this.titleLabel.isDisposed()) {
            return;
        }
        Point size = this.titleLabel.computeSize(-1, -1, true);
        int y = (this.titleLabel.getParent().getSize().y - size.y) / 2;
        this.titleLabel.setBounds(this.busyLabel.getLocation().x, y, size.x, size.y);
    }

    private static void createContextMenu(final StyledText styledText, final String sha1String) {
        Menu menu = new Menu((Control)styledText);
        MenuItem copySHA1MenuItem = new MenuItem(menu, 8);
        copySHA1MenuItem.setText(UIText.Header_contextMenu_copy_SHA1);
        final Shell shell = styledText.getShell();
        copySHA1MenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HeaderText.copyToClipboard(sha1String, shell);
            }
        });
        final MenuItem copyMenuItem = new MenuItem(menu, 8);
        copyMenuItem.setText(UIText.Header_contextMenu_copy);
        copyMenuItem.setEnabled(false);
        copyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                styledText.copy();
            }
        });
        styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                copyMenuItem.setEnabled(styledText.getSelectionCount() > 0);
            }
        });
        styledText.setMenu(menu);
    }

    private static void copyToClipboard(String str, Shell shell) {
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{str}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError ex) {
                if (ex.code != 2002) {
                    throw ex;
                }
                String title = UIText.Header_copy_SHA1_error_title;
                String message = UIText.Header_copy_SHA1_error_message;
                if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) {
                    HeaderText.copyToClipboard(str, shell);
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    public Control getControl() {
        return this.titleLabel;
    }
}

