#!/bin/bash -x

#Set sdk version
IDE_ROOT_DIR_NAME="TizenStudio.app"
modify_ide_version()
{
    echo "Modify ide version..."
    tizen_sdk_version=`cat ${INSTALLED_PATH}/sdk.version | grep 'TIZEN_SDK_VERSION' | sed -e "s;.*TIZEN_SDK_VERSION=\(.*\);\1;g"`
    product_version="${tizen_sdk_version}"

    ide_path="${INSTALLED_PATH}/${IDE_ROOT_DIR_NAME}/Contents/Eclipse"
    config_file_path="${ide_path}/configuration/config.ini"
    branding_plugin=`ls "${ide_path}/plugins" | grep --color=none org.tizen.product.plugin_`
    about_mapping_path="${ide_path}/plugins/${branding_plugin}/about.mappings"
    about_version_parameter="1"

    echo "Set product's version (${product_version})"

    if [ -e "${config_file_path}" ]
    then
        sed -e "s;\(^eclipse.buildId=\).*;\1${product_version};g" < "${config_file_path}" > "${config_file_path}.mod"
        mv "${config_file_path}.mod" "${config_file_path}"
    fi

    if [ -e "${about_mapping_path}" ]
    then
        sed -e "s;\(^${about_version_parameter}=\).*;\1${product_version};g" < "${about_mapping_path}" > "${about_mapping_path}.mod"
        mv "${about_mapping_path}.mod" "${about_mapping_path}"
    fi
}
modify_ide_version

SHORTCUT_DIR_PATH_MACOS=/Applications
INSTALLED_APP_DIR_MACOS="${INSTALLED_PATH}/${IDE_ROOT_DIR_NAME}"

 ##create 'Tizen Studio' shortcut
 if [ "$MAKESHORTCUT_PATH" != "" ]; then
 ${MAKESHORTCUT_PATH} \
 -s "${INSTALLED_APP_DIR_MACOS}" \
 -in "${INSTALLED_DIR_NAME}" \
 -n "Tizen Studio"
 fi

exit 0
