/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.CertificateIntroButtonInformation;
import org.tizen.common.sign.ui.CertificateType;
import org.tizen.common.sign.ui.CertificateTypeExtensions;
import org.tizen.common.sign.ui.ICertificateCreationHandler;
import org.tizen.common.sign.ui.ICertificateExtensionCreationHandler;
import org.tizen.common.sign.ui.dialog.IoTCertificateIntroDialog;
import org.tizen.common.util.SWTUtil;

public class IoTCertificateExtensionHandler
extends AbstractHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int CLOSE = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block37: {
            block35: {
                List<CertificateType> certificateTypes = CertificateTypeExtensions.getCertificateTypes();
                ICertificateCreationHandler handler = null;
                CertificateIntroButtonInformation defaultButtonInfo = null;
                CertificateIntroButtonInformation extButtonInfo = null;
                if (certificateTypes.size() >= 1) {
                    for (CertificateType certType : certificateTypes) {
                        if (!"IoT Cloud Service".equals(certType.getProfileType())) continue;
                        if (certType.getName().equals("SmartThings")) {
                            defaultButtonInfo = certType.getButtonInfo();
                            continue;
                        }
                        extButtonInfo = certType.getButtonInfo();
                    }
                }
                if (defaultButtonInfo != null) {
                    handler = (ICertificateExtensionCreationHandler)defaultButtonInfo.getHandler();
                }
                String method = event.getParameter("command");
                if (handler == null) break block35;
                switch (method) {
                    case "execute": {
                        if (extButtonInfo == null) {
                            return -1;
                        }
                        IoTCertificateIntroDialog dialog = new IoTCertificateIntroDialog(SWTUtil.getShell(), defaultButtonInfo, extButtonInfo);
                        int selected = dialog.open();
                        if (selected == 64 || selected == 1) {
                            return -1;
                        }
                        if (selected == 1001) {
                            handler = extButtonInfo.getHandler();
                        }
                        return handler != null ? handler.execute() : -1;
                    }
                    case "importCertificate": {
                        return handler.importCertificate();
                    }
                    case "setActiveCertificate": {
                        return handler.setActiveCertificate(event.getParameter("certificateName"));
                    }
                    case "removeCertificate": {
                        return handler.removeCertificate(event.getParameter("certificateName"));
                    }
                    case "getActiveCertificate": {
                        return handler.getActiveCertificate();
                    }
                    case "loadCertificates": {
                        return handler.loadCertificates();
                    }
                    case "defaultPage": {
                        return handler.execute();
                    }
                    case "getCertPath": {
                        return handler.getCertificatePath();
                    }
                }
                break block37;
            }
            this.logger.error("Failed to execute certificate creation wizard. handler is null");
            return -1;
        }
        return -1;
    }
}

