/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;

public class NewActionProvider
extends CommonActionProvider {
    private static final String NEW_MENU_NAME = "common.new.menu";
    private ActionFactory.IWorkbenchAction showDlgAction;
    private WizardActionGroup newWizardActionGroup;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite anExtensionSite) {
        if (anExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            IWorkbenchWindow window = ((ICommonViewerWorkbenchSite)anExtensionSite.getViewSite()).getWorkbenchWindow();
            this.showDlgAction = ActionFactory.NEW.create(window);
            this.newWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getNewWizardRegistry(), "new", anExtensionSite.getContentService());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.NewActionProvider_NewMenu_label, NEW_MENU_NAME);
        if (!this.contribute) {
            return;
        }
        this.newWizardActionGroup.setContext(this.getContext());
        this.newWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.showDlgAction);
        menu.insertAfter("group.new", (IContributionItem)submenu);
    }

    public void dispose() {
        if (this.showDlgAction != null) {
            this.showDlgAction.dispose();
            this.showDlgAction = null;
        }
        super.dispose();
    }
}

