/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class HexIntegerRendering
extends AbstractIntegerRendering {
    public HexIntegerRendering(String renderingId) {
        super(renderingId);
    }

    @Override
    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        StringBuffer strBuffer = new StringBuffer();
        int endianess = this.getEndianness(data);
        String paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        if (endianess == 0) {
            MemoryByte[] swapped = new MemoryByte[data.length];
            int i = 0;
            while (i < data.length) {
                swapped[data.length - i - 1] = data[i];
                ++i;
            }
            data = swapped;
        }
        int i = 0;
        while (i < data.length) {
            if (data[i].isReadable()) {
                strBuffer.append(new String(RenderingsUtil.convertByteToCharArray(data[i].getValue())));
            } else {
                strBuffer.append(paddedStr);
            }
            ++i;
        }
        return strBuffer.toString().toUpperCase();
    }

    private int getEndianness(MemoryByte[] data) {
        int endianess = this.getDisplayEndianess();
        if (endianess == 2) {
            endianess = this.getBytesEndianess(data);
        }
        return endianess;
    }

    @Override
    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        int endianess = this.getEndianness(currentValues);
        byte[] bytes = RenderingsUtil.convertHexStringToByteArray(data, currentValues.length, this.getNumCharsPerByte());
        if (endianess == 0) {
            byte[] swapped = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                swapped[bytes.length - i - 1] = bytes[i];
                ++i;
            }
            bytes = swapped;
        }
        return bytes;
    }

    @Override
    public int getNumCharsPerByte() {
        return 2;
    }
}

