/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.CertificateCreationHandler;
import org.tizen.common.sign.ui.common.CertificateComposite;
import org.tizen.common.sign.ui.common.CertificateCustomButton;
import org.tizen.common.sign.ui.common.CertificateManagementImages;
import org.tizen.common.sign.ui.dialog.CertificateAdditionDialog;
import org.tizen.common.sign.ui.dialog.CertificateEditionDialog;
import org.tizen.common.sign.ui.dialog.CertificateInformationDialog;
import org.tizen.common.sign.ui.dialog.DuplicateProfileDialog;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.ui.dialog.ProfileMigrationDialog;
import org.tizen.common.sign.ui.dialog.ProfileRemovalListener;
import org.tizen.common.sign.ui.model.CertificateInformation;
import org.tizen.common.sign.util.Certification;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.StringUtil;

public class CertificateManageComposite {
    private static final int PROFILE_TABLE_HEIGHT = 95;
    private static final int DISTRIBUTOR_CERT1_INDEX = 1;
    private static final int DISTRIBUTOR_CERT2_INDEX = 2;
    private Composite authorComposite;
    private Composite distributor1Composite;
    private Composite distributor2Composite;
    private Label lDescription;
    private CertificateCustomButton migrateProfileButton;
    private CertificateCustomButton addProfileButton;
    private CertificateCustomButton removeProfileButton;
    private CertificateCustomButton activeProfileButton;
    private TableViewer profileTable;
    private SigningProfileContainer profileContainer;
    private SigningProfile selectedProfile;
    private List<SigningProfile> profileList;
    private final CertificateManagementImages certificateImages = new CertificateManagementImages();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Shell shell = null;

    private Shell getShell() {
        return this.shell;
    }

    public CertificateManageComposite(Shell parentShell, Label lDescription) {
        this.shell = parentShell;
        this.lDescription = lDescription;
        this.updateProfileListFromFile();
    }

    public Control createDialogArea(Composite parent) {
        return this.createMainComposite(parent);
    }

    public Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 30;
        layout.marginHeight = 30;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        composite.setBackgroundMode(2);
        composite.setBackground(TizenColors.getTizenLightGrey());
        this.createProfileComposite(composite);
        this.createCertificateComposite(composite);
        Canvas separator = new Canvas(parent, 0);
        separator.setBackground(TizenColors.getTizenSmokeGrey());
        GridData separatorData = new GridData(768);
        separatorData.heightHint = 1;
        separator.setLayoutData((Object)separatorData);
        return composite;
    }

    private void createProfileTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Label lProfile = new Label(composite, 0);
        lProfile.setFont(TizenFonts.getBoldFont());
        lProfile.setText(Messages.CERT_MANAGER_CERT_PROFILE);
        lProfile.setLayoutData((Object)new GridData(768));
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout(4, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 12;
        buttonComp.setLayout((Layout)layout);
        gridData = new GridData(128);
        buttonComp.setLayoutData((Object)gridData);
        this.migrateProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_MIGRATE[0], this.certificateImages.PROFILE_MIGRATE[1], this.certificateImages.PROFILE_MIGRATE[2], this.certificateImages.PROFILE_MIGRATE[3]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        this.migrateProfileButton.setLayoutData(layoutData);
        this.addProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ADD[0], this.certificateImages.PROFILE_ADD[1], this.certificateImages.PROFILE_ADD[2], this.certificateImages.PROFILE_ADD[3]);
        this.addProfileButton.setLayoutData(layoutData);
        this.removeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_REMOVE[0], this.certificateImages.PROFILE_REMOVE[1], this.certificateImages.PROFILE_REMOVE[2], this.certificateImages.PROFILE_REMOVE[3]);
        this.removeProfileButton.setLayoutData(layoutData);
        this.activeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ACTIVE[0], this.certificateImages.PROFILE_ACTIVE[1], this.certificateImages.PROFILE_ACTIVE[2], this.certificateImages.PROFILE_ACTIVE[3]);
        this.activeProfileButton.setLayoutData(layoutData);
    }

    private void createProfileListComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 95;
        composite.setLayoutData((Object)gridData);
        this.profileTable = new TableViewer(composite, 68352);
        GridData data = new GridData(1808);
        this.profileTable.getTable().setLayoutData((Object)data);
        this.profileTable.getTable().setHeaderVisible(false);
        final TableColumn column = new TableColumn(this.profileTable.getTable(), 0);
        this.profileTable.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                column.setWidth(((CertificateManageComposite)CertificateManageComposite.this).profileTable.getTable().getClientArea().width);
            }
        });
        this.profileTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Composite removeButton;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                CertificateManageComposite.this.selectedProfile = (SigningProfile)selection.getFirstElement();
                SigningProfileItem authCert = null;
                SigningProfileItem distCert1 = null;
                SigningProfileItem distCert2 = null;
                if (CertificateManageComposite.this.selectedProfile != null) {
                    authCert = CertificateManageComposite.this.selectedProfile.getAuthorProfileItem();
                    List<SigningProfileItem> distCerts = CertificateManageComposite.this.selectedProfile.getDistributorProfileItems();
                    distCert1 = distCerts.get(0);
                    distCert2 = distCerts.get(1);
                }
                if (CertificateManageComposite.this.selectedProfile != null && distCert2 == null) {
                    distCert2 = CertificateManageComposite.this.selectedProfile.createEmptyProfileItem(2);
                }
                CertificateManageComposite.this.updateCertComposite(CertificateManageComposite.this.authorComposite, authCert, false);
                CertificateManageComposite.this.updateCertComposite(CertificateManageComposite.this.distributor1Composite, distCert1, true);
                CertificateManageComposite.this.updateCertComposite(CertificateManageComposite.this.distributor2Composite, distCert2, true);
                CertificateManageComposite.this.activeProfileButton.setEnabled(CertificateManageComposite.this.selectedProfile != null);
                if (CertificateManageComposite.this.selectedProfile == null) {
                    return;
                }
                if (StringUtil.isEmpty((CharSequence)distCert1.getKeyLocation())) {
                    removeButton = (Composite)CertificateManageComposite.this.distributor2Composite.getData("remove_button");
                    removeButton.setEnabled(false);
                }
                if (StringUtil.isEmpty((CharSequence)distCert2.getKeyLocation())) {
                    removeButton = (Composite)CertificateManageComposite.this.distributor1Composite.getData("remove_button");
                    removeButton.setEnabled(false);
                }
            }
        });
        this.profileTable.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CertificateManageComposite.this.setActiveProfile();
            }
        });
        this.profileTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return ((List)element).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.profileTable.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (CertificateManageComposite.this.profileTable.getTable().getItemCount() == 0) {
                    Point textPt = event.gc.textExtent(Messages.CERT_MANAGER_NOPROFILE);
                    int x = (((CertificateManageComposite)CertificateManageComposite.this).profileTable.getTable().getSize().x - textPt.x) / 2;
                    int y = (((CertificateManageComposite)CertificateManageComposite.this).profileTable.getTable().getSize().y - textPt.y) / 2;
                    event.gc.drawString(Messages.CERT_MANAGER_NOPROFILE, x, y, true);
                }
            }
        });
        this.profileTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof SigningProfile) {
                    String profileName = ((SigningProfile)element).getProfileName();
                    String activeProfileName = SigningProfileUtil.getActiveProfileName();
                    if (activeProfileName.equals(profileName)) {
                        return ((CertificateManageComposite)CertificateManageComposite.this).certificateImages.ACTIVE_STATUS;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof SigningProfile) {
                    String profileName = ((SigningProfile)element).getProfileName();
                    return profileName;
                }
                return null;
            }
        });
    }

    private void createProfileComposite(Composite parent) {
        this.createProfileTitleComposite(parent);
        this.createProfileListComposite(parent);
        this.migrateProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                CertificateManageComposite.this.migrateProfile();
            }
        });
        this.activeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                CertificateManageComposite.this.setActiveProfile();
            }
        });
        this.addProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)CertificateManageComposite.this.profileContainer);
                CertificateCreationHandler creationHandler = new CertificateCreationHandler();
                try {
                    int result = (Integer)creationHandler.execute(null);
                    if (result == 0) {
                        CertificateManageComposite.this.updateProfileListFromFile();
                        CertificateManageComposite.this.setInput();
                    }
                }
                catch (ExecutionException e) {
                    CertificateManageComposite.this.logger.error("Failed to execute certificate creation handler", (Throwable)e);
                }
            }
        });
        this.removeProfileButton.addMouseListener((MouseListener)new ProfileRemovalListener(this.profileTable));
        this.removeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                TableItem[] items = CertificateManageComposite.this.profileTable.getTable().getItems();
                SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)CertificateManageComposite.this.profileContainer);
                if (items.length == 0) {
                    return;
                }
                if (items.length <= 1) {
                    CertificateManageComposite.this.activeProfileButton.setEnabled(false);
                }
            }
        });
    }

    private void updateCertComposite(Composite parent, SigningProfileItem data, boolean isDistributor) {
        Control[] children;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (data == null) {
            this.createEmptyComposite(parent, false);
        } else if (StringUtil.isEmpty((CharSequence)data.getKeyLocation())) {
            this.createEmptyComposite(parent, true);
        } else {
            CertificateInformation certInfo = this.getCertificateInformation(data);
            new CertificateComposite(parent, 0, certInfo);
            this.createButtonComposite(parent, isDistributor);
        }
        parent.setData("data", (Object)data);
        parent.layout(true, true);
    }

    private void createCertificateComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 15;
        layout.marginWidth = 20;
        layout.horizontalSpacing = 32;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 215;
        composite.setLayoutData((Object)gridData);
        this.createTitleComposite(composite);
        this.createAuthCertComposite(composite);
        this.createDistCertComposite(composite);
    }

    private void createTitleComposite(Composite parent) {
        Composite authTitleComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        authTitleComp.setLayout((Layout)layout);
        authTitleComp.setLayoutData((Object)new GridData(768));
        Label lTitle = new Label(authTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_AUTHOR_CERT);
        Composite distTitleComp = new Composite(parent, 0);
        distTitleComp.setLayout((Layout)layout);
        distTitleComp.setLayoutData((Object)new GridData(768));
        lTitle = new Label(distTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_DIST_CERT);
    }

    private void createAuthCertComposite(Composite parent) {
        this.authorComposite = this.createCertificateDeckComposite(parent);
        new CertificateComposite(this.authorComposite, 0);
    }

    private void createEmptyComposite(final Composite parent, boolean needAddButton) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        if (!needAddButton) {
            return;
        }
        CertificateCustomButton btAdd = new CertificateCustomButton(composite, this.certificateImages.CERT_ADD[0], this.certificateImages.CERT_ADD[1], this.certificateImages.CERT_ADD[2], this.certificateImages.CERT_ADD[3]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        btAdd.setLayoutData(layoutData);
        btAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateAdditionDialog dlg = new CertificateAdditionDialog(CertificateManageComposite.this.getShell());
                    if (dlg.open() == 0) {
                        certificate.setKeyLocation(dlg.getCertPath());
                        certificate.setPassword(dlg.getCertPasswd().toCharArray());
                        CertificateManageComposite.this.profileTable.setSelection(CertificateManageComposite.this.profileTable.getSelection(), true);
                    }
                }
            }
        });
    }

    private void createDistCertComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.distributor1Composite = this.createCertificateDeckComposite(composite);
        new CertificateComposite(this.distributor1Composite, 0);
        this.distributor2Composite = this.createCertificateDeckComposite(composite);
        new CertificateComposite(this.distributor2Composite, 0);
    }

    private Composite createCertificateDeckComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FormLayout());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 165;
        layoutData.widthHint = 180;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    private void createButtonComposite(final Composite parent, final boolean isDistributor) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(100, -30);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        Composite buttonComp = new Composite(composite, 0);
        layout = isDistributor ? new GridLayout(3, false) : new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        layout.horizontalSpacing = 5;
        buttonComp.setLayout((Layout)layout);
        GridData layoutData = new GridData(1936);
        buttonComp.setLayoutData((Object)layoutData);
        if (isDistributor) {
            CertificateCustomButton btDistRemove = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_REMOVE[0], this.certificateImages.CERT_REMOVE[1], this.certificateImages.CERT_REMOVE[2], this.certificateImages.CERT_REMOVE[3]);
            btDistRemove.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    Object data = parent.getData("data");
                    if (data == null) {
                        return;
                    }
                    if (data instanceof SigningProfileItem) {
                        SigningProfileItem certificate = (SigningProfileItem)data;
                        String filename = FilenameUtil.getFilename((String)certificate.getKeyLocation());
                        String name = FilenameUtil.getName((String)filename);
                        int result = DialogUtil.openQuestionDialog((String)String.format(Messages.CERT_REMOVE_QUESTION, name));
                        if (result == 128) {
                            return;
                        }
                        int ordinal = CertificateManageComposite.this.selectedProfile.getOrdinal(certificate);
                        if (ordinal == 1) {
                            SigningProfileItem item = CertificateManageComposite.this.selectedProfile.getProfileItem(2);
                            Assert.isNotNull((Object)item);
                            CertificateManageComposite.this.selectedProfile.setProfileItem(1, item);
                        }
                        CertificateManageComposite.this.selectedProfile.createEmptyProfileItem(2);
                        CertificateManageComposite.this.profileTable.setSelection(CertificateManageComposite.this.profileTable.getSelection(), true);
                    }
                }
            });
            parent.setData("remove_button", (Object)btDistRemove);
        }
        CertificateCustomButton btAuthEdit = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_EDIT[0], this.certificateImages.CERT_EDIT[1], this.certificateImages.CERT_EDIT[2], this.certificateImages.CERT_EDIT[3]);
        btAuthEdit.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateEditionDialog dlg = new CertificateEditionDialog(CertificateManageComposite.this.getShell(), certificate, isDistributor);
                    if (dlg.open() == 0) {
                        certificate.setKeyLocation(dlg.getCertPath());
                        certificate.setPassword(dlg.getCertPasswd().toCharArray());
                        CertificateManageComposite.this.profileTable.setSelection(CertificateManageComposite.this.profileTable.getSelection(), true);
                    }
                }
            }
        });
        layoutData = new GridData(4);
        layoutData.grabExcessVerticalSpace = true;
        btAuthEdit.setLayoutData(layoutData);
        CertificateCustomButton btAuthInfo = new CertificateCustomButton(buttonComp, this.certificateImages.CERT_INFO[0], this.certificateImages.CERT_INFO[1], this.certificateImages.CERT_INFO[2], this.certificateImages.CERT_INFO[3]);
        btAuthInfo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateInformation certInfo = CertificateManageComposite.this.getCertificateInformation(certificate);
                    CertificateInformationDialog dlg = new CertificateInformationDialog(CertificateManageComposite.this.getShell(), certInfo);
                    dlg.open();
                }
            }
        });
        layoutData = new GridData(4);
        layoutData.grabExcessVerticalSpace = true;
        btAuthInfo.setLayoutData(layoutData);
    }

    public void setInput() {
        if (this.profileList.size() == 0) {
            this.lDescription.setText(Messages.CERT_MANAGER_EMPTY_DESC);
            this.removeProfileButton.setEnabled(false);
            this.activeProfileButton.setEnabled(false);
            this.logger.trace("Profile list is empty");
            return;
        }
        this.lDescription.setText(Messages.CERT_MANAGER_DESC);
        this.activeProfileButton.setEnabled(this.profileList.size() > 1);
        this.removeProfileButton.setEnabled(true);
        String activeProfileName = SigningProfileUtil.getActiveProfileName();
        SigningProfile activeProfile = this.profileContainer.getProfileByName(activeProfileName);
        if (activeProfile == null && this.profileContainer.getFirstProfile() != null) {
            SigningProfileUtil.setActiveProfileName((String)this.profileContainer.getFirstProfile().getProfileName());
            this.profileContainer.setActiveProfile(this.profileContainer.getFirstProfile());
            activeProfile = this.profileContainer.getActiveProfile();
        } else {
            this.profileContainer.setActiveProfile(activeProfile);
        }
        int activeProfileIndex = this.profileList.indexOf(activeProfile);
        this.profileTable.setInput(this.profileList);
        this.profileTable.getTable().setSelection(activeProfileIndex);
        this.profileTable.setSelection(this.profileTable.getSelection(), true);
    }

    private CertificateInformation getCertificateInformation(SigningProfileItem item) {
        String keyType = Certification.KeyExtension.p12.getKeyType();
        if (item.hasPassword()) {
            return new CertificateInformation(item.getKeyLocation(), keyType, item.getPassword());
        }
        return new CertificateInformation(item.getKeyLocation(), keyType, null);
    }

    private void updateProfileListFromFile() {
        this.profileContainer = SigningProfileUtil.getProfileContainerFromFile();
        this.profileList = this.profileContainer.getProfiles();
    }

    private void setActiveProfile() {
        TableItem[] items = this.profileTable.getTable().getSelection();
        if (items.length < 1) {
            return;
        }
        SigningProfile selectedProfile = (SigningProfile)items[0].getData();
        TableItem[] tableItemArray = this.profileTable.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            SigningProfile profile = (SigningProfile)item.getData();
            if (profile == selectedProfile) {
                SigningProfileUtil.setActiveProfileName((String)profile.getProfileName());
            }
            ++n2;
        }
        this.profileTable.refresh();
        this.applyActiveProfile();
    }

    public void close() {
        this.applyActiveProfile();
    }

    private void applyActiveProfile() {
        if (!this.profileList.isEmpty()) {
            String activeProfileName = SigningProfileUtil.getActiveProfileName();
            SigningProfile activeProfile = this.profileContainer.getProfileByName(activeProfileName);
            this.profileContainer.setActiveProfile(activeProfile);
        }
        SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)this.profileContainer);
        this.logger.trace("Security preferences was saved");
    }

    public void migrateProfile() {
        boolean applyAll = false;
        int importSelection = 0;
        ProfileMigrationDialog dlg = new ProfileMigrationDialog(this.getShell());
        if (dlg.open() == 0) {
            SigningProfileContainer importingContainer = SigningProfileUtil.getProfileContainerFromFile((String)dlg.getCertPath());
            for (SigningProfile profile : importingContainer.getProfiles()) {
                String profileName = profile.getProfileName();
                if (this.profileContainer.containsProfile(profileName)) {
                    SigningProfile origProfile = this.profileContainer.getProfileByName(profileName);
                    if (origProfile != null && origProfile.equals(profile)) continue;
                    if (!applyAll) {
                        DuplicateProfileDialog dupDlg = new DuplicateProfileDialog(this.getShell(), origProfile, profile);
                        if (dupDlg.open() != 0) continue;
                        applyAll = dupDlg.getApplyAll();
                        importSelection = dupDlg.getImportSelection();
                    }
                    if (importSelection == 0) {
                        this.profileContainer.removeProfile(origProfile);
                        this.profileContainer.addProfile(profile);
                        continue;
                    }
                    if (importSelection != 2) continue;
                    String newName = String.valueOf(profileName) + " (1)";
                    while (this.profileContainer.containsProfile(newName)) {
                        newName = newName.concat(" (1)");
                    }
                    profile.setProfileName(newName);
                    this.profileContainer.addProfile(profile);
                    continue;
                }
                this.profileContainer.addProfile(profile);
            }
            if (this.profileContainer.getActiveProfile() == null && importingContainer.getActiveProfile() != null) {
                this.profileContainer.setActiveProfile(importingContainer.getActiveProfile());
            }
            SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)this.profileContainer);
            this.updateProfileListFromFile();
            this.setInput();
        }
    }
}

