/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.tizen.common.sign.spi.EncryptionService;
import org.tizen.common.sign.spi.loader.DynamicClassLoader;

public class EncryptionServiceContainer {
    private final List<EncryptionService> services = new ArrayList<EncryptionService>();
    private ServiceLoader<EncryptionService> loader;
    private static EncryptionServiceContainer container;

    private EncryptionServiceContainer() {
        this.loadServices();
    }

    public static EncryptionServiceContainer getInstance() {
        if (container == null) {
            container = new EncryptionServiceContainer();
        }
        return container;
    }

    private boolean loadServices() {
        this.loader = ServiceLoader.load(EncryptionService.class, DynamicClassLoader.getClassLoader());
        Iterator<EncryptionService> services = this.loader.iterator();
        while (services.hasNext()) {
            this.services.add(services.next());
        }
        return this.services.size() > 0;
    }

    public EncryptionService getInternalEncryptionService() {
        EncryptionService internalService = null;
        for (EncryptionService service : this.services) {
            if (!service.getEncryptionType().equals("INTERNAL")) continue;
            return service;
        }
        return internalService;
    }
}

