/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.browser.StreamConsumer;
import org.eclipse.osgi.util.NLS;

public class CustomBrowser
implements IBrowser {
    public static final String CUSTOM_BROWSER_PATH_KEY = "custom_browser_path";

    @Override
    public void close() {
    }

    @Override
    public boolean isCloseSupported() {
        return false;
    }

    @Override
    public void displayURL(String url) throws Exception {
        String path = Platform.getPreferencesService().getString("org.eclipse.help.base", CUSTOM_BROWSER_PATH_KEY, "", null);
        String[] command = this.prepareCommand(path, url);
        try {
            Process pr = Runtime.getRuntime().exec(command);
            StreamConsumer outConsumer = new StreamConsumer(pr.getInputStream());
            outConsumer.setName("Custom browser adapter output reader");
            outConsumer.start();
            StreamConsumer errConsumer = new StreamConsumer(pr.getErrorStream());
            errConsumer.setName("Custom browser adapter error reader");
            errConsumer.start();
        }
        catch (Exception e) {
            HelpBasePlugin.logError("Launching URL \"" + url + "\" using browser program \"" + path + "\" has failed.  Specify another browser in help preferences.", e);
            throw new Exception(NLS.bind((String)HelpBaseResources.CustomBrowser_errorLaunching, (Object)url, (Object)path));
        }
    }

    @Override
    public boolean isSetLocationSupported() {
        return false;
    }

    @Override
    public boolean isSetSizeSupported() {
        return false;
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public void setSize(int width, int height) {
    }

    private String[] prepareCommand(String path, String url) {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer qTokenizer = new StringTokenizer(path.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    if ("win32".equalsIgnoreCase(Platform.getOS())) {
                        tokenList.add("\"" + quotedString + "\"");
                    } else {
                        tokenList.add(quotedString);
                    }
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                tokenList.add(parser.nextToken());
            }
        }
        boolean substituted = false;
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            String newToken = this.doSubstitutions(token, url);
            if (newToken != null) {
                tokenList.set(i, newToken);
                substituted = true;
            }
            ++i;
        }
        if (!substituted) {
            tokenList.add(url);
        }
        String[] command = new String[tokenList.size()];
        tokenList.toArray(command);
        return command;
    }

    private String doSubstitutions(String token, String url) {
        boolean substituted = false;
        StringBuffer newToken = new StringBuffer(token);
        String substitutionMarker = "%1";
        int index = newToken.indexOf(substitutionMarker);
        while (index != -1) {
            newToken.replace(index, index + substitutionMarker.length(), url);
            index = newToken.indexOf(substitutionMarker, index + url.length());
            substituted = true;
        }
        if (substituted) {
            return newToken.toString();
        }
        return null;
    }
}

