/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.wizard;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.common.CertificateTextModifyListener;
import org.tizen.common.sign.ui.validator.CertificateCommonValidator;
import org.tizen.common.sign.ui.validator.CertificateCountryValidator;
import org.tizen.common.sign.ui.validator.CertificateEmailValidator;
import org.tizen.common.sign.ui.validator.CertificateKeyFilenameValidator;
import org.tizen.common.sign.ui.validator.CertificatePasswordValidator;
import org.tizen.common.sign.ui.validator.CertificateUsernameValidator;
import org.tizen.common.sign.ui.validator.ICertificateValidator;
import org.tizen.common.sign.ui.wizard.CertificateBaseWizardPage;
import org.tizen.common.sign.ui.wizard.Messages;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.ui.widget.ExpandableTitleLabel;
import org.tizen.common.util.ImageUtil;

public class AuthorCertCreationPage
extends CertificateBaseWizardPage {
    private final int IDX_KEYFILENAME = 0;
    private final int IDX_USERNAME = 1;
    private final int IDX_PASSWORD = 2;
    private final int IDX_PASSWORD2 = 3;
    private final int IDX_COUNTRY = 4;
    private final int IDX_STATE = 5;
    private final int IDX_CITY = 6;
    private final int IDX_ORGANIZATION = 7;
    private final int IDX_DEPARTMENT = 8;
    private final int IDX_EMAIL = 9;
    private ScrolledComposite scomp;
    private ExpandableComposite ecomp;
    private Composite mainComp;
    private List<Text> textList = new ArrayList<Text>();
    public final Image ARROW_NOR = ImageUtil.getImage((String)"org.tizen.common.sign.ui", (String)"icons/arrow_open_nor.png");
    public final Image ARROW_SEL = ImageUtil.getImage((String)"org.tizen.common.sign.ui", (String)"icons/arrow_open_sel.png");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected AuthorCertCreationPage(String pageName) {
        super(pageName);
        this.setDescription(Messages.AUTHOR_CERT_CREATE_DESC);
    }

    public void dispose() {
        super.dispose();
        this.ARROW_NOR.dispose();
        this.ARROW_SEL.dispose();
    }

    public void createControl(Composite parent) {
        this.scomp = new ScrolledComposite(parent, 512);
        this.scomp.setLayout((Layout)new GridLayout(1, false));
        this.scomp.setLayoutData((Object)new GridData(768));
        this.mainComp = new Composite((Composite)this.scomp, 0);
        this.mainComp.setLayout((Layout)new FormLayout());
        Composite lastComp = this.createRequiredFields(this.mainComp);
        this.createAdditionalTitle(this.mainComp, lastComp);
        this.createAdditionalFields(this.mainComp, lastComp);
        this.scomp.setContent((Control)this.mainComp);
        this.scomp.setExpandHorizontal(true);
        this.scomp.setExpandVertical(true);
        this.setControl((Control)this.scomp);
        this.setPageComplete(false);
    }

    public void setRedraw(boolean value) {
        this.scomp.setRedraw(value);
    }

    @Override
    protected Label createErrorLabel(Composite parent) {
        new Label(parent, 0);
        return super.createErrorLabel(parent);
    }

    private Composite createTextLabelComposite(Composite parent, Composite topComp, String text, String message, boolean password, boolean required, ICertificateValidator validator) {
        int marginLeft = required ? 30 : 10;
        int marginRight = marginLeft * -1;
        int marginTop = 5;
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, marginLeft);
        formData.right = new FormAttachment(100, marginRight);
        if (topComp == null) {
            marginTop = required ? 30 : 10;
            formData.top = new FormAttachment(0, marginTop);
        } else {
            formData.top = new FormAttachment((Control)topComp, marginTop);
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)formData);
        Label label = new Label(composite, 0);
        GridData layoutData = new GridData();
        layoutData.widthHint = 140;
        label.setLayoutData((Object)layoutData);
        label.setText(text);
        label.setFont(TizenFonts.getBoldFont());
        Text txControl = this.createText(composite, message, password, required, validator);
        Label lControl = this.createErrorLabel(composite);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = 10;
        lControl.setLayoutData((Object)layoutData);
        txControl.setData("label", (Object)lControl);
        this.textList.add(txControl);
        return composite;
    }

    private Composite createRequiredFields(Composite parent) {
        Composite subComp = this.createTextLabelComposite(parent, null, Messages.AUTHOR_CERT_CREATE_KEY_FILENAME, Messages.AUTHOR_CERT_CREATE_KEY_FILENAME_DESC, false, true, new CertificateKeyFilenameValidator());
        subComp = this.createTextLabelComposite(parent, subComp, Messages.AUTHOR_CERT_CREATE_AUTHOR_NAME, Messages.AUTHOR_CERT_CREATE_AUTHOR_NAME_DESC, false, true, new CertificateUsernameValidator());
        subComp = this.createTextLabelComposite(parent, subComp, Messages.AUTHOR_CERT_CREATE_PASSWORD, Messages.AUTHOR_CERT_CREATE_PASSWORD_DESC, true, true, new CertificatePasswordValidator());
        subComp = this.createTextLabelComposite(parent, subComp, Messages.AUTHOR_CERT_CREATE_PASSWORD_CONFIRM, Messages.AUTHOR_CERT_CREATE_PASSWORD_CONFIRM_DESC, true, true, null);
        this.textList.get(3).setEnabled(false);
        return subComp;
    }

    private void createAdditionalTitle(Composite parent, Composite topComp) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)topComp, 4);
        Composite labelComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        labelComp.setLayout((Layout)layout);
        labelComp.setLayoutData((Object)formData);
        ExpandableTitleLabel title = new ExpandableTitleLabel(labelComp, 0, Messages.AUTHOR_CERT_CREATE_MORE_FIELD, this.ARROW_NOR, this.ARROW_SEL);
        title.addExpansionListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                Method method = null;
                try {
                    method = ExpandableComposite.class.getDeclaredMethod("programmaticToggleState", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)AuthorCertCreationPage.this.ecomp, new Object[0]);
                }
                catch (Exception e) {
                    AuthorCertCreationPage.this.logger.error("Failed to expand", (Throwable)e);
                    return;
                }
            }
        });
    }

    private void createAdditionalFields(Composite parent, Composite topComp) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)topComp, 4);
        this.ecomp = new ExpandableComposite(parent, 4096);
        this.ecomp.setLayoutData((Object)formData);
        Composite additionalComp = new Composite((Composite)this.ecomp, 0);
        additionalComp.setLayout((Layout)new FormLayout());
        Composite subComp = this.createTextLabelComposite(additionalComp, null, Messages.AUTHOR_CERT_CREATE_COUNTRY, Messages.AUTHOR_CERT_CREATE_COUNTRY_DESC, false, false, new CertificateCountryValidator());
        subComp = this.createTextLabelComposite(additionalComp, subComp, Messages.AUTHOR_CERT_CREATE_STATE, Messages.AUTHOR_CERT_CREATE_STATE_DESC, false, false, new CertificateCommonValidator());
        subComp = this.createTextLabelComposite(additionalComp, subComp, Messages.AUTHOR_CERT_CREATE_CITY, Messages.AUTHOR_CERT_CREATE_CITY_DESC, false, false, new CertificateCommonValidator());
        subComp = this.createTextLabelComposite(additionalComp, subComp, Messages.AUTHOR_CERT_CREATE_ORGANIZATION, Messages.AUTHOR_CERT_CREATE_ORGANIZATION_DESC, false, false, null);
        subComp = this.createTextLabelComposite(additionalComp, subComp, Messages.AUTHOR_CERT_CREATE_DEPARTMENT, Messages.AUTHOR_CERT_CREATE_DEPARTMENT_DESC, false, false, null);
        this.createTextLabelComposite(additionalComp, subComp, Messages.AUTHOR_CERT_CREATE_EMAIL, Messages.AUTHOR_CERT_CREATE_EMAIL_DESC, false, false, new CertificateEmailValidator());
        this.ecomp.setClient((Control)additionalComp);
        this.ecomp.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent event) {
                if (event.getState()) {
                    Point expandableSize = AuthorCertCreationPage.this.mainComp.computeSize(-1, -1);
                    Point scompSize = AuthorCertCreationPage.this.scomp.getSize();
                    if (expandableSize.y > scompSize.y) {
                        AuthorCertCreationPage.this.scomp.setMinHeight(expandableSize.y);
                    }
                    AuthorCertCreationPage.this.scomp.layout(true, true);
                    AuthorCertCreationPage.this.scomp.setOrigin(expandableSize);
                } else {
                    AuthorCertCreationPage.this.scomp.setMinHeight(((AuthorCertCreationPage)AuthorCertCreationPage.this).mainComp.computeSize((int)-1, (int)-1).y);
                    AuthorCertCreationPage.this.scomp.layout(true, true);
                }
            }

            public void expansionStateChanging(ExpansionEvent arg0) {
            }
        });
    }

    private Text createText(Composite composite, String message, boolean password, boolean required, ICertificateValidator validator) {
        Text control = null;
        control = required ? this.createCertRequiredText(composite, message, password) : this.createCertOptionalText(composite, message, password);
        control.addModifyListener((ModifyListener)new InternalTextModifyListener(validator));
        return control;
    }

    public boolean canFlipToNextPage() {
        return this.bCanNextPage;
    }

    private void setErrorLabel(int idx, String message) {
        Label label = (Label)this.textList.get(idx).getData("label");
        label.setText(message);
        label.getParent().layout();
    }

    private void validate() {
        boolean enableNext = false;
        Text txPasswd1 = this.textList.get(2);
        Text txPasswd2 = this.textList.get(3);
        boolean errorPasswd = (Boolean)txPasswd1.getData("error");
        if (errorPasswd) {
            txPasswd2.setEnabled(false);
            this.setErrorLabel(3, "");
        } else {
            txPasswd2.setEnabled(true);
            String keyPassword = txPasswd1.getText();
            String keyPassword2 = txPasswd2.getText();
            if (!keyPassword.equals(keyPassword2)) {
                this.setErrorLabel(3, Messages.AUTHOR_CERT_CREATE_PASSWORD_NOT_MATCH);
            } else {
                this.setErrorLabel(3, "");
                enableNext = true;
            }
        }
        int idx = 0;
        while (idx < this.textList.size()) {
            Text tx;
            boolean fieldError;
            if (idx != 2 && idx != 3 && (fieldError = ((Boolean)(tx = this.textList.get(idx)).getData("error")).booleanValue())) {
                enableNext = false;
            }
            ++idx;
        }
        this.enableNextPage(enableNext);
    }

    public String getKeyfilename() {
        return this.getText(0);
    }

    public String getUsername() {
        return this.getText(1);
    }

    public String getPassword() {
        return this.getText(2);
    }

    public String getPassword2() {
        return this.getText(3);
    }

    public String getCountry() {
        return this.getText(4);
    }

    public String getState() {
        return this.getText(5);
    }

    public String getCity() {
        return this.getText(6);
    }

    public String getOrganization() {
        return this.getText(7);
    }

    public String getDepartment() {
        return this.getText(8);
    }

    public String getEmail() {
        return this.getText(9);
    }

    public String getText(int index) {
        return this.textList.get(index).getText();
    }

    private class InternalTextModifyListener
    extends CertificateTextModifyListener {
        public InternalTextModifyListener(ICertificateValidator validator) {
            super(validator);
        }

        @Override
        public void modifyText(ModifyEvent event) {
            super.modifyText(event);
            AuthorCertCreationPage.this.validate();
        }
    }
}

