/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.AbstractAppCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;

public class PackageInfoCommand
extends AbstractAppCommand {
    public static final String CHECK_ROMOVABLE_COMMAND = "pkginfo --pkg %s | grep -i Removable";
    public static final String CHECK_INSTALLED_COMMAND = "pkgcmd -l -t %s | grep %s --word-regexp";
    public static final String GET_PACKAGE_ID_COMMAND = "pkginfo --app %s | grep %s";
    private String command = "";

    public PackageInfoCommand(IDevice device, ITizenConsoleManager console) {
        this.device = device;
        this.launchConsole = console;
    }

    public boolean isRemovable(String pkgId) throws Exception {
        String[] lines;
        this.command = String.format(CHECK_ROMOVABLE_COMMAND, pkgId);
        this.executeCommand();
        String[] stringArray = lines = this.helper.getResultLineStrings();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (TizenPlatformConstants.ROAPP_RESULT.equals(line)) {
                return false;
            }
            if (TizenPlatformConstants.RWAPP_RESULT.equals(line)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isInstalled(String pkgId, String pkgType) throws Exception {
        this.command = String.format(CHECK_INSTALLED_COMMAND, pkgType, pkgId);
        this.executeCommand();
        String endLine = this.helper.getEndLine();
        return endLine != null && !endLine.isEmpty();
    }

    public String getPkgId(String appId) throws Exception {
        String packageStr = "Package: ";
        this.command = String.format(GET_PACKAGE_ID_COMMAND, appId, packageStr);
        this.executeCommand();
        String[] lines = this.helper.getResultLineStrings();
        String pkgId = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(packageStr)) {
                pkgId = line.substring(packageStr.length());
                break;
            }
            ++n2;
        }
        return pkgId;
    }

    @Override
    protected void executeCommand() throws Exception {
        this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
        this.helper.runCommand(this.getCommand());
    }

    protected String getCommand() {
        return this.command;
    }
}

