/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.cryptutil;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.cryptutil.ICrypt;
import org.tizen.sdblib.util.IOUtil;

public class WinCrypt
implements ICrypt {
    private static final Logger logger = LoggerFactory.getLogger(WinCrypt.class);
    public static String EXE_PATH = Paths.get(InstallPathConfig.getToolsPath(), "certificate-encryptor", "wincrypt").toString();
    private static final String PREFIX = "PASSWORD:";
    private static final String ENCRYPT = "--encrypt";
    private static final String DECRYPT = "--decrypt";

    @Override
    public void encrypt(String password, String filename) {
        new Thread(() -> {
            String pwd = StringEscapeUtils.escapeJava((String)password);
            String[] CMD_ARRAY = new String[]{EXE_PATH, ENCRYPT, pwd, filename};
            try {
                ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
                Process process = builder.start();
                process.waitFor();
            }
            catch (IOException ioe) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                logger.error("Exception occurred while encrypting the password.", (Throwable)ie);
            }
        }).start();
    }

    @Override
    public String decrypt(String filename) {
        String line;
        block6: {
            String[] CMD_ARRAY = new String[]{EXE_PATH, DECRYPT, filename};
            line = null;
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    ProcessBuilder builder = new ProcessBuilder(CMD_ARRAY);
                    Process process = builder.start();
                    inputStream = process.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    line = bufferedReader.readLine();
                }
                catch (IOException ioe) {
                    logger.error("Exception occurred while decrypting the password.", (Throwable)ioe);
                    IOUtil.tryClose(bufferedReader);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(bufferedReader);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)bufferedReader);
        }
        if (line != null && line.startsWith(PREFIX)) {
            return line.substring(PREFIX.length());
        }
        return "";
    }
}

