/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.dialog.IoTCertificateExtensionHandler;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.util.DialogUtil;

public class IoTProfileRemovalListener
extends MouseAdapter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TableViewer profileTableViewer;
    private IoTCertificateExtensionHandler handler;

    public IoTProfileRemovalListener(TableViewer tableViewer, IoTCertificateExtensionHandler handler) {
        this.profileTableViewer = tableViewer;
        this.handler = handler;
    }

    public void mouseUp(MouseEvent e) {
        String activeProfileName = this.getActiveProfileName();
        TableItem[] items = this.profileTableViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        TableItem[] selectedItems = this.profileTableViewer.getTable().getSelection();
        if (selectedItems.length < 1) {
            return;
        }
        TableItem removableItem = selectedItems[0];
        int removableItemIndex = this.profileTableViewer.getTable().getSelectionIndex();
        String selectedProfile = (String)removableItem.getData();
        TableItem nextActiveItem = null;
        int result = DialogUtil.openQuestionDialog((String)String.format(Messages.PROFILE_REMOVE_QUESTION, removableItem.getText()));
        if (result == 128) {
            return;
        }
        if (activeProfileName != null) {
            boolean isTheLastProfile;
            boolean isActive = activeProfileName.equals(selectedProfile);
            boolean bl = isTheLastProfile = items.length == 1;
            if (isActive && !isTheLastProfile) {
                nextActiveItem = items.length == removableItemIndex + 1 ? items[0] : this.profileTableViewer.getTable().getItem(removableItemIndex + 1);
                String profile = (String)nextActiveItem.getData();
                this.setActiveProfileName(profile);
            } else if (isActive & isTheLastProfile) {
                this.setActiveProfileName("");
            } else {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getText().equals(activeProfileName)) {
                        nextActiveItem = item;
                        break;
                    }
                    ++n2;
                }
            }
        }
        List input = (List)this.profileTableViewer.getInput();
        input.remove(removableItemIndex);
        this.removeProfile(selectedProfile);
        if (nextActiveItem != null) {
            this.profileTableViewer.getTable().setSelection(nextActiveItem);
            this.profileTableViewer.setSelection(this.profileTableViewer.getSelection(), true);
        }
        this.profileTableViewer.refresh();
        super.mouseUp(e);
    }

    private String getActiveProfileName() {
        String activeProfileName = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "getActiveCertificate");
            activeProfileName = (String)this.handler.execute(new ExecutionEvent(null, parameters, null, null));
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to execute get active profile name command", (Throwable)e);
        }
        return activeProfileName;
    }

    private void setActiveProfileName(String profileName) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "setActiveCertificate");
            parameters.put("certificateName", profileName);
            this.handler.execute(new ExecutionEvent(null, parameters, null, null));
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to execute set active profile name command", (Throwable)e);
        }
    }

    private void removeProfile(String profileName) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "removeCertificate");
            parameters.put("certificateName", profileName);
            this.handler.execute(new ExecutionEvent(null, parameters, null, null));
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to remove profile command", (Throwable)e);
        }
    }
}

