/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.genericeditor.CompositeQuickAssistProcessor;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.DefaultContentAssistProcessor;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.PresentationReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.TextHoverRegistry;
import org.eclipse.ui.internal.genericeditor.markers.MarkerResoltionQuickAssistProcessor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;

public final class ExtensionBasedTextViewerConfiguration
extends TextSourceViewerConfiguration
implements IDocumentPartitioningListener {
    private ITextEditor editor;
    private Set<IContentType> contentTypes;
    private IDocument document;
    private ContentAssistant contentAssistant;
    private List<IContentAssistProcessor> processors;

    public ExtensionBasedTextViewerConfiguration(final ITextEditor editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
        this.editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    ExtensionBasedTextViewerConfiguration.this.watchDocument(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                }
            }
        });
    }

    private Set<IContentType> getContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new LinkedHashSet<IContentType>();
            LinkedList<IContentType> types = new LinkedList<IContentType>(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(this.editor.getEditorInput().getName())));
            while (!types.isEmpty()) {
                IContentType type = (IContentType)types.poll();
                this.contentTypes.add(type);
                IContentType parent = type.getBaseType();
                if (parent == null) continue;
                types.add(parent);
            }
        }
        return this.contentTypes;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        TextHoverRegistry registry = GenericEditorPlugin.getDefault().getHoverRegistry();
        return registry.getAvailableHover(sourceViewer, this.getContentTypes());
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistProcessorRegistry registry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
        this.contentAssistant = new ContentAssistant(true);
        this.contentAssistant.setContextInformationPopupOrientation(21);
        this.contentAssistant.setProposalPopupOrientation(11);
        this.contentAssistant.enableColoredLabels(true);
        this.contentAssistant.enableAutoActivation(true);
        this.processors = registry.getContentAssistProcessors(sourceViewer, this.getContentTypes());
        if (this.processors.isEmpty()) {
            this.processors.add(new DefaultContentAssistProcessor());
        }
        for (IContentAssistProcessor processor : this.processors) {
            this.contentAssistant.addContentAssistProcessor(processor, "__dftl_partition_content_type");
        }
        if (this.document != null) {
            this.associateTokenContentTypes(this.document);
        }
        this.contentAssistant.setInformationControlCreator((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return this.contentAssistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconcilerRegistry registry = GenericEditorPlugin.getDefault().getPresentationReconcilerRegistry();
        List<IPresentationReconciler> reconciliers = registry.getPresentationReconcilers(sourceViewer, this.getContentTypes());
        if (!reconciliers.isEmpty()) {
            return reconciliers.get(0);
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    void watchDocument(IDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
        this.document = document;
        this.associateTokenContentTypes(document);
        document.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
    }

    public void documentPartitioningChanged(IDocument document) {
        this.associateTokenContentTypes(document);
    }

    private void associateTokenContentTypes(IDocument document) {
        if (this.contentAssistant == null || this.processors == null) {
            return;
        }
        String[] stringArray = document.getLegalContentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String legalTokenContentType = stringArray[n2];
            for (IContentAssistProcessor processor : this.processors) {
                this.contentAssistant.addContentAssistProcessor(processor, legalTokenContentType);
            }
            ++n2;
        }
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssistAssistant = new QuickAssistAssistant();
        CompositeQuickAssistProcessor processor = new CompositeQuickAssistProcessor(Arrays.asList(new MarkerResoltionQuickAssistProcessor(), new SpellingCorrectionProcessor()));
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)processor);
        quickAssistAssistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        quickAssistAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString());
            }
        });
        return quickAssistAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }
}

