/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.model;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.signer.TizenIncrementalSigner;

public class CertificateInformation {
    private String filename = "";
    private String filepath = "";
    private String expires = "";
    private String subjectCommonName = "";
    private String subjectOrganization = "";
    private String subjectOrganizationalUnit = "";
    private String subjectCountry = "";
    private String subjectState = "";
    private String subjectLocality = "";
    private String issuerCommonName = "";
    private String keyType;
    private boolean lock = true;
    private boolean isIotService = false;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CertificateInformation(String keyLocation, String keyType) {
        this.filepath = keyLocation;
        this.filename = new Path(keyLocation).lastSegment();
        this.keyType = keyType;
    }

    public CertificateInformation(String keyLocation, String keyType, char[] password) {
        this(keyLocation, keyType);
        if (password != null) {
            this.setData(password);
        }
    }

    public CertificateInformation(String data, X509Certificate cert, boolean isPrivatekey) {
        this.filename = data;
        this.isIotService = true;
        if (!isPrivatekey) {
            this.lock = false;
        }
        if (cert != null) {
            String[] issuerName;
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
            this.expires = format.format(cert.getNotAfter());
            String[] stringArray = issuerName = cert.getIssuerDN().getName().split(",");
            int n = issuerName.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if ((name = name.trim()).startsWith(NameType.CommonName.getPrefix())) {
                    this.issuerCommonName = name.substring(NameType.CommonName.prefixLength());
                    break;
                }
                ++n2;
            }
        }
    }

    private void setData(char[] password) {
        try {
            String[] issuerName;
            String[] subjectName;
            KeyStore keyStore = TizenIncrementalSigner.loadKeyStore(this.filepath, this.keyType, password);
            String alias = TizenIncrementalSigner.getFirstAlias(keyStore);
            if (alias == null) {
                throw new KeyStoreException("Couldn't find an alias in the key store.");
            }
            Certificate[] certificateChain = keyStore.getCertificateChain(alias);
            X509Certificate cert = (X509Certificate)certificateChain[0];
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
            this.expires = format.format(cert.getNotAfter());
            String[] stringArray = subjectName = cert.getSubjectDN().getName().split(",");
            int n = subjectName.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if ((name = name.trim()).startsWith(NameType.CommonName.getPrefix())) {
                    this.subjectCommonName = name.substring(NameType.CommonName.prefixLength());
                } else if (name.startsWith(NameType.Organization.getPrefix())) {
                    this.subjectOrganization = name.substring(NameType.Organization.prefixLength());
                } else if (name.startsWith(NameType.OrganizationalUnit.getPrefix())) {
                    this.subjectOrganizationalUnit = name.substring(NameType.OrganizationalUnit.prefixLength());
                } else if (name.startsWith(NameType.Country.getPrefix())) {
                    this.subjectCountry = name.substring(NameType.Country.prefixLength());
                } else if (name.startsWith(NameType.State.getPrefix())) {
                    this.subjectState = name.substring(NameType.State.prefixLength());
                } else if (name.startsWith(NameType.Locality.getPrefix())) {
                    this.subjectLocality = name.substring(NameType.Locality.prefixLength());
                }
                ++n2;
            }
            String[] stringArray2 = issuerName = cert.getIssuerDN().getName().split(",");
            int n3 = issuerName.length;
            n = 0;
            while (n < n3) {
                String name = stringArray2[n];
                if ((name = name.trim()).startsWith(NameType.CommonName.getPrefix())) {
                    this.issuerCommonName = name.substring(NameType.CommonName.prefixLength());
                    break;
                }
                ++n;
            }
            this.lock = false;
        }
        catch (KeyStoreException e) {
            this.logger.error("Failed to get certificate data", (Throwable)e);
            return;
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Not supported algorithm", (Throwable)e);
        }
        catch (CertificateException e) {
            this.logger.error("Failed to get certificate data", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("File is not found or file cannot be opened", (Throwable)e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getExpires() {
        return this.expires;
    }

    public String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public String getSubjectOrganization() {
        return this.subjectOrganization;
    }

    public String getSubjectOrganizationalUnit() {
        return this.subjectOrganizationalUnit;
    }

    public String getSubjectCountry() {
        return this.subjectCountry;
    }

    public String getSubjectState() {
        return this.subjectState;
    }

    public String getSubjectLocality() {
        return this.subjectLocality;
    }

    public String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isIotService() {
        return this.isIotService;
    }

    public static enum NameType {
        Country("C"),
        State("ST"),
        Locality("L"),
        Organization("O"),
        OrganizationalUnit("OU"),
        CommonName("CN");

        private String type;

        private NameType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getPrefix() {
            return String.valueOf(this.type) + "=";
        }

        public int prefixLength() {
            return this.getPrefix().length();
        }
    }
}

