/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionExplorerPanel;
import org.tizen.sdblib.service.FileEntry;

public class ConnectionExplorerFileLabelProvider
implements ITableLabelProvider {
    private final Image fileImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private final Image folderImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory.png").createImage();
    private final Image fileLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file_link.png").createImage();
    private final Image folderLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory_link.png").createImage();
    private final Image otherImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private final Image emulatorImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator.png").createImage();
    private final Image deviceImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/device.png").createImage();
    public static final String UNKNOWN_FILE_SIZE = "N/A";

    public String getColumnText(Object element, int column_index) {
        if (column_index == 0) {
            return ((FileEntry)element).getName();
        }
        if (column_index == 1) {
            return ((FileEntry)element).getDate();
        }
        if (column_index == 2) {
            FileEntry fileEntry = (FileEntry)element;
            if (fileEntry.getType().isDevice()) {
                return UNKNOWN_FILE_SIZE;
            }
            return ConnectionExplorerPanel.sizeFormat.format(Long.valueOf(fileEntry.getSize()));
        }
        return "";
    }

    public boolean isLabelProperty(Object obj, String s) {
        return false;
    }

    public Image getColumnImage(Object element, int column_index) {
        if (column_index == 0 && element instanceof FileEntry) {
            FileEntry entry = (FileEntry)element;
            switch (entry.getType()) {
                case File: {
                    return this.fileImage;
                }
                case Link: {
                    return this.fileLinkImage;
                }
                case Directory: {
                    return this.folderImage;
                }
                case DirectoryLink: {
                    return this.folderLinkImage;
                }
                case RootEmulator: {
                    return this.emulatorImage;
                }
                case RootDevice: {
                    return this.deviceImage;
                }
            }
            return this.otherImage;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

