/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import java.io.IOException;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.action.ActionEmulatorManager;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.Messages;
import org.tizen.common.connection.toolbar.TargetToolBarManager;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;

public class ToolbarContributor
extends WorkbenchWindowControlContribution
implements TargetToolBarManager.TargetChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ToolbarContributor.class);
    private TargetToolBarManager toolbarManager = ConnectionPlugin.getDefault().getTargetToolBarManager();
    private static final int TOOLBAR_DEFAULT_WIDTH = 150;
    private Menu itemMenu;
    private CLabel lbl;

    public ToolbarContributor() {
        this.toolbarManager.addListener(this);
        ConnectionPlugin.getDefault().addSelectionListener(this);
    }

    public boolean isDynamic() {
        return true;
    }

    protected Control createControl(Composite parent) {
        parent.getParent().setRedraw(true);
        final Composite container = new Composite(parent, 2048);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.marginTop = 0;
        glContainer.marginBottom = 0;
        glContainer.marginHeight = 0;
        glContainer.marginWidth = 0;
        container.setLayout((Layout)glContainer);
        final Composite btnCntrl = new Composite(container, 0);
        btnCntrl.setBackground(container.getDisplay().getSystemColor(1));
        btnCntrl.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 1).applyTo(btnCntrl);
        this.lbl = new CLabel(btnCntrl, 0);
        GridData glReader = new GridData(4, 4, false, false, 1, 1);
        glReader.widthHint = 150;
        this.lbl.setLayoutData((Object)glReader);
        if (this.toolbarManager.getDeviceDescriptors().isEmpty()) {
            this.lbl.setText(Messages.NoActiveTarget);
        } else {
            DeviceDescriptor device = this.toolbarManager.getDefaultDeviceDescriptor();
            if (device != null) {
                this.lbl.setText(device.getDescriptorName());
            }
        }
        Button btn = new Button(btnCntrl, 1028);
        btn.setLayoutData((Object)new GridData(1040));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ToolbarContributor.this.reloadItems(container.getShell());
                Point loc = btnCntrl.getLocation();
                Rectangle rect = btnCntrl.getBounds();
                int offsetHeight = 0;
                if (OSChecker.isMAC()) {
                    offsetHeight = 2;
                }
                Point mLoc = new Point(loc.x - 1, loc.y + rect.height + offsetHeight);
                ToolbarContributor.this.itemMenu.setLocation(container.getShell().getDisplay().map((Control)btnCntrl.getParent(), null, mLoc));
                ToolbarContributor.this.itemMenu.setVisible(true);
            }
        });
        return container;
    }

    @Override
    public void targetsChanged(final DeviceDescriptor device, int mask) {
        final int conExpItemCnt = SmartDevelopmentBridge.getBridge().getDevices().length;
        switch (mask) {
            case 1: {
                logger.debug(String.format("Target(%s) has been connected", device.getSerialId()));
                this.toolbarManager.updateDeviceDescriptor(device);
            }
            case 4: {
                logger.debug(String.format("VM Target(%s) has been added", device.getSerialId()));
                final String descriptorName = this.toolbarManager.getInitialDescriptorName();
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ToolbarContributor.this.lbl.isDisposed()) {
                            logger.debug("Combo label is disposed");
                            return;
                        }
                        if (conExpItemCnt == 1) {
                            DeviceDescriptor firstItem = ToolbarContributor.this.toolbarManager.getDeviceDescriptors().get(SmartDevelopmentBridge.getBridge().getDevices()[0].getSerialNumber());
                            ToolbarContributor.this.toolbarManager.setDefaultDeviceDescriptor(firstItem);
                            logger.debug(String.format("Select first Target(%s) from CE as default", firstItem.getSerialId()));
                        } else if (ToolbarContributor.this.toolbarManager.getDefaultDeviceDescriptor() == null || !StringUtil.isEmpty((CharSequence)descriptorName) && descriptorName.equals(device.getSerialId())) {
                            ToolbarContributor.this.toolbarManager.setDefaultDeviceDescriptor(device);
                            logger.debug(String.format("Select Target(%s) label as default", device.getSerialId()));
                        }
                        ToolbarContributor.this.lbl.setText(ToolbarContributor.this.toolbarManager.getDefaultDeviceDescriptor().getDescriptorName());
                    }
                });
                break;
            }
            case 2: {
                logger.debug(String.format("Target(%s) has been disconnected", device.getSerialId()));
            }
            case 8: {
                logger.debug(String.format("VM Target(%s) has been removed", device.getSerialId()));
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ToolbarContributor.this.lbl.isDisposed()) {
                            logger.debug("Combo label is disposed");
                            return;
                        }
                        if (ToolbarContributor.this.toolbarManager.getDeviceDescriptors().isEmpty()) {
                            ToolbarContributor.this.lbl.setText(Messages.NoActiveTarget);
                            logger.debug("There is no any target item");
                        } else {
                            if (conExpItemCnt == 2) {
                                String firstId = SmartDevelopmentBridge.getBridge().getDevices()[0].getSerialNumber();
                                if (firstId.equals(device.getSerialId())) {
                                    ToolbarContributor.this.toolbarManager.setDefaultDeviceDescriptor(ToolbarContributor.this.toolbarManager.getDeviceDescriptors().get(SmartDevelopmentBridge.getBridge().getDevices()[1].getSerialNumber()));
                                    logger.debug(String.format("Select first Target(%s) from CE as default", SmartDevelopmentBridge.getBridge().getDevices()[1].getSerialNumber()));
                                } else {
                                    ToolbarContributor.this.toolbarManager.setDefaultDeviceDescriptor(ToolbarContributor.this.toolbarManager.getDeviceDescriptors().get(SmartDevelopmentBridge.getBridge().getDevices()[0].getSerialNumber()));
                                    logger.debug(String.format("Select first Target(%s) from CE as default", SmartDevelopmentBridge.getBridge().getDevices()[0].getSerialNumber()));
                                }
                            } else if (device.getSerialId().equals(ToolbarContributor.this.toolbarManager.getDefaultDeviceDescriptor().getSerialId())) {
                                ToolbarContributor.this.toolbarManager.setFirstItemAsDefaultDescriptor();
                            }
                            ToolbarContributor.this.lbl.setText(ToolbarContributor.this.toolbarManager.getDefaultDeviceDescriptor().getDescriptorName());
                            logger.debug(String.format("Default Target(%s) label has been updated to (%s)", device.getSerialId(), ToolbarContributor.this.toolbarManager.getDefaultDeviceDescriptor().getDescriptorName()));
                        }
                    }
                });
                break;
            }
            default: {
                logger.debug("Not supposed to be called!");
            }
        }
    }

    public void dispose() {
        this.toolbarManager.removeListener(this);
        ConnectionPlugin.getDefault().removeSelectionListener(this);
    }

    private void reloadItems(Shell shell) {
        this.itemMenu = new Menu((Decorations)shell, 8);
        List<DeviceDescriptor> deviceDescriptors = this.toolbarManager.getSortedDeviceItem();
        if (deviceDescriptors.isEmpty()) {
            this.lbl.setText(Messages.NoActiveTarget);
        }
        DeviceDescriptor defaultDescriptor = this.toolbarManager.getDefaultDeviceDescriptor();
        for (DeviceDescriptor device : deviceDescriptors) {
            MenuItem item;
            if (device.equals(defaultDescriptor)) {
                item = new MenuItem(this.itemMenu, 32);
                item.setSelection(true);
            } else {
                item = new MenuItem(this.itemMenu, 8);
            }
            item.setText(device.getDescriptorName());
            if (device.getTooltipName() != null) {
                item.setToolTipText(device.getTooltipName());
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem selected = (MenuItem)e.widget;
                    DeviceDescriptor device = ToolbarContributor.this.toolbarManager.getDeviceDescriptor(selected.getText());
                    if (device != null) {
                        ToolbarContributor.this.toolbarManager.setDefaultDeviceDescriptor(device);
                        ToolbarContributor.this.lbl.setText(selected.getText());
                    }
                }
            });
        }
        new MenuItem(this.itemMenu, 2);
        MenuItem createVMItem = new MenuItem(this.itemMenu, 8);
        createVMItem.setText(Messages.CreateNewEmulator);
        createVMItem.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ActionEmulatorManager.startEmulatorManager();
                        }
                        catch (IOException iOException) {
                            logger.error("Cannot launch emulator manager");
                        }
                    }
                });
            }
        });
        MenuItem createRDItem = new MenuItem(this.itemMenu, 8);
        createRDItem.setText(Messages.CreateRemoteDevice);
        createRDItem.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        });
    }

    @Override
    public void selectionChanged(FileEntry selectedEntry) {
        if (selectedEntry == null || selectedEntry.getParent() != null) {
            return;
        }
        DeviceDescriptor device = this.toolbarManager.getDeviceDescriptors().get(selectedEntry.getDevice().getSerialNumber());
        if (device == null) {
            return;
        }
        logger.debug(String.format("Default target changed (%s) to (%s) by connection explorer", this.toolbarManager.getDefaultDeviceDescriptor().getSerialId(), device.getSerialId()));
        this.toolbarManager.setDefaultDeviceDescriptor(device);
        this.lbl.setText(device.getDescriptorName());
    }
}

