/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class ResourceMgmtActionProvider
extends CommonActionProvider {
    private BuildAction buildAction;
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private CloseUnrelatedProjectsAction closeUnrelatedProjectsAction;
    private RefreshAction refreshAction;
    private Shell shell;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.shell = aSite.getViewSite().getShell();
        this.makeActions();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.closeUnrelatedProjectsAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            Object next = resources.next();
            IProject project = (IProject)Adapters.adapt(next, IProject.class);
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && !ResourcesPlugin.getWorkspace().isAutoBuilding() && hasBuilder) {
            this.buildAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.buildAction);
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.reorganize", (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.reorganize", (IAction)this.closeProjectAction);
            }
        }
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void makeActions() {
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return ResourceMgmtActionProvider.this.shell;
            }
        };
        this.openProjectAction = new OpenResourceAction(sp);
        this.closeProjectAction = new CloseResourceAction(sp);
        this.closeUnrelatedProjectsAction = new CloseUnrelatedProjectsAction(sp);
        this.refreshAction = new RefreshAction(sp){

            public void run() {
                final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
                final WorkspaceModifyOperation op = (WorkspaceModifyOperation)this.createOperation(errorStatus);
                WorkspaceJob job = new WorkspaceJob("refresh"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            op.run(monitor);
                            if (ResourceMgmtActionProvider.this.shell != null && !ResourceMgmtActionProvider.this.shell.isDisposed()) {
                                ResourceMgmtActionProvider.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        StructuredViewer viewer = ResourceMgmtActionProvider.this.getActionSite().getStructuredViewer();
                                        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                                            viewer.refresh();
                                        }
                                    }
                                });
                            }
                        }
                        catch (InvocationTargetException e) {
                            String msg = NLS.bind((String)WorkbenchNavigatorMessages.ResourceMgmtActionProvider_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)e.getTargetException());
                            throw new CoreException((IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 4, msg, e.getTargetException()));
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                        return errorStatus[0];
                    }
                };
                ISchedulingRule rule = op.getRule();
                if (rule != null) {
                    job.setRule(rule);
                }
                job.setUser(true);
                job.schedule();
            }
        };
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.png"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.png"));
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.buildAction = new BuildAction(sp, 10);
        this.buildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.getIDEImageDescriptor((String)relativePath);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.buildAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeUnrelatedProjectsAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }
}

