/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tizen.common.util.Assert;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.IteratingAcceptor;
import org.tizen.common.util.IteratingRunner;
import org.tizen.common.util.ObjectUtil;

public class ArrayUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> boolean isEmpty(T[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    public static <T> T pickupFirst(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return array[0];
    }

    public static <T> T pickupLast(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return array[array.length - 1];
    }

    public static <T> T[] newArray(Class<? extends T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new ArrayIterator<T>(array);
    }

    public static <T> void iterate(T[] array, IteratingRunner<T> runner) {
        try {
            ArrayUtil.iterate(array, runner, true);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void iterate(T[] array, IteratingRunner<T> runner, boolean bForceProcess) throws InvocationTargetException {
        if (runner == null) {
            return;
        }
        T[] args = ArrayUtil.safe(array);
        if (args != null) {
            T[] TArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    T arg = TArray[n2];
                    if (arg != null || bForceProcess) {
                        try {
                            runner.run(arg);
                        }
                        catch (Throwable e) {
                            if (bForceProcess) break block6;
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public static <T> T[] filter(T[] array, IteratingAcceptor<T> runner) {
        try {
            return ArrayUtil.filter(array, runner, true);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T[] filter(T[] array, IteratingAcceptor<T> runner, boolean bForceProcess) throws InvocationTargetException {
        ArrayList<T> list = new ArrayList<T>();
        T[] args = ArrayUtil.safe(array);
        if (args != null) {
            T[] TArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    T arg = TArray[n2];
                    if (arg != null || bForceProcess) {
                        try {
                            if (runner.accept(arg)) {
                                list.add(arg);
                            }
                        }
                        catch (Throwable e) {
                            if (bForceProcess) break block6;
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                ++n2;
            }
        }
        return list.toArray(ArrayUtil.newArray(array.getClass().getComponentType(), list.size()));
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("source must be an array");
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = null;
        int i = 0;
        while (wrapperType == null && i < length) {
            Object obj = Array.get(source, 0);
            if (obj != null) {
                wrapperType = obj.getClass();
            }
            ++i;
        }
        if (wrapperType == null) {
            return (Object[])source;
        }
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        int i2 = 0;
        while (i2 < length) {
            newArray[i2] = Array.get(source, i2);
            ++i2;
        }
        return newArray;
    }

    public static int size(Object obj) {
        if (obj instanceof Object[]) {
            return ArrayUtil.size((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ArrayUtil.size((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ArrayUtil.size((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ArrayUtil.size((char[])obj);
        }
        if (obj instanceof short[]) {
            return ArrayUtil.size((short[])obj);
        }
        if (obj instanceof int[]) {
            return ArrayUtil.size((int[])obj);
        }
        if (obj instanceof long[]) {
            return ArrayUtil.size((long[])obj);
        }
        if (obj instanceof float[]) {
            return ArrayUtil.size((float[])obj);
        }
        if (obj instanceof double[]) {
            return ArrayUtil.size((double[])obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtil.size((Collection)obj);
        }
        return 0;
    }

    public static int size(boolean[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(byte[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(char[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(short[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(int[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(long[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(float[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static int size(double[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static <T> int size(T[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static <T> T[] add(T[] array, T obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = ArrayUtil.size(array) + 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArrLength - 1] = obj;
        return newArr;
    }

    public static <T> T[] prepend(T[] array, T obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = ArrayUtil.size(array) + 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 1, array.length);
        }
        newArr[0] = obj;
        return newArr;
    }

    public static <T> T[] remove(Object[] array, int start, int end) {
        Assert.notNull(array);
        Assert.isTrue(start <= end, "start indnex(" + start + ") is greater than end index(" + end + ")");
        int startIndex = Math.max(0, start);
        int endIndex = Math.min(array.length, end);
        if (endIndex <= startIndex) {
            return array;
        }
        Class<?> compType = array.getClass().getComponentType();
        int removeSize = endIndex - startIndex;
        int newArrLength = ArrayUtil.size(array) - removeSize;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        System.arraycopy(array, 0, newArr, 0, startIndex);
        System.arraycopy(array, endIndex, newArr, startIndex, array.length - endIndex);
        return newArr;
    }

    public static <T> T[] remove(Object[] array, int index) {
        return ArrayUtil.remove(array, index, index + 1);
    }

    public static <K, V> boolean contains(K[] array, V element) {
        if (array == null) {
            return false;
        }
        K[] KArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            K candidate = KArray[n2];
            if (ObjectUtil.equals(candidate, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <K> K get(K[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    public static Boolean[] convertToWrapper(boolean[] array) {
        int nArray = ArrayUtil.size(array);
        Boolean[] ret = new Boolean[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static Byte[] convertToWrapper(byte[] array) {
        int nArray = ArrayUtil.size(array);
        Byte[] ret = new Byte[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static Character[] convertToWrapper(char[] array) {
        int nArray = ArrayUtil.size(array);
        Character[] ret = new Character[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = Character.valueOf(array[i]);
            ++i;
        }
        return ret;
    }

    public static Short[] convertToWrapper(short[] array) {
        int nArray = ArrayUtil.size(array);
        Short[] ret = new Short[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static Integer[] convertToWrapper(int[] array) {
        int nArray = ArrayUtil.size(array);
        Integer[] ret = new Integer[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static Long[] convertToWrapper(long[] array) {
        int nArray = ArrayUtil.size(array);
        Long[] ret = new Long[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static Float[] convertToWrapper(float[] array) {
        int nArray = ArrayUtil.size(array);
        Float[] ret = new Float[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = Float.valueOf(array[i]);
            ++i;
        }
        return ret;
    }

    public static Double[] convertToWrapper(double[] array) {
        int nArray = ArrayUtil.size(array);
        Double[] ret = new Double[nArray];
        int i = 0;
        while (i < nArray) {
            ret[i] = array[i];
            ++i;
        }
        return ret;
    }

    public static <T> T[] safe(T[] unsafe) {
        return (Object[])ObjectUtil.nvl(unsafe, EMPTY_OBJECT_ARRAY);
    }

    public static Object[] subarray(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static class ArrayIterator<K>
    implements Iterator<K> {
        protected final K[] objs;
        protected final K[] origin;
        protected int index = 0;

        public ArrayIterator(K[] objs) {
            this.origin = objs;
            this.objs = this.origin == null ? null : (Object[])this.origin.clone();
        }

        @Override
        public boolean hasNext() {
            if (this.objs == null) {
                return false;
            }
            return this.index < this.objs.length;
        }

        @Override
        public K next() {
            if (this.objs == null) {
                throw new NoSuchElementException();
            }
            if (this.objs.length <= this.index) {
                throw new NoSuchElementException();
            }
            if (this.objs[this.index] != this.origin[this.index]) {
                throw new ConcurrentModificationException();
            }
            return this.objs[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

