/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SyncException;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryInputStream;
import org.tizen.sdblib.service.FileEntryOutputStream;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.service.NullSyncProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.FileEntryUtil;
import org.tizen.sdblib.util.FilenameUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ObjectUtil;
import org.tizen.sdblib.util.Preferences;

public class SyncService
implements Closeable {
    protected final Device device;

    public SyncService(SmartDevelopmentBridge sdb, Device device) {
        Assert.notNull(device);
        this.device = device;
    }

    @Override
    public void close() {
    }

    public SyncResult pull(FileEntry entry, String localPath) {
        return this.pull(new FileEntry[]{entry}, localPath);
    }

    public SyncResult pull(FileEntry[] entries, String localPath) {
        return this.pull(entries, localPath, null);
    }

    public SyncResult pull(FileEntry[] entries, String localPath, ISyncProgressMonitor monitor) {
        return this.pull(entries, localPath, monitor, Preferences.getTimeOut());
    }

    public SyncResult pull(FileEntry[] entries, String destination, ISyncProgressMonitor monitor, int timeOut) {
        SyncResult result;
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        File f = new File(destination);
        if (!f.exists()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_NO_DIR_TARGET);
        }
        if (!f.isDirectory()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_TARGET_IS_FILE);
        }
        monitor.start(-1L);
        monitor.startSubTask("File size checking: it can take some time.");
        try {
            long total = FileEntryUtil.getTotalSize(entries, monitor);
            if (total == -1L) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_FAIL_GET_FOLDER_SIZE);
                return syncResult;
            }
            try {
                monitor.startSubTask("Pulling file(s) from the device");
                monitor.stop();
                monitor.start(total);
                result = this.doPull(entries, destination, monitor, timeOut);
            }
            catch (InterruptedException interruptedException) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                return syncResult;
            }
        }
        finally {
            monitor.stop();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncResult doPull(FileEntry[] entries, String destination, ISyncProgressMonitor monitor, int timeOut) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        try {
            FileEntry[] fileEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (true) {
                FileEntry[] children;
                if (n2 >= n) {
                    return new SyncResult();
                }
                FileEntry entry = fileEntryArray[n2];
                String path = FilenameUtil.addTailingPath(destination, entry.getName());
                if (entry.isRoot()) {
                    children = entry.getChildren();
                    this.doPull(children, destination, monitor, timeOut);
                } else if (entry.isDirectory()) {
                    if (!new File(path).mkdir()) {
                        Log.e("sync", "directory creation failed");
                    }
                    children = entry.getChildren();
                    this.doPull(children, path, monitor, timeOut);
                } else {
                    FileOutputStream fileOut;
                    block12: {
                        SyncResult syncResult;
                        if (entry.getType().isDevice() || entry.getType().isFIFO()) {
                            return new SyncResult();
                        }
                        monitor.startSubTask(String.format("%s\t%s", entry.getFullPath(), path));
                        fileOut = null;
                        try {
                            fileOut = new FileOutputStream(path);
                            SyncResult result = this.doPull(entry, fileOut, monitor, timeOut);
                            if (result.isOk()) break block12;
                            syncResult = result;
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose(fileOut);
                            throw throwable;
                        }
                        IOUtil.tryClose(fileOut);
                        return syncResult;
                    }
                    IOUtil.tryClose(fileOut);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            return new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
        }
    }

    public SyncResult doPull(FileEntry remote, OutputStream out, ISyncProgressMonitor monitor, int timeOut) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        FileEntryInputStream in = null;
        try {
            in = new FileEntryInputStream(remote, timeOut);
            byte[] data = new byte[1000];
            int nBytes = 0;
            while ((nBytes = in.read(data)) > 0) {
                if (monitor.isCanceled()) {
                    SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                    return syncResult;
                }
                out.write(data, 0, nBytes);
                monitor.advance(nBytes);
            }
            SyncResult syncResult = new SyncResult();
            return syncResult;
        }
        catch (SyncException e) {
            SyncResult syncResult = new SyncResult(e.getCode());
            return syncResult;
        }
        catch (FileNotFoundException e) {
            SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_FILE_WRITE_ERROR, (Exception)e);
            return syncResult;
        }
        catch (IOException e) {
            SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
            return syncResult;
        }
        finally {
            IOUtil.tryClose(out);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (SyncException e) {
                return new SyncResult(e.getCode());
            }
            catch (IOException e) {
                return new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
            }
        }
    }

    public SyncResult push(String local, FileEntry entry) {
        return this.push(new String[]{local}, entry);
    }

    public SyncResult push(String[] locals, FileEntry entry) {
        return this.push(locals, entry, null);
    }

    public SyncResult push(String[] locals, FileEntry entry, ISyncProgressMonitor monitor) {
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = locals;
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (!file.exists()) {
                return new SyncResult(SyncServiceReturnCode.RESULT_NO_LOCAL_FILE);
            }
            files.add(file);
            ++n2;
        }
        return this.push(files.toArray(new File[files.size()]), entry, monitor, Preferences.getTimeOut());
    }

    public SyncResult push(File[] locals, FileEntry remote, ISyncProgressMonitor monitor, int timeOut) {
        SyncResult result;
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        if (!remote.isDirectory() && FileEntryType.Unknown != remote.getType()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_REMOTE_IS_FILE);
        }
        monitor.start(-1L);
        monitor.startSubTask("File size checking: it can take some time.");
        try {
            try {
                long total = SyncService.getTotalLocalFileSizeLong(locals, monitor);
                monitor.startSubTask("Pushing file(s) to the device");
                monitor.stop();
                monitor.start(total);
                result = this.doPush(locals, remote, monitor, timeOut);
            }
            catch (InterruptedException interruptedException) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                monitor.stop();
                return syncResult;
            }
        }
        finally {
            monitor.stop();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncResult doPush(File[] locals, FileEntry remote, ISyncProgressMonitor monitor, int timeOut) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        monitor.printLog("Your data is to be sent over an unencrypted connection and could be read by others.");
        try {
            String remotePath = remote.getFullPath();
            File[] fileArray = locals;
            int n = locals.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return new SyncResult();
                }
                File f = fileArray[n2];
                if (monitor.isCanceled()) {
                    return new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                }
                if (f.exists()) {
                    String path = FilenameUtil.addTailingPath(remotePath, f.getName());
                    FileEntry remoteFile = f.getName().contains("'") ? this.device.getSimpleFileEntry(path) : this.device.getFileEntry(path);
                    monitor.startSubTask(String.format("%s\t%s", f.getAbsolutePath(), path));
                    if (f.isDirectory()) {
                        SyncResult result = this.doPush(f.listFiles(), remoteFile, monitor, timeOut);
                        if (!result.isOk()) {
                            return result;
                        }
                    } else if (f.isFile()) {
                        FileInputStream fileIn = new FileInputStream(f);
                        try {
                            SyncResult result = this.doPush(fileIn, remoteFile, monitor, timeOut, false);
                            if (!result.isOk()) {
                                SyncResult syncResult = result;
                                return syncResult;
                            }
                        }
                        finally {
                            IOUtil.tryClose(fileIn);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            return new SyncResult(SyncServiceReturnCode.RESULT_FILE_READ_ERROR, (Exception)e);
        }
    }

    private SyncResult doPush(InputStream in, FileEntry remote, ISyncProgressMonitor monitor, int timeOut, boolean bPrintSecureWarnMsg) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        if (bPrintSecureWarnMsg) {
            monitor.printLog("Your data is to be sent over an unencrypted connection and could be read by others.");
        }
        long startTime = System.currentTimeMillis();
        Log.d("sync", "start at " + startTime + " ms");
        FileEntryOutputStream out = null;
        int nBytes = 0;
        byte[] buffer = new byte[4096];
        long size = 0L;
        try {
            out = new FileEntryOutputStream(remote, timeOut);
            while ((nBytes = in.read(buffer)) > 0) {
                if (monitor.isCanceled()) {
                    SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                    return syncResult;
                }
                out.write(buffer, 0, nBytes);
                size += (long)nBytes;
                monitor.advance(nBytes);
            }
            SyncResult syncResult = new SyncResult();
            return syncResult;
        }
        catch (SyncException e) {
            SyncResult syncResult = new SyncResult(e.getCode(), (Exception)e);
            return syncResult;
        }
        catch (IOException e) {
            SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
            return syncResult;
        }
        finally {
            IOUtil.tryClose(in);
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (SyncException e) {
                return new SyncResult(e.getCode());
            }
            catch (IOException e) {
                return new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
            }
            Log.d("sync", "Push " + size + " bytes in " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    protected static long getTotalLocalFileSizeLong(File[] files, ISyncProgressMonitor monitor) throws InterruptedException {
        long count = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new InterruptedException("The long running operation was cancelled");
            }
            if (f.exists()) {
                if (f.isDirectory()) {
                    count += SyncService.getTotalLocalFileSizeLong(f.listFiles(), monitor);
                } else if (f.isFile()) {
                    count += f.length();
                }
            }
            ++n2;
        }
        return count;
    }

    public SyncResult doPush(InputStream in, FileEntry remote, ISyncProgressMonitor monitor, int timeOut) {
        return this.doPush(in, remote, monitor, timeOut, true);
    }

    public SyncResult delete(String filePath) {
        String command = String.format("rm -f %s", FileEntry.getStringWithDoubleQuote(filePath));
        String cmd = "";
        cmd = this.device.isSecureProtocol() ? "0 rmfile " + FileEntry.getStringWithDoubleQuote(filePath) : command;
        try {
            this.device.executeShellCommand(cmd);
            return new SyncResult();
        }
        catch (IOException e) {
            Log.e("failed to delete file", e);
            return new SyncResult(SyncServiceReturnCode.RESULT_FAIL_DELETE_FILE);
        }
    }
}

