/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.tizen.sdblib.util.ArrayUtil;
import org.tizen.sdblib.util.Assert;

public class MapUtil {
    protected MapUtil() {
    }

    public static int length(Map<?, ?> map) {
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtil.length(map) == 0;
    }

    public static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (keys == null || values == null) {
            return map;
        }
        int i = 0;
        int n = Math.min(keys.length, values.length);
        while (i < n) {
            map.put(keys[i], values[i]);
            ++i;
        }
        return map;
    }

    public static <A, B> Map<A, B> asMap(Object[][] objs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        int n = ArrayUtil.size(objs);
        while (i < n) {
            if (2 == objs[i].length) {
                map.put(objs[i][0], objs[i][1]);
            }
            ++i;
        }
        return map;
    }

    public static void mergePropertiesIntoMap(Properties props, Map<Object, Object> map) {
        Assert.notNull(map);
        if (props == null) {
            return;
        }
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            map.put(key, props.getProperty(key));
        }
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return "<<null>>";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        if (!map.isEmpty()) {
            buffer.append("\n");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                buffer.append("\t");
                buffer.append(entry.getKey().toString());
                buffer.append("=");
                buffer.append(map.get(entry.getKey()));
                buffer.append("\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }
}

