/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileAppType;
import org.tizen.common.core.application.ProfileAppTypeInfo;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.ProfileVersionInfo;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKUtils;

public final class InstallProfileConfig {
    private static final Logger logger = LoggerFactory.getLogger(InstallPathConfig.class);
    private static List<ProfileInfo> supportAllProfiles = new ArrayList<ProfileInfo>();
    private static Map<String, ProfileInfo> supportAllProfileMap = new HashMap<String, ProfileInfo>();
    private static List<ProfileInfo> installedAllProfiles = new ArrayList<ProfileInfo>();
    private static Map<String, ProfileInfo> installedAllProfileMap = new HashMap<String, ProfileInfo>();
    private static Map<String, List<ProfileInfo>> installedAllProfileToAppTypeMap = new HashMap<String, List<ProfileInfo>>();
    private static List<ProfileInfo> flattenSupportAllProfiles = new ArrayList<ProfileInfo>();
    private static List<ProfileInfo> flattenInstalledAllProfiles = new ArrayList<ProfileInfo>();
    private static Map<String, List<ProfileInfo>> flattenInstalledProfileInfoToAppTypeMap = new HashMap<String, List<ProfileInfo>>();

    public static List<ProfileInfo> getAllSupportedPlatforms() {
        try {
            if (supportAllProfiles == null || supportAllProfiles.isEmpty()) {
                flattenSupportAllProfiles = InstallProfileConfig.getAllPlatformInfoToSDKUtils();
                if (flattenSupportAllProfiles == null || flattenSupportAllProfiles.isEmpty()) {
                    flattenSupportAllProfiles = InstallProfileConfig.getInstalledPlatformToLocalDirectory();
                }
                for (ProfileInfo profileInfo : flattenSupportAllProfiles) {
                    String profile = profileInfo.getProfile();
                    ProfileInfo tempInfo = supportAllProfileMap.get(profile);
                    if (profileInfo.isInstalledProfile()) {
                        flattenInstalledAllProfiles.add(profileInfo);
                    }
                    for (String version : profileInfo.getVersionInfos()) {
                        String path = profileInfo.getPlatformPath(version);
                        if (tempInfo != null) {
                            tempInfo.appendVersion(version, path);
                        } else {
                            tempInfo = new ProfileInfo(profile, version, path);
                        }
                        tempInfo.setDescription(profileInfo.getDescription());
                        tempInfo.appendVersionInfo(version, profileInfo.getVersionInfo(version));
                    }
                    supportAllProfileMap.put(profile, tempInfo);
                }
                supportAllProfiles = new ArrayList<ProfileInfo>(supportAllProfileMap.values());
            }
        }
        catch (Throwable e) {
            logger.error("Failed to load the supported platform list", e);
        }
        return supportAllProfiles;
    }

    public static List<ProfileInfo> getAllInstalledPlatforms() {
        try {
            if (installedAllProfiles == null || installedAllProfiles.isEmpty()) {
                if (flattenInstalledAllProfiles == null || flattenInstalledAllProfiles.isEmpty()) {
                    return installedAllProfiles;
                }
                for (ProfileInfo profileInfo : flattenInstalledAllProfiles) {
                    String profile = profileInfo.getProfile();
                    ProfileInfo tempInfo = installedAllProfileMap.get(profile);
                    for (String version : profileInfo.getVersionInfos()) {
                        String path = profileInfo.getPlatformPath(version);
                        if (tempInfo != null) {
                            tempInfo.appendVersion(version, path);
                        } else {
                            tempInfo = new ProfileInfo(profile, version, path);
                        }
                        tempInfo.setDescription(profileInfo.getDescription());
                        tempInfo.appendVersionInfo(version, profileInfo.getVersionInfo(version));
                    }
                    installedAllProfileMap.put(profile, tempInfo);
                }
                installedAllProfiles = new ArrayList<ProfileInfo>(installedAllProfileMap.values());
            }
        }
        catch (Throwable e) {
            logger.error("Failed to load the installed profile list from the SDK Manager", e);
        }
        return installedAllProfiles;
    }

    public static List<ProfileInfo> flattenInstalledProfileInfoToAppType(String appType) {
        List<ProfileInfo> profileInfosList = flattenInstalledProfileInfoToAppTypeMap.get(appType);
        if (profileInfosList != null && !profileInfosList.isEmpty()) {
            return profileInfosList;
        }
        if (supportAllProfiles.isEmpty()) {
            InstallProfileConfig.getAllSupportedPlatforms();
        }
        ArrayList<ProfileInfo> appTypeProfileList = new ArrayList<ProfileInfo>();
        if (flattenSupportAllProfiles.isEmpty()) {
            logger.error("Failed to load the supported profile list");
            return appTypeProfileList;
        }
        for (ProfileInfo profileInfo : flattenSupportAllProfiles) {
            String profile = profileInfo.getProfile();
            for (String version : profileInfo.getVersions()) {
                String versionPpath = profileInfo.getPlatformPath(version);
                ProfileVersionInfo profileVersionInfo = profileInfo.getVersionInfo(version);
                if (!profileVersionInfo.isSupportIDE(appType)) continue;
                ProfileInfo info = new ProfileInfo(profile, version, versionPpath);
                info.appendVersionInfo(version, profileVersionInfo);
                appTypeProfileList.add(info);
            }
        }
        flattenInstalledProfileInfoToAppTypeMap.put(appType, appTypeProfileList);
        return appTypeProfileList;
    }

    public static List<ProfileInfo> getInstalledProfileInfoToAppType(String ideType) {
        List<ProfileInfo> profileInfosList = installedAllProfileToAppTypeMap.get(ideType);
        if (profileInfosList != null && !profileInfosList.isEmpty()) {
            return profileInfosList;
        }
        ArrayList<ProfileInfo> ideTypeProfileList = new ArrayList<ProfileInfo>();
        List<ProfileInfo> flattenProfileInfosList = InstallProfileConfig.flattenInstalledProfileInfoToAppType(ideType);
        if (flattenProfileInfosList == null || flattenProfileInfosList.isEmpty()) {
            logger.error("Failed to load the supported profile list");
            return ideTypeProfileList;
        }
        HashMap<String, ProfileInfo> profileInfoMap = new HashMap<String, ProfileInfo>();
        for (ProfileInfo profileInfo : flattenProfileInfosList) {
            String profile = profileInfo.getProfile();
            for (String version : profileInfo.getVersions()) {
                ProfileInfo tempInfo = (ProfileInfo)profileInfoMap.get(profileInfo.getProfile());
                String verstionPath = profileInfo.getPlatformPath(version);
                ProfileVersionInfo profileVersionInfo = profileInfo.getVersionInfoMap().get(version);
                if (tempInfo == null) {
                    tempInfo = new ProfileInfo(profile, version, verstionPath);
                    tempInfo.appendVersionInfo(version, profileVersionInfo);
                } else {
                    tempInfo.appendVersion(version, profileInfo.getVersionsMap().get(version));
                    tempInfo.appendVersionInfo(version, profileInfo.getVersionInfoMap().get(version));
                }
                profileInfoMap.put(tempInfo.getProfile(), tempInfo);
            }
        }
        profileInfosList = new ArrayList(profileInfoMap.values());
        installedAllProfileToAppTypeMap.put(ideType, profileInfosList);
        return profileInfosList;
    }

    public static ProfileInfo getInstalledProfileInfo(String profile) {
        if (profile == null) {
            return null;
        }
        if (installedAllProfiles.isEmpty()) {
            InstallProfileConfig.getAllInstalledPlatforms();
        }
        for (ProfileInfo profileInfo : installedAllProfiles) {
            if (!profile.toLowerCase().equals(profileInfo.getProfile())) continue;
            return profileInfo;
        }
        return null;
    }

    private static List<ProfileInfo> getAllPlatformInfoToSDKUtils() {
        ArrayList<ProfileInfo> supportAllProfileInfos = new ArrayList<ProfileInfo>();
        Map sdkMetaPkg = null;
        try {
            SDKUtils sdkUtils = SDKUtils.getInstance();
            sdkMetaPkg = sdkUtils.getPackages(null, null, null, ISDKPackage.SearchPackageType.META_PKG, false, true);
        }
        catch (Throwable e) {
            logger.error("Failed to load the supported profile list from the SDK Manager", e);
        }
        if (sdkMetaPkg != null) {
            for (Map.Entry entry : sdkMetaPkg.entrySet()) {
                ISDKPackage pkg = (ISDKPackage)entry.getValue();
                if (ISDKPackage.Type.WEB_IDE != pkg.getType() && ISDKPackage.Type.NATIVE_IDE != pkg.getType()) continue;
                ProfileInfo resultInfo = InstallProfileConfig.getProfileInfoToPackageInfo(pkg);
                supportAllProfileInfos.add(resultInfo);
            }
        }
        return supportAllProfileInfos;
    }

    private static ProfileInfo getProfileInfoToPackageInfo(ISDKPackage pkg) {
        String profile = null;
        profile = pkg.isExtension() ? pkg.getExtension().toString() : pkg.getProfile().name().toLowerCase();
        String version = pkg.getPlatformVersion().toString();
        String versionPath = pkg.getPlatformPath();
        boolean isInstalled = pkg.isInstalled();
        String appType = pkg.getType().name();
        ProfileAppType type = ProfileAppType.getAppTypeToStateName(appType);
        ProfileAppTypeInfo appTypeInfo = new ProfileAppTypeInfo(type, isInstalled);
        ProfileVersionInfo versionInfo = new ProfileVersionInfo(version, versionPath, appTypeInfo);
        ProfileInfo profileInfo = new ProfileInfo(profile, version, versionPath, versionInfo);
        return profileInfo;
    }

    public static ProfileInfo getProfileInfoToProfile(String profileName) {
        ProfileInfo resultProfileInfo = null;
        if (supportAllProfileMap == null || supportAllProfileMap.size() < 1) {
            InstallProfileConfig.getAllSupportedPlatforms();
        }
        resultProfileInfo = supportAllProfileMap.get(profileName);
        return resultProfileInfo;
    }

    public static Set<String> getSupportedProfiles() {
        return supportAllProfileMap.keySet();
    }

    private static List<ProfileInfo> getInstalledPlatformToLocalDirectory() {
        ArrayList<ProfileInfo> supportAllProfileInfos = new ArrayList<ProfileInfo>();
        List<ProfileInfo> installProfileInfos = InstallPathConfig.flattenPlatformPathInfos();
        for (ProfileInfo installProfile : installProfileInfos) {
            for (String version : installProfile.getVersionInfos()) {
                ProfileVersionInfo versionInfo = installProfile.getVersionInfo(version);
                boolean isWeb = false;
                boolean isNative = false;
                for (ProfileAppTypeInfo langInfo : versionInfo.getAppTypeInfoList()) {
                    if (langInfo.getProfileAppType() == ProfileAppType.NATIVE) {
                        isNative = true;
                    }
                    if (langInfo.getProfileAppType() == ProfileAppType.WEB) {
                        isWeb = true;
                    }
                    langInfo.setInstalled(true);
                }
                if (!isWeb) {
                    ProfileAppTypeInfo webLangInfo = new ProfileAppTypeInfo(ProfileAppType.WEB.name());
                    versionInfo.setAppTypeInfo(webLangInfo);
                }
                if (isNative) continue;
                ProfileAppTypeInfo nativeLangInfo = new ProfileAppTypeInfo(ProfileAppType.NATIVE.name());
                versionInfo.setAppTypeInfo(nativeLangInfo);
            }
        }
        supportAllProfileInfos.addAll(installProfileInfos);
        return supportAllProfileInfos;
    }

    public static boolean isSupportProfileToAppType(String profileName, String version, String appType) {
        List<ProfileInfo> profileInfosList = InstallProfileConfig.flattenInstalledProfileInfoToAppType(appType);
        if (profileInfosList == null || profileInfosList.size() < 1) {
            logger.warn("The Platforms are not Installed");
            return false;
        }
        for (ProfileInfo profileInfo : profileInfosList) {
            String profile = profileInfo.getProfile();
            if (!profile.equalsIgnoreCase(profileName) || !profileInfo.isSupportPlatformVersion(version)) continue;
            return true;
        }
        return false;
    }
}

