/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.dialog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.common.util.StringUtil;

public class LocaleDialog
extends SelectionStatusDialog {
    protected static String DEFAULT_LANG = "en-gb";
    public static final String[] WRT_LANG_LISTS = new String[]{"ar-ae", "as-in", "az-az", "be-by", "bg-bg", "bn-bd", "bn-in", "ca-es", "cs-cz", "da-dk", "de-at", "de-ch", "de-de", "el-gr", "en-au", "en-ca", "en-gb", "en-ie", "en-nz", "en-ph", "en-us", "en-za", "es-es", "es-mx", "es-us", "et-ee", "eu-es", "fa-ir", "fi-fi", "fr-be", "fr-ca", "fr-ch", "fr-fr", "ga-ie", "gl-es", "gu-in", "he-il", "hi-in", "hr-hr", "hu-hu", "hy-am", "id-id", "is-is", "it-it", "ja-jp", "jv-id", "ka-ge", "kk-kz", "km-kh", "kn-ca", "kn-in", "ko-kr", "ky-kg", "lo-la", "lt-lt", "lv-lv", "mk-mk", "ml-in", "ml-my", "mn-mn", "mr-in", "ms-mw", "my-mm", "nb-no", "ne-np", "nl-be", "nl-nl", "or-in", "pa-in", "pa-pk", "pl-pl", "pt-br", "pt-pt", "ro-ro", "ru-ru", "si-lk", "sk-sk", "sl-si", "sq-al", "sr-rs", "su-id", "sv-se", "ta-in", "te-in", "tg-tj", "th-th", "tk-tm", "tl-ph", "tr-tr", "uk-ua", "ur-pk", "uz-uz", "vi-vn", "xh-za", "zh-cn", "zh-hk", "zh-sg", "zh-tw", "zu-za"};
    protected List<String> CUSTOM_LANG_LISTS = new LinkedList<String>();
    protected Label contentLabel;
    protected String lang;
    protected String content;
    protected ComboViewer langComboViewer;
    protected Text contentText;
    protected Set<String> filter;
    private String title;

    public LocaleDialog(Shell parentShell, String title, HashMap<String, String> locales) {
        super(parentShell);
        this.setTitle(title);
        this.title = title;
        this.filter = new HashSet<String>();
        for (String lang : locales.keySet()) {
            this.filter.add(lang);
        }
    }

    public LocaleDialog(Shell parentShell, HashMap<String, String> locales) {
        this(parentShell, "Name", locales);
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.langComboViewer.getSelection();
        if (!selection.isEmpty()) {
            this.lang = (String)selection.getFirstElement();
        }
        this.content = this.contentText.getText().trim();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 420;
        composite.setLayoutData((Object)gd);
        LocaleDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Language:");
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        CCombo langCCombo = new CCombo(composite, 2056);
        langCCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        langCCombo.setVisibleItemCount(10);
        this.langComboViewer = new ComboViewer(langCCombo);
        this.langComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.langComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String lang = (String)element;
                if (lang.equalsIgnoreCase(DEFAULT_LANG)) {
                    return String.valueOf(DEFAULT_LANG) + " (default)";
                }
                return super.getText(element);
            }
        });
        String[] stringArray = WRT_LANG_LISTS;
        int n = WRT_LANG_LISTS.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            if (!this.filter.contains(lang)) {
                this.langComboViewer.add((Object)lang);
            }
            ++n2;
        }
        for (String lang : this.CUSTOM_LANG_LISTS) {
            if (this.filter.contains(lang)) continue;
            this.langComboViewer.add((Object)lang);
        }
        this.langComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LocaleDialog.this.validate();
            }
        });
        if (this.filter.contains(DEFAULT_LANG)) {
            if (this.langComboViewer.getCCombo().getItemCount() != 0) {
                this.langComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.langComboViewer.getCCombo().getItem(0)));
            }
        } else {
            this.langComboViewer.setSelection((ISelection)new StructuredSelection((Object)DEFAULT_LANG));
        }
        this.contentLabel = new Label(composite, 0);
        this.contentLabel.setText(StringUtil.isEmpty(this.title) ? "Name:" : String.valueOf(this.title) + ":");
        this.contentLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.contentText = new Text(composite, 2048);
        this.contentText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.contentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocaleDialog.this.validate();
            }
        });
        this.contentText.setFocus();
        if (!StringUtil.isEmpty(this.content)) {
            if (StringUtil.isEmpty(this.lang) && this.CUSTOM_LANG_LISTS.contains("")) {
                this.langComboViewer.add((Object)"");
                this.langComboViewer.setSelection((ISelection)new StructuredSelection((Object)""));
            } else {
                this.langComboViewer.add((Object)this.lang);
                this.langComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.lang));
            }
            this.contentText.setText(this.content);
        }
        this.setHelpAvailable(false);
        this.validate();
        return composite;
    }

    protected void validate() {
        if (this.contentText == null) {
            return;
        }
        Status status = null;
        status = this.contentText.getText().trim().length() == 0 ? new Status(4, "org.tizen.common", "Enter a " + this.title.toLowerCase()) : new Status(0, "org.tizen.common", null);
        this.updateStatus((IStatus)status);
    }

    public void editLang(String lang, String content) {
        this.lang = lang;
        this.content = content;
    }

    public String getLang() {
        if (StringUtil.isEmpty(this.lang)) {
            return null;
        }
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getCustomLangList() {
        return this.CUSTOM_LANG_LISTS;
    }

    public void setCustomLang(String lang) {
        this.CUSTOM_LANG_LISTS.add(lang);
    }

    public void setDefaultLang(String lang) {
        DEFAULT_LANG = lang;
    }

    public String getDefaultLang() {
        return DEFAULT_LANG;
    }

    public static int getDefaultLangLength() {
        return WRT_LANG_LISTS.length;
    }
}

