/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.ThreadFindReachable;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.util.IOUtil;

public class RemoteDeviceManagerDialog
extends Dialog {
    private static final String PORT = "26101";
    private static final Logger logger = LoggerFactory.getLogger((String)"RemoteDeviceManagerDialog.class");
    private Table table;
    private static final String sdbConnectCommand = String.valueOf(InstallPathConfig.getSDBPath()) + " connect ";
    private static final String sdbDisconnectCommand = String.valueOf(InstallPathConfig.getSDBPath()) + " disconnect ";
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String PORT_PATTERN = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    public static final String REMOTE_DEVICE_LIST_FILE = String.valueOf(InstallPathConfig.getUserDataPath()) + File.separator + "ide" + File.separator + "remote_device.list";
    private static final String[] newImages = new String[]{"icons/connection/remote/btn_add_nor.png", "icons/connection/remote/btn_add_over.png", "icons/connection/remote/btn_add_sel.png", "icons/connection/remote/btn_add_dim.png"};
    private static final String[] editImages = new String[]{"icons/connection/remote/btn_edit_nor.png", "icons/connection/remote/btn_edit_over.png", "icons/connection/remote/btn_edit_sel.png", "icons/connection/remote/btn_edit_dim.png"};
    private static final String[] deleteImages = new String[]{"icons/connection/remote/btn_delete_nor.png", "icons/connection/remote/btn_delete_over.png", "icons/connection/remote/btn_delete_sel.png", "icons/connection/remote/btn_delete_dim.png"};
    private static final String[] scanImages = new String[]{"icons/connection/remote/btn_scan_nor.png", "icons/connection/remote/btn_scan_over.png", "icons/connection/remote/btn_scan_sel.png", "icons/connection/remote/btn_scan_dim.png"};
    private ImageButton newButton;
    private ImageButton editButton;
    private ImageButton deleteButton;
    private ImageButton scanButton;
    private Button connectButton;
    private Button disconnectButton;
    private Button closeButton;

    public RemoteDeviceManagerDialog(Shell parentShell) {
        super(parentShell);
    }

    public static String makeRemoteDeviceInfo(String name, String ip, String port) {
        return String.valueOf(name) + "/" + ip + "/" + port;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectionUIMessages.Remote_Device_Manager_Name);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        RemoteDeviceManagerDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        this.loadDeviceUnits(composite);
        return composite;
    }

    private void loadDeviceUnits(Composite parent) {
        block6: {
            BufferedWriter out = null;
            try {
                try {
                    TableItem[] tableItems;
                    out = new BufferedWriter(new FileWriter(REMOTE_DEVICE_LIST_FILE));
                    TableItem[] tableItemArray = tableItems = this.table.getItems();
                    int n = tableItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        String name = tableItem.getText(0);
                        String ip = tableItem.getText(1);
                        String port = tableItem.getText(2);
                        String remoteDeviceInfo = RemoteDeviceManagerDialog.makeRemoteDeviceInfo(name, ip, port);
                        out.write(remoteDeviceInfo);
                        out.newLine();
                        ++n2;
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    IOUtil.tryClose((Closeable)out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(out);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)out);
        }
        this.scanDevice();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTop(composite);
        this.createTable(composite);
        return parent;
    }

    private void createTop(final Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(4, false);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 3;
        container.setLayoutData((Object)gd);
        compLayout.marginTop = 20;
        compLayout.marginLeft = 20;
        compLayout.marginRight = 20;
        compLayout.marginBottom = 0;
        compLayout.horizontalSpacing = 12;
        container.setLayout((Layout)compLayout);
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        final Image newNorImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(newImages[0]).getImageData());
        final Image newOverImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(newImages[1]).getImageData());
        final Image newSelectImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(newImages[2]).getImageData());
        final Image newDimImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(newImages[3]).getImageData());
        this.newButton = new ImageButton(container, newNorImage, newOverImage, newSelectImage, newDimImage);
        this.newButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                NewDeviceDialog dialog = new NewDeviceDialog(parent.getShell());
                dialog.open();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RemoteDeviceManagerDialog.this.imageDispose(new Image[]{newNorImage, newOverImage, newSelectImage, newDimImage});
            }
        });
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        final Image editNorImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(editImages[0]).getImageData());
        final Image editOverImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(editImages[1]).getImageData());
        final Image editSelectImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(editImages[2]).getImageData());
        final Image editDimImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(editImages[3]).getImageData());
        this.editButton = new ImageButton(container, editNorImage, editOverImage, editSelectImage, editDimImage);
        this.editButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                if (RemoteDeviceManagerDialog.this.table.getSelectionCount() != 0) {
                    EditDeviceDialog dialog = new EditDeviceDialog(parent.getShell());
                    dialog.open();
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RemoteDeviceManagerDialog.this.imageDispose(new Image[]{editNorImage, editOverImage, editSelectImage, editDimImage});
            }
        });
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        final Image deleteNorImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(deleteImages[0]).getImageData());
        final Image deleteOverImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(deleteImages[1]).getImageData());
        final Image deleteSelectImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(deleteImages[2]).getImageData());
        final Image deleteDimImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(deleteImages[3]).getImageData());
        this.deleteButton = new ImageButton(container, deleteNorImage, deleteOverImage, deleteSelectImage, deleteDimImage);
        this.deleteButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                if (RemoteDeviceManagerDialog.this.table.getSelectionCount() != 0) {
                    RemoteDeviceManagerDialog.this.table.remove(RemoteDeviceManagerDialog.this.table.getSelectionIndex());
                    RemoteDeviceManagerDialog.this.enableButtons(false);
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RemoteDeviceManagerDialog.this.imageDispose(new Image[]{deleteNorImage, deleteOverImage, deleteSelectImage, deleteDimImage});
            }
        });
        gd = new GridData(18, 18);
        gd.horizontalAlignment = 3;
        final Image scanNorImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(scanImages[0]).getImageData());
        final Image scanOverImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(scanImages[1]).getImageData());
        final Image scanSelectImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(scanImages[2]).getImageData());
        final Image scanDimImage = new Image((Device)container.getDisplay(), ConnectionPlugin.getImageDescriptorFromPlugin(scanImages[3]).getImageData());
        this.scanButton = new ImageButton(container, scanNorImage, scanOverImage, scanSelectImage, scanDimImage);
        this.scanButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                RemoteDeviceManagerDialog.this.scanDevice();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.scanButton.setLayoutData((Object)gd);
        this.scanButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RemoteDeviceManagerDialog.this.imageDispose(new Image[]{scanNorImage, scanOverImage, scanSelectImage, scanDimImage});
            }
        });
    }

    private void imageDispose(Image ... arguments) {
        int i = 0;
        while (i < arguments.length) {
            ImageUtil.tryDispose((Image)arguments[i]);
            ++i;
        }
    }

    private void createTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 410;
        GridLayout compLayout = new GridLayout();
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)compLayout);
        compLayout.marginLeft = 20;
        compLayout.marginRight = 20;
        compLayout.marginBottom = 20;
        compLayout.marginTop = 0;
        this.table = new Table(container, 67844);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDeviceManagerDialog.this.enableButtons(true);
            }
        });
        gridData = new GridData(1808);
        gridData.heightHint = 198;
        gridData.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gridData);
        RemoteDeviceManagerDialog.createTableColumn(this.table, ConnectionUIMessages.Remote_Device_Manager_Table_Header_Col1, 16384, 130);
        RemoteDeviceManagerDialog.createTableColumn(this.table, ConnectionUIMessages.Remote_Device_Manager_Table_Header_Col2, 16384, 130);
        RemoteDeviceManagerDialog.createTableColumn(this.table, ConnectionUIMessages.Remote_Device_Manager_Table_Header_Col3, 16384, 80);
        this.readRemoteDeviceList();
    }

    private void readRemoteDeviceList() {
        block10: {
            File file;
            BufferedReader br;
            FileReader fr;
            block9: {
                fr = null;
                br = null;
                file = new File(REMOTE_DEVICE_LIST_FILE);
                if (file.isFile()) break block9;
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
                return;
            }
            try {
                fr = new FileReader(file);
                br = new BufferedReader(fr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] deviceInfo = this.getRemoteDeviceInfoFromLine(line);
                    if (deviceInfo == null || deviceInfo.length != 3) continue;
                    this.addRemoteDeviceToTable(deviceInfo[0], deviceInfo[1], deviceInfo[2]);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Remote device file is not found", (Object)e.getMessage(), (Object)e);
                IOUtil.tryClose(fr);
                IOUtil.tryClose(br);
                break block10;
            }
            catch (IOException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.tryClose(fr);
                    IOUtil.tryClose(br);
                }
            }
            IOUtil.tryClose((Closeable)fr);
            IOUtil.tryClose((Closeable)br);
        }
    }

    private String[] getRemoteDeviceInfoFromLine(String line) {
        String[] deviceInfo = null;
        deviceInfo = line.split("/");
        return deviceInfo;
    }

    protected Control createButtonBar(final Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        compLayout.marginLeft = 20;
        compLayout.marginRight = 20;
        compLayout.marginBottom = 0;
        compLayout.marginTop = 0;
        gd.heightHint = 60;
        container.setLayoutData((Object)gd);
        container.setLayout((Layout)compLayout);
        gd = new GridData();
        gd.widthHint = 86;
        this.connectButton = new Button(container, 8);
        this.connectButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Connect);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TableItem[] deviceTableItem = RemoteDeviceManagerDialog.this.table.getSelection();
                        if (deviceTableItem[0] != null) {
                            String deviceIP = deviceTableItem[0].getText(1);
                            String devicePort = deviceTableItem[0].getText(2);
                            String sdbConnectDeviceCommand = String.valueOf(sdbConnectCommand) + deviceIP + ":" + devicePort;
                            HostUtil.execute((String)sdbConnectDeviceCommand);
                            String retStr = HostUtil.returnExecute((String)sdbConnectDeviceCommand);
                            if (retStr.startsWith("error:")) {
                                DialogUtil.openErrorDialog((String)retStr);
                            }
                        }
                    }
                });
            }
        });
        this.connectButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 86;
        this.disconnectButton = new Button(container, 8);
        this.disconnectButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Disconnect);
        this.disconnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] deviceTableItem = RemoteDeviceManagerDialog.this.table.getSelection();
                if (deviceTableItem[0] != null) {
                    String deviceIP = deviceTableItem[0].getText(1);
                    String devicePort = deviceTableItem[0].getText(2);
                    String sdbDisconnectDeviceCommand = String.valueOf(sdbDisconnectCommand) + deviceIP + ":" + devicePort;
                    HostUtil.execute((String)sdbDisconnectDeviceCommand);
                }
            }
        });
        this.disconnectButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 86;
        gd.horizontalAlignment = 3;
        gd.grabExcessHorizontalSpace = true;
        this.closeButton = new Button(container, 8);
        this.closeButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Close);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.getShell().close();
            }
        });
        this.closeButton.setLayoutData((Object)gd);
        this.enableButtons(false);
        return container;
    }

    private void scanDevice() {
        ScanSpinner spinner = new ScanSpinner();
        RemoteScanWorker worker = new RemoteScanWorker(spinner);
        Thread threadWorker = new Thread((Runnable)worker, "Remote Scan Worker");
        Thread threadSpinner = new Thread((Runnable)spinner, "Remote Scan Spinner");
        threadWorker.start();
        threadSpinner.start();
    }

    private boolean isExistIP(String ip) {
        TableItem[] items;
        if (this.table.isDisposed()) {
            return false;
        }
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText(1).equals(ip)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<String> findReachableIPList(String hostIP) throws InterruptedException {
        ArrayList<String> reachableIPList = new ArrayList<String>();
        String[] tokens = hostIP.split(Pattern.quote("."));
        ThreadFindReachable[] threadFindReachable = new ThreadFindReachable[254];
        if (tokens.length != 4) {
            logger.debug("Failed to check reachable IP, cause it's invalid ip: " + hostIP);
            return reachableIPList;
        }
        int i = 1;
        while (i < 255) {
            threadFindReachable[i - 1] = new ThreadFindReachable(String.valueOf(tokens[0]) + "." + tokens[1] + "." + tokens[2] + "." + i);
            threadFindReachable[i - 1].start();
            ++i;
        }
        i = 1;
        while (i < 255) {
            threadFindReachable[i - 1].join();
            if (threadFindReachable[i - 1].isReachable) {
                reachableIPList.add(threadFindReachable[i - 1].ip);
            }
            ++i;
        }
        return reachableIPList;
    }

    private List<String> getHostAddressList() throws SocketException {
        ArrayList<String> addressList = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterface.isLoopback()) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                String hostAddress = inetAddress.getHostAddress();
                addressList.add(hostAddress);
                logger.debug("Add hostAddress: " + hostAddress + ", interface Name: " + networkInterface.getName());
            }
        }
        return addressList;
    }

    private void enableButtons(boolean isEnable) {
        this.editButton.setEnabled(isEnable);
        this.deleteButton.setEnabled(isEnable);
        this.connectButton.setEnabled(isEnable);
        this.disconnectButton.setEnabled(isEnable);
    }

    private static TableColumn createTableColumn(Table parent, String header, int style, int width) {
        TableColumn col = new TableColumn(parent, style);
        col.setWidth(width);
        col.setMoveable(true);
        col.setText(header);
        return col;
    }

    private void addRemoteDeviceToTable(String name, String ip, String port) {
        if (this.table.isDisposed()) {
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, name);
        item.setText(1, ip);
        item.setText(2, port);
    }

    private boolean isValidRemoteDevice(String name, String ip, String port) {
        if (!name.equals("")) {
            Pattern ipPattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher ipMatcher = ipPattern.matcher(ip);
            if (ipMatcher.find()) {
                Pattern portPattern = Pattern.compile(PORT_PATTERN);
                Matcher portMatcher = portPattern.matcher(port);
                if (portMatcher.find()) {
                    return true;
                }
                DialogUtil.openErrorDialog((String)("\"" + port + "\" " + ConnectionUIMessages.Remote_Message_InvalidPort));
            } else {
                DialogUtil.openErrorDialog((String)("\"" + ip + "\" " + ConnectionUIMessages.Remote_Message_InvalidIp));
            }
        } else {
            DialogUtil.openErrorDialog((String)ConnectionUIMessages.Remote_Message_EmptyName);
        }
        return false;
    }

    protected boolean isResizable() {
        return false;
    }

    class EditDeviceDialog
    extends org.eclipse.swt.widgets.Dialog {
        private Shell shell;
        private Text nameText;
        private Text ipText;
        private Text portText;
        private String name;
        private String ip;
        private String port;
        private TableItem selectedTableItem;

        public EditDeviceDialog(Shell parentShell) {
            super(parentShell);
            this.shell = parentShell;
            TableItem[] tableItems = RemoteDeviceManagerDialog.this.table.getSelection();
            this.selectedTableItem = tableItems[0];
            if (this.selectedTableItem != null) {
                this.name = this.selectedTableItem.getText(0);
                this.ip = this.selectedTableItem.getText(1);
                this.port = this.selectedTableItem.getText(2);
            }
        }

        public boolean open() {
            this.shell = new Shell(this.shell, 67680);
            this.createUI(this.shell);
            this.shell.pack();
            this.shell.open();
            Display display = this.shell.getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }

        private void createUI(final Shell shell) {
            shell.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Edit);
            shell.setLayout((Layout)new GridLayout(1, false));
            Group mid = new Group((Composite)shell, 4);
            mid.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Input);
            mid.setLayoutData((Object)new GridData(1808));
            mid.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Name);
            this.nameText = new Text((Composite)mid, 2052);
            this.nameText.setText(this.name);
            this.nameText.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_IP);
            this.ipText = new Text((Composite)mid, 2052);
            this.ipText.setText(this.ip);
            this.ipText.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Port);
            this.portText = new Text((Composite)mid, 2052);
            this.portText.setText(this.port);
            this.portText.setLayoutData((Object)new GridData(768));
            Composite bottomComp = new Composite((Composite)shell, 0);
            bottomComp.setLayoutData((Object)new GridData(64));
            bottomComp.setLayout((Layout)new GridLayout(2, true));
            Button okButton = new Button(bottomComp, 0);
            okButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Save);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = EditDeviceDialog.this.nameText.getText();
                    String ip = EditDeviceDialog.this.ipText.getText();
                    String port = EditDeviceDialog.this.portText.getText();
                    if (RemoteDeviceManagerDialog.this.isValidRemoteDevice(name, ip, port)) {
                        EditDeviceDialog.this.selectedTableItem.setText(new String[]{name, ip, port});
                        shell.close();
                    }
                }
            });
            Button cancelButton = new Button(bottomComp, 0);
            cancelButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Cancel);
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    shell.close();
                }
            });
        }
    }

    class NewDeviceDialog
    extends org.eclipse.swt.widgets.Dialog {
        private Shell shell;
        private Text nameText;
        private Text ipText;
        private Text portText;

        public NewDeviceDialog(Shell parentShell) {
            super(parentShell);
            this.shell = parentShell;
        }

        public boolean open() {
            this.shell = new Shell(this.shell, 67680);
            this.createUI(this.shell);
            this.shell.pack();
            this.shell.open();
            Display display = this.shell.getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }

        private void createUI(final Shell shell) {
            shell.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Add);
            shell.setLayout((Layout)new GridLayout(1, false));
            Group mid = new Group((Composite)shell, 4);
            mid.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Input);
            mid.setLayoutData((Object)new GridData(1808));
            mid.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Name);
            this.nameText = new Text((Composite)mid, 2052);
            this.nameText.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_IP);
            this.ipText = new Text((Composite)mid, 2052);
            this.ipText.setLayoutData((Object)new GridData(768));
            label = new Label((Composite)mid, 0);
            label.setText(ConnectionUIMessages.Remote_Device_Manager_Lbl_Port);
            this.portText = new Text((Composite)mid, 2052);
            this.portText.setText(RemoteDeviceManagerDialog.PORT);
            this.portText.setLayoutData((Object)new GridData(768));
            Composite bottomComp = new Composite((Composite)shell, 0);
            bottomComp.setLayoutData((Object)new GridData(64));
            bottomComp.setLayout((Layout)new GridLayout(2, true));
            Button okButton = new Button(bottomComp, 0);
            okButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Add);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = NewDeviceDialog.this.nameText.getText();
                    String ip = NewDeviceDialog.this.ipText.getText();
                    String port = NewDeviceDialog.this.portText.getText();
                    if (RemoteDeviceManagerDialog.this.isValidRemoteDevice(name, ip, port)) {
                        RemoteDeviceManagerDialog.this.addRemoteDeviceToTable(name, ip, port);
                        shell.close();
                    }
                }
            });
            Button cancelButton = new Button(bottomComp, 0);
            cancelButton.setText(ConnectionUIMessages.Remote_Device_Manager_Btn_Cancel);
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    shell.close();
                }
            });
        }
    }

    class RemoteScanWorker
    implements Runnable {
        private boolean finished = false;
        private ScanSpinner spinner;

        public RemoteScanWorker(ScanSpinner spinner) {
            this.spinner = spinner;
        }

        @Override
        public void run() {
            final HashMap<String, List> reachableIPList = new HashMap<String, List>();
            this.enableButton(false);
            while (!this.finished) {
                try {
                    try {
                        List ipList = RemoteDeviceManagerDialog.this.getHostAddressList();
                        for (String hostIP : ipList) {
                            reachableIPList.put(hostIP, RemoteDeviceManagerDialog.this.findReachableIPList(hostIP));
                        }
                        this.spinner.finish();
                        final Enumeration list = Collections.enumeration(reachableIPList.keySet());
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                while (list.hasMoreElements()) {
                                    List ipList = (List)reachableIPList.get(list.nextElement());
                                    for (String ip : ipList) {
                                        if (RemoteDeviceManagerDialog.this.isExistIP(ip)) continue;
                                        RemoteDeviceManagerDialog.this.addRemoteDeviceToTable(ConnectionUIMessages.Remote_Device_Manager_Table_Default_Item_Name, ip, RemoteDeviceManagerDialog.PORT);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!this.spinner.isFinished()) {
                            this.spinner.finish();
                        }
                        logger.error(ConnectionUIMessages.Remote_Message_ScanError, (Throwable)e);
                        this.finished = true;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.finished = true;
                    throw throwable;
                }
                this.finished = true;
            }
            this.enableButton(true);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void finish() {
            this.finished = true;
        }

        private void enableButton(final boolean enabled) {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!RemoteDeviceManagerDialog.this.scanButton.isDisposed()) {
                        RemoteDeviceManagerDialog.this.scanButton.setEnabled(enabled);
                        RemoteDeviceManagerDialog.this.newButton.setEnabled(enabled);
                        RemoteDeviceManagerDialog.this.editButton.setEnabled(false);
                        RemoteDeviceManagerDialog.this.deleteButton.setEnabled(false);
                    }
                }
            });
        }
    }

    class ScanSpinner
    implements Runnable {
        private boolean finished = false;
        private final ArrayList<ImageData> imageDataList = new ArrayList();
        private int progress = 0;
        private final int IMG_WIDTH = 90;

        private void init() {
            ImageLoader loader = new ImageLoader();
            Bundle bundle = Platform.getBundle((String)"org.tizen.common.connection");
            Path path = new Path("icons/connection/remote/loading_seq_l_3.gif");
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
            InputStream in = null;
            try {
                try {
                    in = fileURL.openStream();
                    loader.load(in);
                    ImageData[] imageDataArray = loader.data;
                    int n = loader.data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ImageData data = imageDataArray[n2];
                        if (data.width == 90) {
                            this.imageDataList.add(data);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to find loading image", (Throwable)e);
                    IOUtil.tryClose((Closeable)in);
                }
            }
            finally {
                IOUtil.tryClose((Closeable)in);
            }
        }

        @Override
        public void run() {
            this.init();
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    RemoteDeviceManagerDialog.this.table.addPaintListener(new PaintListener(){

                        public void paintControl(PaintEvent event) {
                            Rectangle clientArea = RemoteDeviceManagerDialog.this.table.getClientArea();
                            int xMiddle = clientArea.width / 2;
                            int yMiddle = clientArea.height / 2;
                            int xImgMiddle = ((ImageData)((ScanSpinner)(this).ScanSpinner.this).imageDataList.get((int)0)).width / 2;
                            int yimgMiddle = ((ImageData)((ScanSpinner)(this).ScanSpinner.this).imageDataList.get((int)0)).height / 2;
                            if (ScanSpinner.this.progress >= ScanSpinner.this.imageDataList.size()) {
                                ScanSpinner.this.progress = 0;
                            }
                            if (ScanSpinner.this.finished) {
                                return;
                            }
                            ImageData imageData = (ImageData)ScanSpinner.this.imageDataList.get(ScanSpinner.this.progress);
                            Image image = new Image((Device)event.display, imageData);
                            event.gc.drawImage(image, xMiddle - xImgMiddle, yMiddle - yimgMiddle);
                            RemoteDeviceManagerDialog.this.table.redraw();
                            try {
                                Thread.sleep(imageData.delayTime * 5);
                            }
                            catch (InterruptedException e) {
                                logger.error("Failed to scanning: " + e.getMessage(), (Throwable)e);
                            }
                            image.dispose();
                            ScanSpinner scanSpinner = ScanSpinner.this;
                            scanSpinner.progress = scanSpinner.progress + 1;
                        }
                    });
                    RemoteDeviceManagerDialog.this.table.redraw();
                }
            });
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void finish() {
            this.finished = true;
        }
    }
}

