/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.externals.navigatorContent;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PackageActionProvider
extends CommonActionProvider {
    Action openAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.openAction = new OpenAction(aSite.getStructuredViewer(), workbenchSite.getSelectionProvider());
        }
    }

    class OpenAction
    extends Action {
        private StructuredViewer viewer;
        private ISelectionProvider provider;

        public OpenAction(StructuredViewer viewer, ISelectionProvider selectionProvider) {
            this.viewer = viewer;
            this.provider = selectionProvider;
        }

        public boolean isEnabled() {
            ISelection selection = this.provider.getSelection();
            return !selection.isEmpty();
        }

        public void run() {
            ISelection selection = this.provider.getSelection();
            if (selection != null && selection instanceof IStructuredSelection) {
                this.expand(((IStructuredSelection)selection).getFirstElement());
            }
        }

        private void expand(Object target) {
            if (target != null && this.viewer instanceof TreeViewer) {
                TreeViewer treeViewer;
                treeViewer.setExpandedState(target, !(treeViewer = (TreeViewer)this.viewer).getExpandedState(target));
            }
        }
    }
}

