/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.gradientComposite;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class GradientComposite
extends Composite {
    private Image oldImage;
    private Color gradientEnd;
    private Color gradientStart;

    public GradientComposite(Composite parent, int style) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientComposite.this.redrawComposite();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.oldImage);
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.gradientEnd);
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.gradientStart);
            }
        });
        this.gradientEnd = new Color((Device)this.getDisplay(), 110, 110, 110);
        this.gradientStart = new Color((Device)this.getDisplay(), 0, 0, 0);
    }

    private void redrawComposite() {
        Display display = this.getDisplay();
        Rectangle rect = this.getClientArea();
        Image newImage = new Image((Device)display, Math.max(1, rect.width), Math.max(1, rect.height));
        GC gc = new GC((Drawable)newImage);
        gc.setForeground(this.gradientStart);
        gc.setBackground(this.gradientEnd);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height / 2, true);
        gc.setForeground(this.gradientEnd);
        gc.setBackground(this.gradientStart);
        gc.fillGradientRectangle(rect.x, rect.height / 2, rect.width, rect.height / 2, true);
        gc.dispose();
        this.setBackgroundImage(newImage);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = newImage;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color gradientEnd) {
        SWTGraphicUtil.dispose((Resource)this.gradientEnd);
        this.gradientEnd = gradientEnd;
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color gradientStart) {
        SWTGraphicUtil.dispose((Resource)this.gradientStart);
        this.gradientStart = gradientStart;
    }
}

