/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.LaunchContext;
import org.tizen.common.util.ArrayUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class LaunchesListener
implements ILaunchesListener2 {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LAUNCH_ATTR_KEY_IS_LAUNCHING = "LAUNCH_ATTR_KEY_IS_LAUNCHING";
    public static final String LAUNCH_ATTR_VALUE_LAUNCHING_ALREADY = "launched already";
    private List<LaunchContext> contexts = new ArrayList<LaunchContext>();

    public synchronized void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                ILaunchConfiguration config = launch.getLaunchConfiguration();
                if (config == null) {
                    this.logger.debug("launch configuration is null.");
                } else {
                    String serialNum;
                    String projectName = config.getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
                    if (this.getContext(projectName, serialNum = config.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "")) != null) {
                        this.logger.debug("launch already - project: {}, device serial: {}", (Object)projectName, (Object)serialNum);
                        launch.setAttribute(LAUNCH_ATTR_KEY_IS_LAUNCHING, LAUNCH_ATTR_VALUE_LAUNCHING_ALREADY);
                    } else {
                        this.logger.debug("Added - project: {}, device serial: {}", (Object)projectName, (Object)serialNum);
                    }
                    launch.setAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", serialNum);
                    this.addContext(projectName, serialNum);
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    private void addContext(String projectName, String deviceSerialNum) {
        LaunchContext context = new LaunchContext();
        this.setProjectName(context, projectName);
        context.setValue("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", deviceSerialNum);
        this.contexts.add(context);
    }

    protected void setProjectName(LaunchContext context, String projectName) {
        context.setValue("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", projectName);
    }

    protected IDevice getDevice(ILaunchConfiguration config) throws CoreException {
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        if (ArrayUtil.isEmpty(devices)) {
            return null;
        }
        String deviceName = config.getAttribute("org.tizen.common.CONFIG_ATTR_DEVICE_NAME", "");
        String deviceSerial = config.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "");
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (device.isEmulator() && deviceName.equals(device.getDeviceName())) {
                return device;
            }
            if (deviceSerial.equals(device.getSerialNumber())) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public LaunchContext getContext(String projectName, String serialNum) {
        int i = 0;
        while (i < this.contexts.size()) {
            LaunchContext tmpContext = this.contexts.get(i);
            if (LaunchesListener.getProjectName(tmpContext).equals(projectName) && tmpContext.getValue("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO").equals(serialNum)) {
                return tmpContext;
            }
            ++i;
        }
        return null;
    }

    private static String getProjectName(LaunchContext context) {
        return (String)context.getValue("org.tizen.common.CONFIG_ATTR_PROJECT_NAME");
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.removeLaunches(launches);
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.removeLaunches(launches);
    }

    public void removeLaunches(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                String projectName = launch.getLaunchConfiguration().getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
                String deviceSerialNum = launch.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO");
                LaunchContext context = this.getContext(projectName, deviceSerialNum);
                this.contexts.remove(context);
                this.logger.debug("removed - project: {}, device serial: {}", (Object)projectName, (Object)deviceSerialNum);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }
}

