/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.preferences.AbstractAuthPreference;

public class OAuthPreference
extends AbstractAuthPreference {
    public static final String ID_PREFERENCE = "org.tizen.common.rest.oauthType";
    public static IPreferenceStore store;
    private Composite container;
    private Button radioAccessToken;
    private Button radioAuthCode;
    private Button checkOpenBrowserForToken;
    private Text textGetTokenUrl;
    private Button checkOpenBrowserForCode;
    private Text textGetAuthCodeUrl;
    private Text textTokenUrl;
    private Text textClientId;
    private Text textClientSecret;
    private Text textGrantType;
    private Text textRedirectUri;
    private Button radioLocationInUrl;
    private Button radioLocationInJson;
    private Button radioParamAsUrl;
    private Button radioParamAsBody;
    private Group accessTokenGroup;
    private Group authCodeGroup;

    public OAuthPreference() {
        store = RestPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public String getID() {
        return ID_PREFERENCE;
    }

    @Override
    public Composite createContentArea(Composite parent) {
        this.container = this.createComposite(parent, 1);
        GridData gd = new GridData(768);
        this.container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        this.createLabel(this.container, RestUIMessages.OAuthPreference_label_radio_title);
        this.radioAccessToken = this.createRadioButton(this.container, RestUIMessages.OAuthPreference_label_radio_accessToken, "PREF_KEY_AUTH_OAUTH_METHOD", "PREF_VALUE_AUTH_OAUTH_METHOD_ACCESS_TOKEN");
        this.radioAccessToken.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OAuthPreference.this.updateEnabledStatus(true);
            }
        });
        this.accessTokenGroup = this.createGroup(this.container, "", 3, 1);
        this.checkOpenBrowserForToken = this.createButton((Composite)this.accessTokenGroup, 32, RestUIMessages.OAuthPreference_label_open_browser_for_token, 0, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.checkOpenBrowserForToken.setLayoutData((Object)gd);
        this.createLabel((Composite)this.accessTokenGroup, RestUIMessages.OAuthPreference_label_tokenUrl);
        this.textGetTokenUrl = this.createText((Composite)this.accessTokenGroup, 0, 2);
        this.textGetTokenUrl.setMessage(RestUIMessages.OAuthPreference_label_accessToken_desc);
        this.radioAuthCode = this.createRadioButton(this.container, RestUIMessages.OAuthPreference_label_radio_authCode, "PREF_KEY_AUTH_OAUTH_METHOD", "PREF_KEY_AUTH_OAUTH_METHOD_AUTH_CODE");
        this.radioAuthCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OAuthPreference.this.updateEnabledStatus(false);
            }
        });
        this.radioAuthCode.setSelection(true);
        this.authCodeGroup = this.createGroup(this.container, "", 3, 1);
        this.checkOpenBrowserForCode = this.createButton((Composite)this.authCodeGroup, 32, RestUIMessages.OAuthPreference_label_open_browser_for_code, 0, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.checkOpenBrowserForCode.setLayoutData((Object)gd);
        this.createLabel((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_codeUrl);
        this.textGetAuthCodeUrl = this.createText((Composite)this.authCodeGroup, 0, 2);
        this.createLabel((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_tokenUrl);
        this.textTokenUrl = this.createText((Composite)this.authCodeGroup, 0, 2);
        Group paramGroup = this.createGroup((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_param_as_group_title, 3, 3);
        this.createLabel((Composite)paramGroup, RestUIMessages.OAuthPreference_label_param_as_radio_title);
        this.radioParamAsUrl = this.createRadioButton((Composite)paramGroup, RestUIMessages.OAuthPreference_label_param_as_radio_url, "PREF_KEY_AUTH_OAUTH_PARAM_AS", "PREF_VALUE_AUTH_OAUTH_PARAM_AS_URL");
        this.radioParamAsBody = this.createRadioButton((Composite)paramGroup, RestUIMessages.OAuthPreference_label_param_as_radio_body, "PREF_KEY_AUTH_OAUTH_PARAM_AS", "PREF_VALUE_AUTH_OAUTH_PARAM_AS_BODY");
        this.createLabel((Composite)paramGroup, RestUIMessages.OAuthPreference_label_clientId);
        this.textClientId = this.createText((Composite)paramGroup, 0, 2);
        this.createLabel((Composite)paramGroup, RestUIMessages.OAuthPreference_label_clientSecret);
        this.textClientSecret = this.createText((Composite)paramGroup, 0x400800, 0, 2);
        this.createLabel((Composite)paramGroup, RestUIMessages.OAuthPreference_label_redirectUri);
        this.textRedirectUri = this.createText((Composite)paramGroup, 0, 2);
        this.createLabel((Composite)paramGroup, RestUIMessages.OAuthPreference_label_grantType);
        this.textGrantType = this.createText((Composite)paramGroup, 0, 2);
        this.createLabel((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_location_radio_title);
        this.radioLocationInUrl = this.createRadioButton((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_location_radio_url, "PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", "PREF_VALUE_AUTH_OAUTH_LOCATION_URL");
        this.radioLocationInJson = this.createRadioButton((Composite)this.authCodeGroup, RestUIMessages.OAuthPreference_label_location_radio_json, "PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", "PREF_VALUE_AUTH_OAUTH_LOCATION_JSON");
        return this.container;
    }

    private void updateEnabledStatus(boolean accessTokenSelected) {
        this.recursiveSetEnabled((Control)this.accessTokenGroup, accessTokenSelected);
        this.recursiveSetEnabled((Control)this.authCodeGroup, !accessTokenSelected);
    }

    private void loadData(String appId, boolean loadDefault) {
        String method = this.getValue(store, "PREF_KEY_AUTH_OAUTH_METHOD", appId, loadDefault);
        boolean openBrowserForToken = Boolean.parseBoolean(this.getValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_TOKEN", appId, loadDefault));
        String tokenUrl = this.getValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL", appId, loadDefault);
        boolean openBrowserForCode = Boolean.parseBoolean(this.getValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_CODE", appId, loadDefault));
        String codeUrl = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CODE_URL", appId, loadDefault);
        String tokenUrlByCode = this.getValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL_BY_CODE", appId, loadDefault);
        String paramAs = this.getValue(store, "PREF_KEY_AUTH_OAUTH_PARAM_AS", appId, loadDefault);
        String clientId = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_ID", appId, loadDefault);
        String clientSecret = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_SECRET", appId, loadDefault);
        String redirectUri = this.getValue(store, "PREF_KEY_AUTH_OAUTH_REDIRECT_URI", appId, loadDefault);
        String grantType = this.getValue(store, "PREF_KEY_AUTH_OAUTH_GRANT_TYPE", appId, loadDefault);
        String location = this.getValue(store, "PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", appId, loadDefault);
        boolean accessTokenSelected = "PREF_VALUE_AUTH_OAUTH_METHOD_ACCESS_TOKEN".equals(method);
        this.radioAuthCode.setSelection(!accessTokenSelected);
        this.radioAccessToken.setSelection(accessTokenSelected);
        this.updateEnabledStatus(accessTokenSelected);
        this.checkOpenBrowserForToken.setSelection(openBrowserForToken);
        this.textGetTokenUrl.setText(tokenUrl);
        this.checkOpenBrowserForCode.setSelection(openBrowserForCode);
        this.textGetAuthCodeUrl.setText(codeUrl);
        boolean paramAsUrl = "PREF_VALUE_AUTH_OAUTH_PARAM_AS_URL".equals(paramAs);
        this.radioParamAsUrl.setSelection(paramAsUrl);
        this.radioParamAsBody.setSelection(!paramAsUrl);
        this.textTokenUrl.setText(tokenUrlByCode);
        this.textClientId.setText(clientId);
        this.textClientSecret.setText(clientSecret);
        this.textRedirectUri.setText(redirectUri);
        this.textGrantType.setText(grantType);
        boolean locationUrlSelected = "PREF_VALUE_AUTH_OAUTH_LOCATION_URL".equals(location);
        this.radioLocationInUrl.setSelection(locationUrlSelected);
        this.radioLocationInJson.setSelection(!locationUrlSelected);
    }

    @Override
    public void loadData(String appId) {
        this.loadData(appId, false);
    }

    @Override
    public void performApply(String appId) {
        boolean accessTokenSelected = this.radioAccessToken.getSelection();
        String method = accessTokenSelected ? "PREF_VALUE_AUTH_OAUTH_METHOD_ACCESS_TOKEN" : "PREF_KEY_AUTH_OAUTH_METHOD_AUTH_CODE";
        boolean openBrowserForToken = this.checkOpenBrowserForToken.getSelection();
        String tokenUrl = this.textGetTokenUrl.getText();
        boolean openBrowserForCode = this.checkOpenBrowserForCode.getSelection();
        String codeUrl = this.textGetAuthCodeUrl.getText();
        String tokenUrlByCode = this.textTokenUrl.getText();
        boolean paramAsUrl = this.radioParamAsUrl.getSelection();
        String paramAs = paramAsUrl ? "PREF_VALUE_AUTH_OAUTH_PARAM_AS_URL" : "PREF_VALUE_AUTH_OAUTH_PARAM_AS_BODY";
        String clientId = this.textClientId.getText();
        String clientSecret = this.textClientSecret.getText();
        String redirectUri = this.textRedirectUri.getText();
        String grantType = this.textGrantType.getText();
        boolean locationUrlSelected = this.radioLocationInUrl.getSelection();
        String location = locationUrlSelected ? "PREF_VALUE_AUTH_OAUTH_LOCATION_URL" : "PREF_VALUE_AUTH_OAUTH_LOCATION_JSON";
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_METHOD", method, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_TOKEN", Boolean.toString(openBrowserForToken), appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL", tokenUrl, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_CODE", Boolean.toString(openBrowserForCode), appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_CODE_URL", codeUrl, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL_BY_CODE", tokenUrlByCode, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_PARAM_AS", paramAs, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_ID", clientId, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_SECRET", clientSecret, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_REDIRECT_URI", redirectUri, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_GRANT_TYPE", grantType, appId);
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", location, appId);
    }

    @Override
    public void performDefaults(String appId) {
        this.loadData(appId, true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.recursiveSetEnabled((Control)this.container, enabled);
        if (enabled) {
            this.updateEnabledStatus(this.radioAccessToken.getSelection());
        }
    }
}

