/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.views;

import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.tizen.common.rest.RestPlugin;

public class RESTProfiles
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IContributionItem[] items;
    private IServiceLocator mServiceLocator;
    private String profiles;
    private String selected;

    public RESTProfiles() {
    }

    public RESTProfiles(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        final IPreferenceStore pStore = RestPlugin.getDefault().getPreferenceStore();
        this.profiles = pStore.getString("PREF_KEY_USER_VARIABLES_PROFILE");
        this.selected = pStore.getString("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE");
        int size = this.profiles.length();
        if (size > 0) {
            String[] strs = this.profiles.split("\\|");
            this.items = new ActionContributionItem[strs.length];
            int i = 0;
            while (i < strs.length) {
                final String profile = strs[i];
                Action action = new Action(profile, 2){

                    public void run() {
                        pStore.setValue("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", profile);
                        try {
                            ((IPersistentPreferenceStore)pStore).save();
                        }
                        catch (IOException e) {
                            RestPlugin.log(e);
                        }
                    }
                };
                if (this.selected.equals(strs[i])) {
                    action.setChecked(true);
                }
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                this.items[i] = item;
                ++i;
            }
        }
        return this.items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.mServiceLocator = serviceLocator;
    }
}

