/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.util.Assert;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.engine.TemplateEngineFactory;
import org.tizen.common.verrari.model.ModelManager;
import org.tizen.common.verrari.realm.Query;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;

public class QueryFactory {
    protected static final String PATTERN_TYPE = "pattern";
    protected static final String STARTING_POINT = "_";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static QueryFactory instance = new QueryFactory();

    public static synchronized QueryFactory getInstance() {
        if (instance == null) {
            instance = new QueryFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(QueryFactory factory) {
        instance = factory;
    }

    public Query createTemplateQuery(Realm realm) {
        Assert.notNull((Object)realm);
        String templateType = realm.getAttribute("template-query-type");
        this.logger.debug("Template type :{}", (Object)templateType);
        PatternQuery query = new PatternQuery(realm.getAttribute("template-query-url"));
        return query;
    }

    public String query(String pattern, Map<String, Object> models) {
        PatternQuery query = new PatternQuery(pattern);
        return query.query(models);
    }

    class PatternQuery
    implements Query {
        protected final ITemplateEngine engine = TemplateEngineFactory.getInstance().create();

        public PatternQuery(String pattern) {
            TemplateManager templateManager = new TemplateManager();
            this.engine.setTemplateProvider((ITemplateProvider)templateManager);
            templateManager.addTemplate(QueryFactory.STARTING_POINT, (ITemplate)new InMemoryTemplate(pattern.getBytes(), "utf-8", (FactoryWithArgument)BufferFactory.getInstance()));
        }

        @Override
        public String query(Map<String, Object> args) {
            try {
                ModelManager manager = new ModelManager(args);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                QueryFactory.this.logger.debug("Model :{}, Model Manager :{}", args, (Object)manager);
                this.engine.generate(QueryFactory.STARTING_POINT, (IModelProvider)manager, (OutputStream)byteOut);
                String ret = new String(byteOut.toByteArray(), "utf-8");
                QueryFactory.this.logger.info("Query result :{}", (Object)ret);
                return ret;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

