/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.util.Assert;

public class SignatureUtility {
    public static final String AUTHOR_PREFIX = "author-signature";
    public static final String DISTRIBUTOR_PREFIX = "signature";
    public static final String PERIOD = ".";
    public static final String EXTENSION = "xml";
    private static final String regExp = "(signature(1|2|3|4|5|6|7|8|9)(\\d)*.xml)";
    private static final Pattern pattern = Pattern.compile("(signature(1|2|3|4|5|6|7|8|9)(\\d)*.xml)");

    public static boolean isSignatureFile(String name) {
        if (SignatureUtility.isAuthorSignatureFile(name)) {
            return true;
        }
        return SignatureUtility.isDistributorSignatureFile(name);
    }

    public static boolean isAuthorSignatureFile(String name) {
        return SignatureUtility.getAuthorFilename().equals(name);
    }

    public static boolean isDistributorSignatureFile(String name) {
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    public static String getAuthorFilename() {
        return "author-signature.xml";
    }

    public static String getDistributorFilename(int ordinal) {
        Assert.isTrue((ordinal > 0 ? 1 : 0) != 0);
        return DISTRIBUTOR_PREFIX + ordinal + PERIOD + EXTENSION;
    }
}

