/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.CertificateIntroButtonInformation;
import org.tizen.common.sign.ui.CertificateType;
import org.tizen.common.sign.ui.CertificateTypeExtensions;
import org.tizen.common.sign.ui.ICertificateCreationHandler;
import org.tizen.common.sign.ui.dialog.CertificateCreationWizardDialog;
import org.tizen.common.sign.ui.dialog.CertificateIntroDialog;
import org.tizen.common.sign.ui.wizard.CertificateCreationWizard;
import org.tizen.common.util.SWTUtil;

public class CertificateCreationHandler
extends AbstractHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int CLOSE = -1;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        List<CertificateType> certificateTypes = CertificateTypeExtensions.getCertificateTypes();
        if (certificateTypes.size() >= 1) {
            CertificateType extCertificate = certificateTypes.get(0);
            CertificateIntroButtonInformation extButtonInfo = extCertificate.getButtonInfo();
            CertificateIntroDialog dialog = new CertificateIntroDialog(SWTUtil.getShell(), extButtonInfo);
            int selected = dialog.open();
            if (selected == 1001) {
                ICertificateCreationHandler handler = extButtonInfo.getHandler();
                if (handler != null) {
                    return handler.execute();
                }
                this.logger.error("Failed to execute certificate creation wizard. handler is null");
                return -1;
            }
            if (selected == 64) {
                return -1;
            }
        }
        CertificateCreationWizard wizard = new CertificateCreationWizard();
        CertificateCreationWizardDialog dialog = new CertificateCreationWizardDialog(SWTUtil.getShell(), (IWizard)wizard);
        return dialog.open();
    }
}

