/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.log.model.LogMessageInfo;
import org.tizen.common.connection.log.parser.IDlogParser;
import org.tizen.sdblib.util.LogLevel;

public class DlogParser
implements IDlogParser {
    public static final String DLOG_FORMAT_REGEX = "^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s([VDIWEF])\\/(.+)\\s+P\\s(\\d*),\\sT\\s(\\d+)\\]$";
    private Pattern pattern = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s([VDIWEF])\\/(.+)\\s+P\\s(\\d*),\\sT\\s(\\d+)\\]$");

    @Override
    public LogMessageInfo parse(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.matches()) {
            LogMessageInfo info = new LogMessageInfo();
            info.setTime(matcher.group(1));
            info.setLogLevel(LogLevel.getByLetter((String)matcher.group(2)));
            info.setTag(matcher.group(3).trim());
            info.setPidString(matcher.group(4));
            info.setTidString(matcher.group(5));
            return info;
        }
        return null;
    }
}

