/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.ui;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.ui.TizenRemoteFileContentProvider;
import org.tizen.common.connection.ui.TizenRemoteFileLabelProvider;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class TizenRemoteFileDialog {
    private TizenRemoteFileDialogResult result = TizenRemoteFileDialogResult.CANCEL;
    private IDevice device;
    private Shell shell;
    private Display display;
    private boolean isDirOnly = false;
    private Label path;
    private String defaultPath;
    private FileEntry selectedDir;
    private Tree pathTree;
    private TreeViewer pathTreeViewer;
    private Composite upper;
    private boolean enableMultiSelection = false;
    TizenRemoteFileContentProvider remoteContentProvider = null;

    public TizenRemoteFileDialog(Shell parent, String dlgTitle, IDevice device, boolean isDirOnly, String defaultPath) throws IllegalArgumentException {
        if (parent == null || device == null) {
            throw new IllegalArgumentException();
        }
        this.display = parent.getDisplay();
        this.shell = this.createNewShell(parent);
        this.shell.setText(dlgTitle);
        this.shell.setSize(600, 600);
        this.shell.setImage(ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator.png").createImage());
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        TizenRemoteFileDialog.this.shell.close();
                        event.detail = 0;
                        event.doit = false;
                        break;
                    }
                }
            }
        });
        this.device = device;
        this.isDirOnly = isDirOnly;
        this.setDefaultPath(defaultPath);
        this.createControls((Composite)this.shell);
    }

    public TizenRemoteFileDialog(Shell parent, String dlgTitle, IDevice device, boolean isDirOnly, String defaultPath, boolean enableMultiSelection) {
        this(parent, dlgTitle, device, isDirOnly, defaultPath);
        this.enableMultiSelection = enableMultiSelection;
    }

    public TizenRemoteFileDialogResult open() {
        this.shell.open();
        this.runEventLoop(this.shell);
        return this.result;
    }

    public FileEntry getSelectedFileEntry() {
        return this.selectedDir;
    }

    private void createControls(Composite parent) {
        this.upper = new Composite(parent, 0);
        this.setUpperLayout(this.upper);
        this.createPathLabels(this.upper);
        this.createPathTree(this.upper);
        this.fillPathTree();
        Composite lower = new Composite(parent, 0);
        this.setLowerLayout(lower);
        this.createButtons(lower);
    }

    private void fillPathTree() {
        this.createTreeColumn();
        this.createTreeViewer();
        FileEntry root = this.device.getRoot();
        this.pathTreeViewer.setInput((Object)root);
        FileEntry entry = this.device.getFileEntry(this.defaultPath);
        this.pathTreeViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
        if (this.pathTree.getSelection().length > 0) {
            this.pathTreeViewer.getTree().setTopItem(this.pathTree.getSelection()[0]);
        }
        this.remoteContentProvider.setInitialize(true);
        this.pathTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                TreeItem[] items = TizenRemoteFileDialog.this.pathTree.getSelection();
                if (items.length == 1 && (object = items[0].getData()) instanceof FileEntry) {
                    TizenRemoteFileDialog.this.selectedDir = (FileEntry)object;
                    TizenRemoteFileDialog.this.path.setText(TizenRemoteFileDialog.this.selectedDir.getFullPath());
                }
                TreeColumn[] treeColumnArray = TizenRemoteFileDialog.this.pathTree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }
        });
    }

    private void createTreeViewer() {
        this.pathTreeViewer = new TreeViewer(this.pathTree);
        this.remoteContentProvider = new TizenRemoteFileContentProvider(this.isDirOnly);
        this.pathTreeViewer.setContentProvider((IContentProvider)this.remoteContentProvider);
        TizenRemoteFileLabelProvider remoteLabelProvider = new TizenRemoteFileLabelProvider();
        this.pathTreeViewer.setLabelProvider((IBaseLabelProvider)remoteLabelProvider);
    }

    private void createTreeColumn() {
        final TreeColumn nameColumn = new TreeColumn(this.pathTree, 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(100);
        this.upper.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = TizenRemoteFileDialog.this.upper.getClientArea();
                Point size = TizenRemoteFileDialog.this.pathTree.computeSize(-1, -1);
                ScrollBar vBar = TizenRemoteFileDialog.this.pathTree.getVerticalBar();
                int width = area.width - ((TizenRemoteFileDialog)TizenRemoteFileDialog.this).pathTree.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + TizenRemoteFileDialog.this.pathTree.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = TizenRemoteFileDialog.this.pathTree.getSize();
                if (oldSize.x > area.width) {
                    nameColumn.setWidth(width);
                    TizenRemoteFileDialog.this.pathTree.setSize(area.width, area.height);
                } else {
                    TizenRemoteFileDialog.this.pathTree.setSize(area.width, area.height);
                    nameColumn.setWidth(width);
                }
            }
        });
    }

    private Shell createNewShell(Shell parent) {
        this.shell = new Shell(this.display, 67680);
        this.setDefaultLayout();
        return this.shell;
    }

    private void setDefaultLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.shell.setLayout((Layout)layout);
    }

    private void setUpperLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
    }

    private void setLowerLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData((Object)data);
    }

    private void createPathLabels(Composite parent) {
        Label pathLabel = new Label(parent, 0);
        this.setPathLabelLayout(pathLabel);
        pathLabel.setText("Path : ");
        this.path = new Label(parent, 0);
        this.setPathLayout(this.path);
        this.path.setText(this.defaultPath);
    }

    private void setPathLabelLayout(Label label) {
        GridData data = new GridData();
        label.setLayoutData((Object)data);
    }

    private void setPathLayout(Label pPath) {
        GridData data = new GridData(768);
        pPath.setLayoutData((Object)data);
    }

    private void createPathTree(Composite pParent) {
        int style = 65536;
        if (this.enableMultiSelection) {
            style |= 2;
        }
        this.pathTree = new Tree(pParent, style);
        this.setTreeLayout(this.pathTree);
    }

    private void setTreeLayout(Tree tree) {
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        tree.setLayoutData((Object)data);
    }

    private void createButtons(Composite parent) {
        Button okButton = new Button(parent, 8);
        this.setOkButtonLayout(okButton);
        okButton.setText("OK");
        okButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 4: {
                        if (event.button != 1) break;
                        TizenRemoteFileDialog.this.result = TizenRemoteFileDialogResult.OK;
                        TizenRemoteFileDialog.this.shell.dispose();
                    }
                }
            }
        });
        Button cancelButton = new Button(parent, 8);
        this.setCancelButtonLayout(okButton);
        cancelButton.setText("Cancel");
        cancelButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 4: {
                        if (event.button != 1) break;
                        TizenRemoteFileDialog.this.result = TizenRemoteFileDialogResult.CANCEL;
                        TizenRemoteFileDialog.this.shell.dispose();
                    }
                }
            }
        });
    }

    private void setOkButtonLayout(Button button) {
        GridData data = new GridData();
        data.widthHint = 50;
        button.setLayoutData((Object)data);
    }

    private void setCancelButtonLayout(Button button) {
        GridData data = new GridData();
        data.widthHint = 50;
        button.setLayoutData((Object)data);
    }

    private void runEventLoop(Shell loopShell) {
        Display tmpDisplay = loopShell.getDisplay();
        while (!loopShell.isDisposed()) {
            if (tmpDisplay.readAndDispatch()) continue;
            tmpDisplay.sleep();
        }
        this.display.update();
    }

    private void setDefaultPath(String basePath) {
        this.defaultPath = basePath == null ? "/" : basePath;
    }

    public static enum TizenRemoteFileDialogResult {
        OK,
        CANCEL;

    }
}

