/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.TargetToolBarManager;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.ListChangeListener;
import org.tizen.emulator.manager.vms.ManagedVMKeeper;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public class VMChangeListener<VMProperty>
implements ListChangeListener<VMProperty> {
    private static final Logger logger = LoggerFactory.getLogger(VMChangeListener.class);
    private TargetToolBarManager toolbarManager = ConnectionPlugin.getDefault().getTargetToolBarManager();

    static {
        try {
            FilePathResources.initialize();
            EmulatorManager.initialize((VMKeeper)new ManagedVMKeeper());
        }
        catch (Throwable e) {
            logger.error("vm library has error occurred: " + e.getMessage());
        }
    }

    public void elementRemoved(VMProperty object) {
        String deviceName = ((VMProperty)object).getPropertyValue().vmName;
        logger.debug(String.format("VM(%s) has been removed", deviceName));
        DeviceDescriptor device = this.toolbarManager.getDeviceDescriptor(deviceName);
        if (device != null) {
            this.toolbarManager.removeDeviceDescriptor(deviceName);
            this.toolbarManager.fireLaunchTargetsChanged(device, 8);
        }
    }

    public void elementModified(VMProperty object) {
    }

    public void elementAdded(VMProperty object) {
        VMPropertyValue property = ((VMProperty)object).getPropertyValue();
        String deviceName = property.vmName;
        logger.debug(String.format("VM(%s) has been added", deviceName));
        if (!this.toolbarManager.getDeviceDescriptors().containsKey(deviceName)) {
            DeviceDescriptor device = new DeviceDescriptor(deviceName, String.format("%s (offline)", deviceName));
            device.setDeviceType(1);
            device.setTooltipName(this.toolbarManager.createTooltipName(property.vmName, property.getProfile(), property.getPlatform().getVersion().toString(), property.resolution.getType()));
            this.toolbarManager.addDeviceDescriptor(device);
            this.toolbarManager.fireLaunchTargetsChanged(device, 4);
        } else {
            this.toolbarManager.fireLaunchTargetsChanged(this.toolbarManager.getDeviceDescriptors().get(deviceName), 4);
        }
    }

    public void addVMChangeListener() {
        VMKeeper.addListChangeListener((ListChangeListener)this);
    }

    public void removeVMChangeListener() {
        VMKeeper.addListChangeListener((ListChangeListener)this);
    }
}

