/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import zipeditor.LocalFileEditorInput;
import zipeditor.Messages;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Node;
import zipeditor.operations.ExtractOperation;
import zipeditor.operations.OpenFileOperation;

public class Utils {
    public static int computeTotalNumber(Node[] nodes, IProgressMonitor monitor) {
        int result = 0;
        int i = 0;
        while (i < nodes.length) {
            if (monitor.isCanceled()) break;
            result = nodes[i].isFolder() ? (result += Utils.computeTotalNumber(nodes[i].getChildren(), monitor)) : ++result;
            ++i;
        }
        return result;
    }

    public static int computeTotalNumber(File[] files, IProgressMonitor monitor) {
        if (files == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < files.length) {
            if (monitor.isCanceled()) break;
            result = files[i].isDirectory() ? (result += Utils.computeTotalNumber(files[i].listFiles(), monitor)) : ++result;
            ++i;
        }
        return result;
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static IFileStore getFileStore(File file) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getParentFile().getAbsolutePath()));
        return fileStore.getChild(file.getName());
    }

    public static void openFilesFromNodes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        ExtractAndOpenJob job = new ExtractAndOpenJob(nodes);
        job.schedule();
    }

    private static void internalOpenFilesFromNodes(Node[] nodes, IProgressMonitor monitor) {
        File tmpDir = nodes[0].getModel().getTempDir();
        ExtractOperation extractOperation = new ExtractOperation();
        OpenFileOperation openFileOperation = new OpenFileOperation();
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            monitor.subTask(node.getName());
            File file = extractOperation.extract(node, tmpDir, true, monitor);
            openFileOperation.execute(file);
            ZipEditorPlugin.getDefault().addFileMonitor(file, node);
            monitor.worked(1);
            ++i;
        }
    }

    public static IEditorInput createEditorInput(IFileStore fileStore) {
        IFile workspaceFile = Utils.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        try {
            return new FileStoreEditorInput(fileStore);
        }
        catch (Throwable throwable) {
            return new LocalFileEditorInput(fileStore);
        }
    }

    public static String getEditorId(IFileStore file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), Utils.getContentType(file));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(file.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = fileStore.openInputStream(0, null);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
            return iContentType;
        }
        catch (IOException e) {
            ZipEditorPlugin.log(e);
            return null;
        }
        catch (CoreException e) {
            if (!(e.getStatus().getException() instanceof FileNotFoundException)) {
                ZipEditorPlugin.log((Object)e);
            }
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                ZipEditorPlugin.log(e);
            }
        }
    }

    private static IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile[] files = Utils.filterNonExistentFiles(workspace.getRoot().findFilesForLocation((IPath)new Path(fileStore.toURI().getPath())));
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        if (Utils.isUIThread()) {
            return Utils.selectWorkspaceFile(files);
        }
        final IFile[] result = new IFile[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = Utils.selectWorkspaceFile(files);
            }
        });
        return result[0];
    }

    private static IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFile) {
                    IPath path = ((IFile)element).getFullPath();
                    return path != null ? path.toString() : "";
                }
                return super.getText(element);
            }
        });
        dialog.setElements((Object[])files);
        dialog.setTitle(Messages.getString("OpenFileOperation.0"));
        dialog.setMessage(Messages.getString("OpenFileOperation.1"));
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public static void readAndWrite(InputStream in, OutputStream out, boolean closeOut) throws IOException {
        try {
            if (in != null) {
                byte[] buf = new byte[8000];
                int count = 0;
                while ((count = in.read(buf)) != -1) {
                    out.write(buf, 0, count);
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (closeOut) {
                out.close();
            }
        }
    }

    public static boolean allNodesAreFileNodes(IStructuredSelection selection) {
        for (Object object : selection) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node node = (Node)((Object)object);
            if (!node.isFolder()) continue;
            return false;
        }
        return true;
    }

    public static Node[] getSelectedNodes(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return new Node[0];
        }
        Object[] objects = ((IStructuredSelection)selection).toArray();
        Node[] nodes = new Node[objects.length];
        System.arraycopy(objects, 0, nodes, 0, objects.length);
        return nodes;
    }

    private Utils() {
    }

    private static class ExtractAndOpenJob
    extends Job {
        private Node[] fNodes;

        public ExtractAndOpenJob(Node[] nodes) {
            super(Messages.getString("Utils.0"));
            this.fNodes = nodes;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString("Utils.1"), this.fNodes.length);
            try {
                Utils.internalOpenFilesFromNodes(this.fNodes, monitor);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

